/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4k.decoder;

import com.sksamuel.avro4k.decoder.FromAvroValue;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.serialization.SerializationException;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/sksamuel/avro4k/decoder/StringFromAvroValue;", "Lcom/sksamuel/avro4k/decoder/FromAvroValue;", "", "", "()V", "fromValue", "value", "avro4k-core"})
public final class StringFromAvroValue
implements FromAvroValue<Object, String> {
    public static final StringFromAvroValue INSTANCE;

    @Override
    @NotNull
    public String fromValue(@Nullable Object value) {
        String string;
        Object object = value;
        if (object instanceof String) {
            string = (String)value;
        } else if (object instanceof Utf8) {
            string = value.toString();
        } else if (object instanceof GenericData.Fixed) {
            byte[] byArray = ((GenericData.Fixed)value).bytes();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"value.bytes()");
            byte[] byArray2 = byArray;
            boolean bl = false;
            string = new String(byArray2, Charsets.UTF_8);
        } else if (object instanceof byte[]) {
            boolean bl = false;
            string = new String((byte[])value, Charsets.UTF_8);
        } else if (object instanceof CharSequence) {
            string = value.toString();
        } else if (object instanceof ByteBuffer) {
            byte[] byArray = ((ByteBuffer)value).array();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"value.array()");
            byte[] byArray3 = byArray;
            boolean bl = false;
            string = new String(byArray3, Charsets.UTF_8);
        } else {
            if (object == null) {
                throw (Throwable)new SerializationException("Cannot decode <null> as a string");
            }
            throw (Throwable)new SerializationException("Unsupported type for String [is " + value.getClass() + ']');
        }
        return string;
    }

    private StringFromAvroValue() {
    }

    static {
        StringFromAvroValue stringFromAvroValue;
        INSTANCE = stringFromAvroValue = new StringFromAvroValue();
    }
}

