/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4k.decoder;

import com.sksamuel.avro4k.AnnotationExtractor;
import com.sksamuel.avro4k.FieldNaming;
import com.sksamuel.avro4k.decoder.ByteArrayDecoder;
import com.sksamuel.avro4k.decoder.EnumFromAvroValue;
import com.sksamuel.avro4k.decoder.FieldDecoder;
import com.sksamuel.avro4k.decoder.InlineDecoder;
import com.sksamuel.avro4k.decoder.ListDecoder;
import com.sksamuel.avro4k.decoder.MapDecoder;
import com.sksamuel.avro4k.decoder.SealedClassDecoder;
import com.sksamuel.avro4k.decoder.StringFromAvroValue;
import com.sksamuel.avro4k.schema.SchemasKt;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.modules.SerializersModule;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalSerializationApi
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0004H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u000bH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0014H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020'H\u0016J\n\u0010(\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010)\u001a\u00020#H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006*"}, d2={"Lcom/sksamuel/avro4k/decoder/RecordDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "Lcom/sksamuel/avro4k/decoder/FieldDecoder;", "desc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "record", "Lorg/apache/avro/generic/GenericRecord;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "(Lkotlinx/serialization/descriptors/SerialDescriptor;Lorg/apache/avro/generic/GenericRecord;Lkotlinx/serialization/modules/SerializersModule;)V", "currentIndex", "", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "decodeAny", "", "decodeBoolean", "", "decodeByte", "", "decodeDouble", "", "decodeElementIndex", "decodeEnum", "enumDescriptor", "decodeFloat", "", "decodeInt", "decodeLong", "", "decodeNotNullMark", "decodeString", "", "field", "Lorg/apache/avro/Schema$Field;", "fieldSchema", "Lorg/apache/avro/Schema;", "fieldValue", "resolvedFieldName", "avro4k-core"})
public final class RecordDecoder
extends AbstractDecoder
implements FieldDecoder {
    private int currentIndex;
    private final SerialDescriptor desc;
    private final GenericRecord record;
    @NotNull
    private final SerializersModule serializersModule;

    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        boolean valueType = new AnnotationExtractor(descriptor2.getAnnotations()).valueType();
        Object value = this.fieldValue();
        SerialKind serialKind = descriptor2.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE)) {
            AbstractDecoder abstractDecoder;
            if (valueType) {
                abstractDecoder = new InlineDecoder(this.fieldValue(), this.getSerializersModule());
            } else {
                Object object = value;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.apache.avro.generic.GenericRecord");
                }
                abstractDecoder = new RecordDecoder(descriptor2, (GenericRecord)object, this.getSerializersModule());
            }
            compositeDecoder = (CompositeDecoder)abstractDecoder;
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            Object object = value;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
            }
            compositeDecoder = new MapDecoder(descriptor2, this.fieldSchema(), (Map)object, this.getSerializersModule());
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            CompositeDecoder decoder;
            CompositeDecoder compositeDecoder2;
            Object object;
            if (Intrinsics.areEqual((Object)descriptor2.getElementDescriptor(0).getKind(), (Object)PrimitiveKind.BYTE.INSTANCE)) {
                AbstractDecoder abstractDecoder;
                object = value;
                if (object instanceof List) {
                    Object object2 = value;
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.Byte>");
                    }
                    abstractDecoder = new ByteArrayDecoder(CollectionsKt.toByteArray((Collection)((List)object2)), this.getSerializersModule());
                } else if (object instanceof Object[]) {
                    Object object3 = value;
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<kotlin.Byte>");
                    }
                    abstractDecoder = new ByteArrayDecoder(ArraysKt.toByteArray((Byte[])((Byte[])object3)), this.getSerializersModule());
                } else if (object instanceof byte[]) {
                    abstractDecoder = new ByteArrayDecoder((byte[])value, this.getSerializersModule());
                } else if (object instanceof ByteBuffer) {
                    byte[] byArray = ((ByteBuffer)value).array();
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"value.array()");
                    abstractDecoder = new ByteArrayDecoder(byArray, this.getSerializersModule());
                } else {
                    abstractDecoder = this;
                }
                compositeDecoder2 = (CompositeDecoder)abstractDecoder;
            } else {
                object = value;
                compositeDecoder2 = (CompositeDecoder)(object instanceof List ? (Decoder)new ListDecoder(this.fieldSchema(), (List)value, this.getSerializersModule()) : (object instanceof Object[] ? (Decoder)new ListDecoder(this.fieldSchema(), ArraysKt.asList((Object[])((Object[])value)), this.getSerializersModule()) : (Decoder)this));
            }
            compositeDecoder = decoder = compositeDecoder2;
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)PolymorphicKind.SEALED.INSTANCE)) {
            Object object = value;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.apache.avro.generic.GenericRecord");
            }
            compositeDecoder = (CompositeDecoder)new SealedClassDecoder(descriptor2, (GenericRecord)object, this.getSerializersModule());
        } else {
            throw (Throwable)new UnsupportedOperationException("Decoding descriptor of kind " + descriptor2.getKind() + " is currently not supported");
        }
        return compositeDecoder;
    }

    private final Object fieldValue() {
        return this.record.get(this.resolvedFieldName());
    }

    private final String resolvedFieldName() {
        return FieldNaming.Companion.invoke(this.desc, this.currentIndex).name();
    }

    private final Schema.Field field() {
        Schema.Field field = this.record.getSchema().getField(this.resolvedFieldName());
        Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"record.schema.getField(resolvedFieldName())");
        return field;
    }

    @Override
    @NotNull
    public Schema fieldSchema() {
        Schema schema;
        Schema schema2 = schema = this.field().schema();
        Intrinsics.checkExpressionValueIsNotNull((Object)schema2, (String)"schema");
        return schema2.isNullable() ? SchemasKt.extractNonNull(schema) : schema;
    }

    @NotNull
    public String decodeString() {
        return StringFromAvroValue.INSTANCE.fromValue(this.fieldValue());
    }

    public boolean decodeBoolean() {
        Object v = this.fieldValue();
        if (!(v instanceof Boolean)) {
            if (v == null) {
                throw (Throwable)new SerializationException("Cannot decode <null> as a Boolean");
            }
            throw (Throwable)new SerializationException("Unsupported type for Boolean " + v.getClass());
        }
        return (Boolean)v;
    }

    @Override
    @Nullable
    public Object decodeAny() {
        return this.fieldValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte decodeByte() {
        byte by;
        Object v = this.fieldValue();
        if (v instanceof Byte) {
            by = ((Number)v).byteValue();
            return by;
        } else if (v instanceof Integer) {
            if (((Number)v).intValue() >= 255) throw (Throwable)new SerializationException("Out of bound integer cannot be converted to byte [" + v + ']');
            by = (byte)((Number)v).intValue();
            return by;
        } else {
            if (v != null) throw (Throwable)new SerializationException("Unsupported type for Byte " + v.getClass());
            throw (Throwable)new SerializationException("Cannot decode <null> as a Byte");
        }
    }

    public boolean decodeNotNullMark() {
        return this.fieldValue() != null;
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Object v1;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)enumDescriptor, (String)"enumDescriptor");
            Object object = this.fieldValue();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            String symbol = EnumFromAvroValue.INSTANCE.fromValue(object);
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)enumDescriptor.getElementsCount());
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                int it = ((Number)t).intValue();
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)enumDescriptor.getElementName(it), (Object)symbol)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        Integer n = v1;
        return n != null ? n : -1;
    }

    public float decodeFloat() {
        Object v = this.fieldValue();
        if (!(v instanceof Float)) {
            if (v == null) {
                throw (Throwable)new SerializationException("Cannot decode <null> as a Float");
            }
            throw (Throwable)new SerializationException("Unsupported type for Float " + v.getClass());
        }
        return ((Number)v).floatValue();
    }

    public int decodeInt() {
        Object v = this.fieldValue();
        if (!(v instanceof Integer)) {
            if (v == null) {
                throw (Throwable)new SerializationException("Cannot decode <null> as a Int");
            }
            throw (Throwable)new SerializationException("Unsupported type for Int " + v.getClass());
        }
        return ((Number)v).intValue();
    }

    public long decodeLong() {
        long l;
        Object v = this.fieldValue();
        if (v instanceof Long) {
            l = ((Number)v).longValue();
        } else if (v instanceof Integer) {
            l = ((Number)v).intValue();
        } else {
            if (v == null) {
                throw (Throwable)new SerializationException("Cannot decode <null> as a Long");
            }
            throw (Throwable)new SerializationException("Unsupported type for Long [is " + v.getClass() + ']');
        }
        return l;
    }

    public double decodeDouble() {
        double d;
        Object v = this.fieldValue();
        if (v instanceof Double) {
            d = ((Number)v).doubleValue();
        } else if (v instanceof Float) {
            d = ((Number)v).floatValue();
        } else {
            if (v == null) {
                throw (Throwable)new SerializationException("Cannot decode <null> as a Double");
            }
            throw (Throwable)new SerializationException("Unsupported type for Double " + v.getClass());
        }
        return d;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        int n = this.currentIndex;
        this.currentIndex = n + 1;
        return this.currentIndex < descriptor2.getElementsCount() ? this.currentIndex : -1;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public RecordDecoder(@NotNull SerialDescriptor desc, @NotNull GenericRecord record, @NotNull SerializersModule serializersModule) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        Intrinsics.checkParameterIsNotNull((Object)record, (String)"record");
        Intrinsics.checkParameterIsNotNull((Object)serializersModule, (String)"serializersModule");
        this.desc = desc;
        this.record = record;
        this.serializersModule = serializersModule;
        this.currentIndex = -1;
    }
}

