/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4k.decoder;

import com.sksamuel.avro4k.decoder.ListDecoder;
import com.sksamuel.avro4k.decoder.RecordDecoder;
import com.sksamuel.avro4k.decoder.StringFromAvroValue;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.modules.SerializersModule;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericRecord;
import org.jetbrains.annotations.NotNull;

@ExperimentalSerializationApi
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0011H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0013H\u0016J\n\u0010%\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lcom/sksamuel/avro4k/decoder/MapDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "Lkotlinx/serialization/encoding/CompositeDecoder;", "desc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "schema", "Lorg/apache/avro/Schema;", "map", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "(Lkotlinx/serialization/descriptors/SerialDescriptor;Lorg/apache/avro/Schema;Ljava/util/Map;Lkotlinx/serialization/modules/SerializersModule;)V", "entries", "", "Lkotlin/Pair;", "", "index", "", "key", "", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginStructure", "descriptor", "decodeBoolean", "", "decodeByte", "", "decodeDouble", "", "decodeElementIndex", "decodeFloat", "", "decodeInt", "decodeLong", "", "decodeString", "value", "avro4k-core"})
public final class MapDecoder
extends AbstractDecoder
implements CompositeDecoder {
    private final List<Pair<Object, Object>> entries;
    private int index;
    private String key;
    private final SerialDescriptor desc;
    private final Schema schema;
    @NotNull
    private final SerializersModule serializersModule;

    @NotNull
    public String decodeString() {
        Pair<Object, Object> entry = this.entries.get(this.index / 2);
        Object value = this.index % 2 == 0 ? entry.getFirst() : entry.getSecond();
        return StringFromAvroValue.INSTANCE.fromValue(value);
    }

    private final Object value() {
        return this.entries.get(this.index / 2).getSecond();
    }

    public float decodeFloat() {
        Object v = this.value();
        if (!(v instanceof Float)) {
            if (v == null) {
                throw (Throwable)new SerializationException("Cannot decode <null> as a Float");
            }
            throw (Throwable)new SerializationException("Unsupported type for Float " + v.getClass());
        }
        return ((Number)v).floatValue();
    }

    public int decodeInt() {
        Object v = this.value();
        if (!(v instanceof Integer)) {
            if (v == null) {
                throw (Throwable)new SerializationException("Cannot decode <null> as a Int");
            }
            throw (Throwable)new SerializationException("Unsupported type for Int " + v.getClass());
        }
        return ((Number)v).intValue();
    }

    public long decodeLong() {
        long l;
        Object v = this.value();
        if (v instanceof Long) {
            l = ((Number)v).longValue();
        } else if (v instanceof Integer) {
            l = ((Number)v).intValue();
        } else {
            if (v == null) {
                throw (Throwable)new SerializationException("Cannot decode <null> as a Long");
            }
            throw (Throwable)new SerializationException("Unsupported type for Long " + v.getClass());
        }
        return l;
    }

    public double decodeDouble() {
        double d;
        Object v = this.value();
        if (v instanceof Double) {
            d = ((Number)v).doubleValue();
        } else if (v instanceof Float) {
            d = ((Number)v).floatValue();
        } else {
            if (v == null) {
                throw (Throwable)new SerializationException("Cannot decode <null> as a Double");
            }
            throw (Throwable)new SerializationException("Unsupported type for Double " + v.getClass());
        }
        return d;
    }

    public byte decodeByte() {
        byte by;
        Object v = this.value();
        if (v instanceof Byte) {
            by = ((Number)v).byteValue();
        } else if (v instanceof Integer) {
            by = (byte)((Number)v).intValue();
        } else {
            if (v == null) {
                throw (Throwable)new SerializationException("Cannot decode <null> as a Byte");
            }
            throw (Throwable)new SerializationException("Unsupported type for Byte " + v.getClass());
        }
        return by;
    }

    public boolean decodeBoolean() {
        Object v = this.value();
        if (!(v instanceof Boolean)) {
            if (v == null) {
                throw (Throwable)new SerializationException("Cannot decode <null> as a Boolean");
            }
            throw (Throwable)new SerializationException("Unsupported type for Boolean " + v.getClass());
        }
        return (Boolean)v;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        int n = this.index;
        this.index = n + 1;
        return this.index == this.entries.size() * 2 ? -1 : this.index;
    }

    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        SerialKind serialKind = descriptor2.getKind();
        if (serialKind == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.descriptors.StructureKind");
        }
        StructureKind structureKind = (StructureKind)serialKind;
        if (Intrinsics.areEqual((Object)structureKind, (Object)StructureKind.CLASS.INSTANCE)) {
            Object object = this.value();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.apache.avro.generic.GenericRecord");
            }
            compositeDecoder = (CompositeDecoder)new RecordDecoder(descriptor2, (GenericRecord)object, this.getSerializersModule());
        } else if (Intrinsics.areEqual((Object)structureKind, (Object)StructureKind.LIST.INSTANCE)) {
            Schema schema = this.schema.getValueType();
            Intrinsics.checkExpressionValueIsNotNull((Object)schema, (String)"schema.valueType");
            Object object = this.value();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.apache.avro.generic.GenericArray<*>");
            }
            compositeDecoder = (CompositeDecoder)new ListDecoder(schema, (List)((GenericArray)object), this.getSerializersModule());
        } else if (Intrinsics.areEqual((Object)structureKind, (Object)StructureKind.MAP.INSTANCE)) {
            Schema schema = this.schema.getValueType();
            Intrinsics.checkExpressionValueIsNotNull((Object)schema, (String)"schema.valueType");
            Object object = this.value();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
            }
            compositeDecoder = new MapDecoder(descriptor2, schema, (Map)object, this.getSerializersModule());
        } else {
            if (Intrinsics.areEqual((Object)structureKind, (Object)StructureKind.OBJECT.INSTANCE)) {
                throw (Throwable)new UnsupportedOperationException("Objects are not supported right now as serialization kind");
            }
            throw new NoWhenBranchMatchedException();
        }
        return compositeDecoder;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public MapDecoder(@NotNull SerialDescriptor desc, @NotNull Schema schema, @NotNull Map<?, ?> map, @NotNull SerializersModule serializersModule) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        Intrinsics.checkParameterIsNotNull((Object)serializersModule, (String)"serializersModule");
        this.desc = desc;
        this.schema = schema;
        this.serializersModule = serializersModule;
        boolean bl = this.schema.getType() == Schema.Type.MAP;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.entries = MapsKt.toList(map);
        this.index = -1;
    }
}

