/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4k.decoder;

import com.sksamuel.avro4k.decoder.EnumFromAvroValue;
import com.sksamuel.avro4k.decoder.FieldDecoder;
import com.sksamuel.avro4k.decoder.MapDecoder;
import com.sksamuel.avro4k.decoder.RecordDecoder;
import com.sksamuel.avro4k.decoder.SealedClassDecoder;
import com.sksamuel.avro4k.decoder.StringFromAvroValue;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.modules.SerializersModule;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalSerializationApi
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u0012H\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\fH\u0016J\b\u0010#\u001a\u00020$H\u0016J!\u0010%\u001a\u0002H&\"\u0004\b\u0000\u0010&2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H&0(H\u0016\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u0004H\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006-"}, d2={"Lcom/sksamuel/avro4k/decoder/ListDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "Lcom/sksamuel/avro4k/decoder/FieldDecoder;", "schema", "Lorg/apache/avro/Schema;", "array", "", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "(Lorg/apache/avro/Schema;Ljava/util/List;Lkotlinx/serialization/modules/SerializersModule;)V", "index", "", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeAny", "decodeBoolean", "", "decodeByte", "", "decodeChar", "", "decodeCollectionSize", "decodeDouble", "", "decodeElementIndex", "decodeEnum", "enumDescriptor", "decodeFloat", "", "decodeInt", "decodeLong", "", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "decodeString", "", "fieldSchema", "avro4k-core"})
public final class ListDecoder
extends AbstractDecoder
implements FieldDecoder {
    private int index;
    private final Schema schema;
    private final List<Object> array;
    @NotNull
    private final SerializersModule serializersModule;

    public boolean decodeBoolean() {
        Object object = this.array.get(this.index);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
        }
        return (Boolean)object;
    }

    public long decodeLong() {
        Object object = this.array.get(this.index);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
        }
        return (Long)object;
    }

    @NotNull
    public String decodeString() {
        Object raw = this.array.get(this.index);
        return StringFromAvroValue.INSTANCE.fromValue(raw);
    }

    public double decodeDouble() {
        Object object = this.array.get(this.index);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
        }
        return (Double)object;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        int n = this.index;
        this.index = n + 1;
        return this.index < this.array.size() ? this.index : -1;
    }

    public float decodeFloat() {
        Object object = this.array.get(this.index);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
        }
        return ((Float)object).floatValue();
    }

    public byte decodeByte() {
        Object object = this.array.get(this.index);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Byte");
        }
        return (Byte)object;
    }

    public int decodeInt() {
        Object object = this.array.get(this.index);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        return (Integer)object;
    }

    public char decodeChar() {
        Object object = this.array.get(this.index);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Char");
        }
        return ((Character)object).charValue();
    }

    @Override
    @Nullable
    public Object decodeAny() {
        return this.array.get(this.index);
    }

    @Override
    @NotNull
    public Schema fieldSchema() {
        Schema schema = this.schema.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)schema, (String)"schema.elementType");
        return schema;
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Object v1;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)enumDescriptor, (String)"enumDescriptor");
            Object object = this.array.get(this.index);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            String symbol = EnumFromAvroValue.INSTANCE.fromValue(object);
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)enumDescriptor.getElementsCount());
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                int it = ((Number)t).intValue();
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)enumDescriptor.getElementName(it), (Object)symbol)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        Integer n = v1;
        return n != null ? n : -1;
    }

    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<T> deserializer) {
        Intrinsics.checkParameterIsNotNull(deserializer, (String)"deserializer");
        return (T)deserializer.deserialize((Decoder)this);
    }

    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        SerialKind serialKind = descriptor2.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE)) {
            Object object = this.array.get(this.index);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.apache.avro.generic.GenericRecord");
            }
            compositeDecoder = (CompositeDecoder)new RecordDecoder(descriptor2, (GenericRecord)object, this.getSerializersModule());
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            Schema schema = this.schema.getElementType();
            Intrinsics.checkExpressionValueIsNotNull((Object)schema, (String)"schema.elementType");
            Object object = this.array.get(this.index);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.apache.avro.generic.GenericArray<*>");
            }
            compositeDecoder = (CompositeDecoder)new ListDecoder(schema, (List)((GenericArray)object), this.getSerializersModule());
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            Schema schema = this.schema.getElementType();
            Intrinsics.checkExpressionValueIsNotNull((Object)schema, (String)"schema.elementType");
            Object object = this.array.get(this.index);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
            }
            compositeDecoder = new MapDecoder(descriptor2, schema, (Map)object, this.getSerializersModule());
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)PolymorphicKind.SEALED.INSTANCE)) {
            Object object = this.array.get(this.index);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.apache.avro.generic.GenericRecord");
            }
            compositeDecoder = (CompositeDecoder)new SealedClassDecoder(descriptor2, (GenericRecord)object, this.getSerializersModule());
        } else {
            throw (Throwable)new UnsupportedOperationException("Kind " + descriptor2.getKind() + " is currently not supported.");
        }
        return compositeDecoder;
    }

    public int decodeCollectionSize(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        return this.array.size();
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public ListDecoder(@NotNull Schema schema, @NotNull List<? extends Object> array, @NotNull SerializersModule serializersModule) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull(array, (String)"array");
        Intrinsics.checkParameterIsNotNull((Object)serializersModule, (String)"serializersModule");
        this.schema = schema;
        this.array = array;
        this.serializersModule = serializersModule;
        boolean bl = this.schema.getType() == Schema.Type.ARRAY;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.index = -1;
    }
}

