/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4k;

import com.sksamuel.avro4k.Avro;
import com.sksamuel.avro4k.io.AvroBinaryOutputStream;
import com.sksamuel.avro4k.io.AvroDataOutputStream;
import com.sksamuel.avro4k.io.AvroFormat;
import com.sksamuel.avro4k.io.AvroJsonOutputStream;
import com.sksamuel.avro4k.io.AvroOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationStrategy;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.generic.GenericRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B;\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u001e\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\b0\b\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001e2\u0006\u0010!\u001a\u00020\"J\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001e2\u0006\u0010#\u001a\u00020$J\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001e2\u0006\u0010#\u001a\u00020%R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R&\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/sksamuel/avro4k/AvroOutputStreamBuilder;", "T", "", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "avro", "Lcom/sksamuel/avro4k/Avro;", "converterFn", "Lkotlin/Function1;", "Lorg/apache/avro/Schema;", "Lorg/apache/avro/generic/GenericRecord;", "(Lkotlinx/serialization/SerializationStrategy;Lcom/sksamuel/avro4k/Avro;Lkotlin/jvm/functions/Function1;)V", "codec", "Lorg/apache/avro/file/CodecFactory;", "getCodec", "()Lorg/apache/avro/file/CodecFactory;", "setCodec", "(Lorg/apache/avro/file/CodecFactory;)V", "format", "Lcom/sksamuel/avro4k/io/AvroFormat;", "getFormat", "()Lcom/sksamuel/avro4k/io/AvroFormat;", "setFormat", "(Lcom/sksamuel/avro4k/io/AvroFormat;)V", "schema", "getSchema", "()Lorg/apache/avro/Schema;", "setSchema", "(Lorg/apache/avro/Schema;)V", "to", "Lcom/sksamuel/avro4k/io/AvroOutputStream;", "file", "Ljava/io/File;", "output", "Ljava/io/OutputStream;", "path", "Ljava/nio/file/Path;", "", "avro4k-core"})
public final class AvroOutputStreamBuilder<T> {
    @NotNull
    private AvroFormat format;
    @Nullable
    private Schema schema;
    @NotNull
    private CodecFactory codec;
    private final SerializationStrategy<T> serializer;
    private final Avro avro;
    private final Function1<Schema, Function1<T, GenericRecord>> converterFn;

    @NotNull
    public final AvroFormat getFormat() {
        return this.format;
    }

    public final void setFormat(@NotNull AvroFormat avroFormat) {
        Intrinsics.checkParameterIsNotNull((Object)avroFormat, (String)"<set-?>");
        this.format = avroFormat;
    }

    @Nullable
    public final Schema getSchema() {
        return this.schema;
    }

    public final void setSchema(@Nullable Schema schema) {
        this.schema = schema;
    }

    @NotNull
    public final CodecFactory getCodec() {
        return this.codec;
    }

    public final void setCodec(@NotNull CodecFactory codecFactory) {
        Intrinsics.checkParameterIsNotNull((Object)codecFactory, (String)"<set-?>");
        this.codec = codecFactory;
    }

    @NotNull
    public final AvroOutputStream<T> to(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"Files.newOutputStream(path)");
        return this.to(outputStream);
    }

    @NotNull
    public final AvroOutputStream<T> to(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(path)");
        return this.to(path2);
    }

    @NotNull
    public final AvroOutputStream<T> to(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Path path = file.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file.toPath()");
        return this.to(path);
    }

    @NotNull
    public final AvroOutputStream<T> to(@NotNull OutputStream output) {
        AvroOutputStream avroOutputStream;
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Schema schema = this.schema;
        if (schema == null) {
            schema = this.avro.schema(this.serializer);
        }
        Schema schema2 = schema;
        Function1 converter2 = (Function1)this.converterFn.invoke((Object)schema2);
        AvroFormat avroFormat = this.format;
        if (Intrinsics.areEqual((Object)avroFormat, (Object)AvroFormat.DataFormat.INSTANCE)) {
            avroOutputStream = new AvroDataOutputStream(output, converter2, schema2, this.codec);
        } else if (Intrinsics.areEqual((Object)avroFormat, (Object)AvroFormat.JsonFormat.INSTANCE)) {
            avroOutputStream = new AvroJsonOutputStream(output, converter2, schema2);
        } else if (Intrinsics.areEqual((Object)avroFormat, (Object)AvroFormat.BinaryFormat.INSTANCE)) {
            avroOutputStream = new AvroBinaryOutputStream(output, converter2, schema2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return avroOutputStream;
    }

    public AvroOutputStreamBuilder(@NotNull SerializationStrategy<? super T> serializer, @NotNull Avro avro, @NotNull Function1<? super Schema, ? extends Function1<? super T, ? extends GenericRecord>> converterFn) {
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        Intrinsics.checkParameterIsNotNull((Object)avro, (String)"avro");
        Intrinsics.checkParameterIsNotNull(converterFn, (String)"converterFn");
        this.serializer = serializer;
        this.avro = avro;
        this.converterFn = converterFn;
        this.format = AvroFormat.DataFormat.INSTANCE;
        CodecFactory codecFactory = CodecFactory.nullCodec();
        Intrinsics.checkExpressionValueIsNotNull((Object)codecFactory, (String)"CodecFactory.nullCodec()");
        this.codec = codecFactory;
    }
}

