/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4k;

import com.sksamuel.avro4k.io.AvroBinaryInputStream;
import com.sksamuel.avro4k.io.AvroDataInputStream;
import com.sksamuel.avro4k.io.AvroFormat;
import com.sksamuel.avro4k.io.AvroInputStream;
import com.sksamuel.avro4k.io.AvroJsonInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationException;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0006\u0010\u0019\u001a\u00020\u001aJ\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0006\u0010\u001b\u001a\u00020\u001cJ\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0006\u0010\u001d\u001a\u00020\u001eJ\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0006\u0010\u001f\u001a\u00020 J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0006\u0010\u001d\u001a\u00020!R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/sksamuel/avro4k/AvroInputStreamBuilder;", "T", "", "converter", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)V", "format", "Lcom/sksamuel/avro4k/io/AvroFormat;", "getFormat", "()Lcom/sksamuel/avro4k/io/AvroFormat;", "setFormat", "(Lcom/sksamuel/avro4k/io/AvroFormat;)V", "readerSchema", "Lorg/apache/avro/Schema;", "getReaderSchema", "()Lorg/apache/avro/Schema;", "setReaderSchema", "(Lorg/apache/avro/Schema;)V", "writerSchema", "getWriterSchema", "setWriterSchema", "from", "Lcom/sksamuel/avro4k/io/AvroInputStream;", "file", "Ljava/io/File;", "source", "Ljava/io/InputStream;", "buffer", "Ljava/nio/ByteBuffer;", "path", "Ljava/nio/file/Path;", "bytes", "", "", "avro4k-core"})
public final class AvroInputStreamBuilder<T> {
    @NotNull
    private AvroFormat format;
    @Nullable
    private Schema writerSchema;
    @Nullable
    private Schema readerSchema;
    private final Function1<Object, T> converter;

    @NotNull
    public final AvroFormat getFormat() {
        return this.format;
    }

    public final void setFormat(@NotNull AvroFormat avroFormat) {
        Intrinsics.checkParameterIsNotNull((Object)avroFormat, (String)"<set-?>");
        this.format = avroFormat;
    }

    @Nullable
    public final Schema getWriterSchema() {
        return this.writerSchema;
    }

    public final void setWriterSchema(@Nullable Schema schema) {
        this.writerSchema = schema;
    }

    @Nullable
    public final Schema getReaderSchema() {
        return this.readerSchema;
    }

    public final void setReaderSchema(@Nullable Schema schema) {
        this.readerSchema = schema;
    }

    @NotNull
    public final AvroInputStream<T> from(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"Files.newInputStream(path)");
        return this.from(inputStream);
    }

    @NotNull
    public final AvroInputStream<T> from(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(path)");
        return this.from(path2);
    }

    @NotNull
    public final AvroInputStream<T> from(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Path path = file.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file.toPath()");
        return this.from(path);
    }

    @NotNull
    public final AvroInputStream<T> from(@NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        return this.from(new ByteArrayInputStream(bytes));
    }

    @NotNull
    public final AvroInputStream<T> from(@NotNull ByteBuffer buffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        return this.from(new ByteArrayInputStream(buffer.array()));
    }

    @NotNull
    public final AvroInputStream<T> from(@NotNull InputStream source) {
        AvroInputStream avroInputStream;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        AvroFormat avroFormat = this.format;
        if (Intrinsics.areEqual((Object)avroFormat, (Object)AvroFormat.BinaryFormat.INSTANCE)) {
            Schema schema = this.writerSchema;
            if (schema == null) {
                throw (Throwable)new SerializationException("Cannot read from binary unless a writer schema is specified");
            }
            Schema wschema = schema;
            avroInputStream = new AvroBinaryInputStream<T>(source, this.converter, wschema, this.readerSchema);
        } else if (Intrinsics.areEqual((Object)avroFormat, (Object)AvroFormat.JsonFormat.INSTANCE)) {
            Schema schema = this.writerSchema;
            if (schema == null) {
                throw (Throwable)new SerializationException("Cannot read from json unless a writer schema is specified");
            }
            Schema wschema = schema;
            avroInputStream = new AvroJsonInputStream<T>(source, this.converter, wschema, this.readerSchema);
        } else if (Intrinsics.areEqual((Object)avroFormat, (Object)AvroFormat.DataFormat.INSTANCE)) {
            avroInputStream = this.writerSchema != null && this.readerSchema != null ? new AvroDataInputStream<T>(source, this.converter, this.writerSchema, this.readerSchema) : (this.writerSchema != null ? new AvroDataInputStream<T>(source, this.converter, this.writerSchema, this.readerSchema) : (this.readerSchema != null ? new AvroDataInputStream<T>(source, this.converter, null, this.readerSchema) : new AvroDataInputStream<T>(source, this.converter, null, null)));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return avroInputStream;
    }

    public AvroInputStreamBuilder(@NotNull Function1<Object, ? extends T> converter2) {
        Intrinsics.checkParameterIsNotNull(converter2, (String)"converter");
        this.converter = converter2;
        this.format = AvroFormat.DataFormat.INSTANCE;
    }
}

