package com.manageengine.apminsight.agent.api;

import com.manageengine.apminsight.agent.JavaAgentAPIHandler;

/**
 * Allows users to push custom metrics to APM Insight servers via Java agent
 * 
 * @since 3.9.0
 * @author Adithyan P
 */
public final class CustomMetric
{

	/**
	 * Allows you to send a custom metric for the application.<br/>
	 * Value will be incremented by one, every time a call is made using the same key
	 * 
	 * @param key - Name of the metric
	 * 
	 * @since 3.9.0
	 */
	public static void increment(String key)
	{
		increment(key, 1.0D);
	}
	
	/**
	 * Allows you to send a custom metric for the application.<br/>
	 * Value will be incremented by one, every time a call is made using the same key
	 * 
	 * @param key - Name of the metric
	 * @param value - Count to increment by, for the specified key
	 * 
	 * @since 3.9.0
	 */
	public static void increment(String key, double value)
	{
		try {
			JavaAgentAPIHandler.increment(key, value);
		}
		catch (Throwable th) {
			// do nothing
		}
	}
	
	public static void average(String key, double value)
	{
		try {
			JavaAgentAPIHandler.average(key, value);
		}
		catch (Throwable th) {
			// do nothing
		}
	}
}
