/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.fasterxml.jackson.jr.ob.impl;

import com.signalfx.shaded.fasterxml.jackson.jr.ob.JSONObjectException;
import com.signalfx.shaded.fasterxml.jackson.jr.ob.api.ValueReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public final class BeanPropertyReader {
    private final String _name;
    private final ValueReader _valueReader;
    private final Method _setter;
    private final Field _field;

    public BeanPropertyReader(String string, Field field, Method method) {
        if (field == null && method == null) {
            throw new IllegalArgumentException("Both `field` and `setter` can not be null");
        }
        this._name = string;
        this._field = field;
        this._setter = method;
        this._valueReader = null;
    }

    protected BeanPropertyReader(BeanPropertyReader beanPropertyReader, ValueReader valueReader) {
        this._name = beanPropertyReader._name;
        this._field = beanPropertyReader._field;
        this._setter = beanPropertyReader._setter;
        this._valueReader = valueReader;
    }

    public BeanPropertyReader withReader(ValueReader valueReader) {
        return new BeanPropertyReader(this, valueReader);
    }

    public Type genericSetterType() {
        if (this._setter != null) {
            return this._setter.getGenericParameterTypes()[0];
        }
        return this._field.getGenericType();
    }

    public Class<?> rawSetterType() {
        if (this._setter != null) {
            return this._setter.getParameterTypes()[0];
        }
        return this._field.getType();
    }

    public ValueReader getReader() {
        return this._valueReader;
    }

    public String getName() {
        return this._name;
    }

    public void setValueFor(Object object, Object[] objectArray) throws IOException {
        try {
            if (this._setter == null) {
                this._field.set(object, objectArray[0]);
            } else {
                this._setter.invoke(object, objectArray);
            }
        }
        catch (Exception exception) {
            Object object2;
            Throwable throwable = exception;
            if (throwable instanceof InvocationTargetException) {
                throwable = throwable.getCause();
            }
            String string = (object2 = objectArray[0]) == null ? "NULL" : object2.getClass().getName();
            throw new JSONObjectException(String.format("Failed to set property '%s' (raw type %s) to value of type %s; exception (%s): %s", this._name, this._rawType().getName(), string, exception.getClass().getName(), throwable.getMessage()), throwable);
        }
    }

    protected String _bean() {
        if (this._setter != null) {
            return this._setter.getDeclaringClass().getName();
        }
        return this._field.getDeclaringClass().getName();
    }

    protected Class<?> _rawType() {
        if (this._setter != null) {
            return this._setter.getParameterTypes()[0];
        }
        return this._field.getType();
    }

    public String toString() {
        return this._name;
    }
}

