/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.metrics;

import com.signalfx.endpoint.SignalFxEndpoint;
import com.signalfx.metrics.auth.AuthToken;
import com.signalfx.metrics.auth.StaticAuthToken;
import com.signalfx.metrics.connection.HttpDataPointProtobufReceiverFactory;
import com.signalfx.metrics.errorhandler.MetricError;
import com.signalfx.metrics.errorhandler.OnSendErrorHandler;
import com.signalfx.metrics.flush.AggregateMetricSender;
import com.signalfx.metrics.protobuf.SignalFxProtocolBuffers;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import java.util.Properties;

public final class SendMetrics {
    private SendMetrics() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        Properties prop = new Properties();
        prop.load(new FileInputStream("auth.properties"));
        String token = Objects.requireNonNull(prop.getProperty("auth"), "No auth token set");
        String host = Objects.requireNonNull(prop.getProperty("host"), "No endpoint set");
        URL hostUrl = new URL(host);
        System.out.printf("Sending metrics to %s (X-SF-Token: %s) ...%n", hostUrl, token);
        SignalFxEndpoint endpoint = new SignalFxEndpoint(hostUrl.getProtocol(), hostUrl.getHost(), hostUrl.getPort());
        OnSendErrorHandler errorHandler = new OnSendErrorHandler(){

            @Override
            public void handleError(MetricError metricError) {
                System.err.printf("Error %s sending data: %s%n", new Object[]{metricError.getMetricErrorType(), metricError.getMessage()});
                metricError.getException().printStackTrace(System.err);
            }
        };
        AggregateMetricSender mf = new AggregateMetricSender("test.SendMetrics", new HttpDataPointProtobufReceiverFactory(endpoint), (AuthToken)new StaticAuthToken(token), Collections.singletonList(errorHandler));
        while (true) {
            Thread.sleep(250L);
            AggregateMetricSender.Session i = mf.createSession();
            try {
                i.setDatapoint(SignalFxProtocolBuffers.DataPoint.newBuilder().setMetric("curtime").setValue(SignalFxProtocolBuffers.Datum.newBuilder().setIntValue(System.currentTimeMillis())).addDimensions(SignalFxProtocolBuffers.Dimension.newBuilder().setKey("source").setValue("java")).build());
            }
            catch (Throwable throwable) {
                System.out.printf("Sending data at %s%n", new Date());
                i.close();
                throw throwable;
            }
            System.out.printf("Sending data at %s%n", new Date());
            i.close();
        }
    }
}

