/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.fasterxml.jackson.databind.util;

import com.signalfx.shaded.fasterxml.jackson.core.io.SerializedString;
import com.signalfx.shaded.fasterxml.jackson.databind.AnnotationIntrospector;
import com.signalfx.shaded.fasterxml.jackson.databind.BeanDescription;
import com.signalfx.shaded.fasterxml.jackson.databind.JavaType;
import com.signalfx.shaded.fasterxml.jackson.databind.PropertyName;
import com.signalfx.shaded.fasterxml.jackson.databind.cfg.MapperConfig;
import com.signalfx.shaded.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.signalfx.shaded.fasterxml.jackson.databind.type.ClassKey;
import com.signalfx.shaded.fasterxml.jackson.databind.util.LRUMap;
import java.io.Serializable;

public class RootNameLookup
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected LRUMap<ClassKey, SerializedString> _rootNames;

    public SerializedString findRootName(JavaType javaType, MapperConfig<?> mapperConfig) {
        return this.findRootName(javaType.getRawClass(), mapperConfig);
    }

    public synchronized SerializedString findRootName(Class<?> clazz, MapperConfig<?> mapperConfig) {
        Object object;
        ClassKey classKey = new ClassKey(clazz);
        if (this._rootNames == null) {
            this._rootNames = new LRUMap(20, 200);
        } else {
            object = (SerializedString)this._rootNames.get(classKey);
            if (object != null) {
                return object;
            }
        }
        object = mapperConfig.introspectClassAnnotations(clazz);
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        AnnotatedClass annotatedClass = ((BeanDescription)object).getClassInfo();
        PropertyName propertyName = annotationIntrospector.findRootName(annotatedClass);
        String string = propertyName == null || !propertyName.hasSimpleName() ? clazz.getSimpleName() : propertyName.getSimpleName();
        SerializedString serializedString = new SerializedString(string);
        this._rootNames.put(classKey, serializedString);
        return serializedString;
    }
}

