/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.fasterxml.jackson.databind.deser;

import com.signalfx.shaded.fasterxml.jackson.core.JsonParser;
import com.signalfx.shaded.fasterxml.jackson.core.JsonProcessingException;
import com.signalfx.shaded.fasterxml.jackson.core.JsonToken;
import com.signalfx.shaded.fasterxml.jackson.databind.BeanDescription;
import com.signalfx.shaded.fasterxml.jackson.databind.DeserializationContext;
import com.signalfx.shaded.fasterxml.jackson.databind.JavaType;
import com.signalfx.shaded.fasterxml.jackson.databind.JsonDeserializer;
import com.signalfx.shaded.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.signalfx.shaded.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.signalfx.shaded.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.signalfx.shaded.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.signalfx.shaded.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;

public class AbstractDeserializer
extends JsonDeserializer<Object>
implements Serializable {
    private static final long serialVersionUID = -3010349050434697698L;
    protected final JavaType _baseType;
    protected final ObjectIdReader _objectIdReader;
    protected final Map<String, SettableBeanProperty> _backRefProperties;
    protected final boolean _acceptString;
    protected final boolean _acceptBoolean;
    protected final boolean _acceptInt;
    protected final boolean _acceptDouble;

    public AbstractDeserializer(BeanDeserializerBuilder beanDeserializerBuilder, BeanDescription beanDescription, Map<String, SettableBeanProperty> map) {
        this._baseType = beanDescription.getType();
        this._objectIdReader = beanDeserializerBuilder.getObjectIdReader();
        this._backRefProperties = map;
        Class<Object> clazz = this._baseType.getRawClass();
        this._acceptString = clazz.isAssignableFrom(String.class);
        this._acceptBoolean = clazz == Boolean.TYPE || clazz.isAssignableFrom(Boolean.class);
        this._acceptInt = clazz == Integer.TYPE || clazz.isAssignableFrom(Integer.class);
        this._acceptDouble = clazz == Double.TYPE || clazz.isAssignableFrom(Double.class);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public ObjectIdReader getObjectIdReader() {
        return this._objectIdReader;
    }

    public SettableBeanProperty findBackReference(String string) {
        return this._backRefProperties == null ? null : this._backRefProperties.get(string);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        Object object;
        if (this._objectIdReader != null && (object = jsonParser.getCurrentToken()) != null && ((JsonToken)((Object)object)).isScalarValue()) {
            return this._deserializeFromObjectId(jsonParser, deserializationContext);
        }
        object = this._deserializeIfNatural(jsonParser, deserializationContext);
        if (object != null) {
            return object;
        }
        return typeDeserializer.deserializeTypedFromObject(jsonParser, deserializationContext);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        throw deserializationContext.instantiationException(this._baseType.getRawClass(), "abstract types either need to be mapped to concrete types, have custom deserializer, or be instantiated with additional type information");
    }

    protected Object _deserializeIfNatural(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        switch (jsonParser.getCurrentToken()) {
            case VALUE_STRING: {
                if (!this._acceptString) break;
                return jsonParser.getText();
            }
            case VALUE_NUMBER_INT: {
                if (!this._acceptInt) break;
                return jsonParser.getIntValue();
            }
            case VALUE_NUMBER_FLOAT: {
                if (!this._acceptDouble) break;
                return jsonParser.getDoubleValue();
            }
            case VALUE_TRUE: {
                if (!this._acceptBoolean) break;
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                if (!this._acceptBoolean) break;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected Object _deserializeFromObjectId(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Object object = this._objectIdReader.deserializer.deserialize(jsonParser, deserializationContext);
        ReadableObjectId readableObjectId = deserializationContext.findObjectId(object, this._objectIdReader.generator);
        Object object2 = readableObjectId.item;
        if (object2 == null) {
            throw new IllegalStateException("Could not resolve Object Id [" + object + "] -- unresolved forward-reference?");
        }
        return object2;
    }
}

