/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.apache.http.impl.conn;

import com.signalfx.shaded.apache.http.HttpResponse;
import com.signalfx.shaded.apache.http.HttpResponseFactory;
import com.signalfx.shaded.apache.http.annotation.Immutable;
import com.signalfx.shaded.apache.http.config.MessageConstraints;
import com.signalfx.shaded.apache.http.impl.DefaultHttpResponseFactory;
import com.signalfx.shaded.apache.http.impl.conn.DefaultHttpResponseParser;
import com.signalfx.shaded.apache.http.io.HttpMessageParser;
import com.signalfx.shaded.apache.http.io.HttpMessageParserFactory;
import com.signalfx.shaded.apache.http.io.SessionInputBuffer;
import com.signalfx.shaded.apache.http.message.BasicLineParser;
import com.signalfx.shaded.apache.http.message.LineParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

