/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.apache.http.impl.client;

import com.signalfx.shaded.apache.http.ConnectionReuseStrategy;
import com.signalfx.shaded.apache.http.Header;
import com.signalfx.shaded.apache.http.HttpHost;
import com.signalfx.shaded.apache.http.HttpRequestInterceptor;
import com.signalfx.shaded.apache.http.HttpResponseInterceptor;
import com.signalfx.shaded.apache.http.annotation.NotThreadSafe;
import com.signalfx.shaded.apache.http.auth.AuthSchemeProvider;
import com.signalfx.shaded.apache.http.client.AuthenticationStrategy;
import com.signalfx.shaded.apache.http.client.BackoffManager;
import com.signalfx.shaded.apache.http.client.ConnectionBackoffStrategy;
import com.signalfx.shaded.apache.http.client.CookieStore;
import com.signalfx.shaded.apache.http.client.CredentialsProvider;
import com.signalfx.shaded.apache.http.client.HttpRequestRetryHandler;
import com.signalfx.shaded.apache.http.client.RedirectStrategy;
import com.signalfx.shaded.apache.http.client.ServiceUnavailableRetryStrategy;
import com.signalfx.shaded.apache.http.client.UserTokenHandler;
import com.signalfx.shaded.apache.http.client.config.RequestConfig;
import com.signalfx.shaded.apache.http.client.protocol.RequestAcceptEncoding;
import com.signalfx.shaded.apache.http.client.protocol.RequestAddCookies;
import com.signalfx.shaded.apache.http.client.protocol.RequestAuthCache;
import com.signalfx.shaded.apache.http.client.protocol.RequestClientConnControl;
import com.signalfx.shaded.apache.http.client.protocol.RequestDefaultHeaders;
import com.signalfx.shaded.apache.http.client.protocol.RequestExpectContinue;
import com.signalfx.shaded.apache.http.client.protocol.ResponseContentEncoding;
import com.signalfx.shaded.apache.http.client.protocol.ResponseProcessCookies;
import com.signalfx.shaded.apache.http.config.ConnectionConfig;
import com.signalfx.shaded.apache.http.config.Lookup;
import com.signalfx.shaded.apache.http.config.RegistryBuilder;
import com.signalfx.shaded.apache.http.config.SocketConfig;
import com.signalfx.shaded.apache.http.conn.ConnectionKeepAliveStrategy;
import com.signalfx.shaded.apache.http.conn.HttpClientConnectionManager;
import com.signalfx.shaded.apache.http.conn.SchemePortResolver;
import com.signalfx.shaded.apache.http.conn.routing.HttpRoutePlanner;
import com.signalfx.shaded.apache.http.conn.socket.LayeredConnectionSocketFactory;
import com.signalfx.shaded.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.signalfx.shaded.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.signalfx.shaded.apache.http.conn.ssl.SSLContexts;
import com.signalfx.shaded.apache.http.conn.ssl.X509HostnameVerifier;
import com.signalfx.shaded.apache.http.cookie.CookieSpecProvider;
import com.signalfx.shaded.apache.http.impl.DefaultConnectionReuseStrategy;
import com.signalfx.shaded.apache.http.impl.NoConnectionReuseStrategy;
import com.signalfx.shaded.apache.http.impl.auth.BasicSchemeFactory;
import com.signalfx.shaded.apache.http.impl.auth.DigestSchemeFactory;
import com.signalfx.shaded.apache.http.impl.auth.KerberosSchemeFactory;
import com.signalfx.shaded.apache.http.impl.auth.NTLMSchemeFactory;
import com.signalfx.shaded.apache.http.impl.auth.SPNegoSchemeFactory;
import com.signalfx.shaded.apache.http.impl.client.BasicCookieStore;
import com.signalfx.shaded.apache.http.impl.client.BasicCredentialsProvider;
import com.signalfx.shaded.apache.http.impl.client.CloseableHttpClient;
import com.signalfx.shaded.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import com.signalfx.shaded.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import com.signalfx.shaded.apache.http.impl.client.DefaultRedirectStrategy;
import com.signalfx.shaded.apache.http.impl.client.DefaultUserTokenHandler;
import com.signalfx.shaded.apache.http.impl.client.InternalHttpClient;
import com.signalfx.shaded.apache.http.impl.client.NoopUserTokenHandler;
import com.signalfx.shaded.apache.http.impl.client.ProxyAuthenticationStrategy;
import com.signalfx.shaded.apache.http.impl.client.SystemDefaultCredentialsProvider;
import com.signalfx.shaded.apache.http.impl.client.TargetAuthenticationStrategy;
import com.signalfx.shaded.apache.http.impl.conn.DefaultProxyRoutePlanner;
import com.signalfx.shaded.apache.http.impl.conn.DefaultRoutePlanner;
import com.signalfx.shaded.apache.http.impl.conn.DefaultSchemePortResolver;
import com.signalfx.shaded.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.signalfx.shaded.apache.http.impl.conn.SystemDefaultRoutePlanner;
import com.signalfx.shaded.apache.http.impl.cookie.BestMatchSpecFactory;
import com.signalfx.shaded.apache.http.impl.cookie.BrowserCompatSpecFactory;
import com.signalfx.shaded.apache.http.impl.cookie.IgnoreSpecFactory;
import com.signalfx.shaded.apache.http.impl.cookie.NetscapeDraftSpecFactory;
import com.signalfx.shaded.apache.http.impl.cookie.RFC2109SpecFactory;
import com.signalfx.shaded.apache.http.impl.cookie.RFC2965SpecFactory;
import com.signalfx.shaded.apache.http.impl.execchain.BackoffStrategyExec;
import com.signalfx.shaded.apache.http.impl.execchain.ClientExecChain;
import com.signalfx.shaded.apache.http.impl.execchain.MainClientExec;
import com.signalfx.shaded.apache.http.impl.execchain.ProtocolExec;
import com.signalfx.shaded.apache.http.impl.execchain.RedirectExec;
import com.signalfx.shaded.apache.http.impl.execchain.RetryExec;
import com.signalfx.shaded.apache.http.impl.execchain.ServiceUnavailableRetryExec;
import com.signalfx.shaded.apache.http.protocol.HttpProcessor;
import com.signalfx.shaded.apache.http.protocol.HttpProcessorBuilder;
import com.signalfx.shaded.apache.http.protocol.HttpRequestExecutor;
import com.signalfx.shaded.apache.http.protocol.RequestContent;
import com.signalfx.shaded.apache.http.protocol.RequestTargetHost;
import com.signalfx.shaded.apache.http.protocol.RequestUserAgent;
import com.signalfx.shaded.apache.http.util.TextUtils;
import com.signalfx.shaded.apache.http.util.VersionInfo;
import java.io.Closeable;
import java.net.ProxySelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class HttpClientBuilder {
    private HttpRequestExecutor requestExec;
    private X509HostnameVerifier hostnameVerifier;
    private LayeredConnectionSocketFactory sslSocketFactory;
    private SSLContext sslcontext;
    private HttpClientConnectionManager connManager;
    private SchemePortResolver schemePortResolver;
    private ConnectionReuseStrategy reuseStrategy;
    private ConnectionKeepAliveStrategy keepAliveStrategy;
    private AuthenticationStrategy targetAuthStrategy;
    private AuthenticationStrategy proxyAuthStrategy;
    private UserTokenHandler userTokenHandler;
    private HttpProcessor httpprocessor;
    private LinkedList<HttpRequestInterceptor> requestFirst;
    private LinkedList<HttpRequestInterceptor> requestLast;
    private LinkedList<HttpResponseInterceptor> responseFirst;
    private LinkedList<HttpResponseInterceptor> responseLast;
    private HttpRequestRetryHandler retryHandler;
    private HttpRoutePlanner routePlanner;
    private RedirectStrategy redirectStrategy;
    private ConnectionBackoffStrategy connectionBackoffStrategy;
    private BackoffManager backoffManager;
    private ServiceUnavailableRetryStrategy serviceUnavailStrategy;
    private Lookup<AuthSchemeProvider> authSchemeRegistry;
    private Lookup<CookieSpecProvider> cookieSpecRegistry;
    private CookieStore cookieStore;
    private CredentialsProvider credentialsProvider;
    private String userAgent;
    private HttpHost proxy;
    private Collection<? extends Header> defaultHeaders;
    private SocketConfig defaultSocketConfig;
    private ConnectionConfig defaultConnectionConfig;
    private RequestConfig defaultRequestConfig;
    private boolean systemProperties;
    private boolean redirectHandlingDisabled;
    private boolean automaticRetriesDisabled;
    private boolean contentCompressionDisabled;
    private boolean cookieManagementDisabled;
    private boolean authCachingDisabled;
    private boolean connectionStateDisabled;
    private int maxConnTotal = 0;
    private int maxConnPerRoute = 0;
    private List<Closeable> closeables;

    public static HttpClientBuilder create() {
        return new HttpClientBuilder();
    }

    protected HttpClientBuilder() {
    }

    public final HttpClientBuilder setRequestExecutor(HttpRequestExecutor requestExec) {
        this.requestExec = requestExec;
        return this;
    }

    public final HttpClientBuilder setHostnameVerifier(X509HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public final HttpClientBuilder setSslcontext(SSLContext sslcontext) {
        this.sslcontext = sslcontext;
        return this;
    }

    public final HttpClientBuilder setSSLSocketFactory(LayeredConnectionSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    public final HttpClientBuilder setMaxConnTotal(int maxConnTotal) {
        this.maxConnTotal = maxConnTotal;
        return this;
    }

    public final HttpClientBuilder setMaxConnPerRoute(int maxConnPerRoute) {
        this.maxConnPerRoute = maxConnPerRoute;
        return this;
    }

    public final HttpClientBuilder setDefaultSocketConfig(SocketConfig config) {
        this.defaultSocketConfig = config;
        return this;
    }

    public final HttpClientBuilder setDefaultConnectionConfig(ConnectionConfig config) {
        this.defaultConnectionConfig = config;
        return this;
    }

    public final HttpClientBuilder setConnectionManager(HttpClientConnectionManager connManager) {
        this.connManager = connManager;
        return this;
    }

    public final HttpClientBuilder setConnectionReuseStrategy(ConnectionReuseStrategy reuseStrategy) {
        this.reuseStrategy = reuseStrategy;
        return this;
    }

    public final HttpClientBuilder setKeepAliveStrategy(ConnectionKeepAliveStrategy keepAliveStrategy) {
        this.keepAliveStrategy = keepAliveStrategy;
        return this;
    }

    public final HttpClientBuilder setTargetAuthenticationStrategy(AuthenticationStrategy targetAuthStrategy) {
        this.targetAuthStrategy = targetAuthStrategy;
        return this;
    }

    public final HttpClientBuilder setProxyAuthenticationStrategy(AuthenticationStrategy proxyAuthStrategy) {
        this.proxyAuthStrategy = proxyAuthStrategy;
        return this;
    }

    public final HttpClientBuilder setUserTokenHandler(UserTokenHandler userTokenHandler) {
        this.userTokenHandler = userTokenHandler;
        return this;
    }

    public final HttpClientBuilder disableConnectionState() {
        this.connectionStateDisabled = true;
        return this;
    }

    public final HttpClientBuilder setSchemePortResolver(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver;
        return this;
    }

    public final HttpClientBuilder setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public final HttpClientBuilder setDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
        return this;
    }

    public final HttpClientBuilder addInterceptorFirst(HttpResponseInterceptor itcp) {
        if (itcp == null) {
            return this;
        }
        if (this.responseFirst == null) {
            this.responseFirst = new LinkedList();
        }
        this.responseFirst.addFirst(itcp);
        return this;
    }

    public final HttpClientBuilder addInterceptorLast(HttpResponseInterceptor itcp) {
        if (itcp == null) {
            return this;
        }
        if (this.responseLast == null) {
            this.responseLast = new LinkedList();
        }
        this.responseLast.addLast(itcp);
        return this;
    }

    public final HttpClientBuilder addInterceptorFirst(HttpRequestInterceptor itcp) {
        if (itcp == null) {
            return this;
        }
        if (this.requestFirst == null) {
            this.requestFirst = new LinkedList();
        }
        this.requestFirst.addFirst(itcp);
        return this;
    }

    public final HttpClientBuilder addInterceptorLast(HttpRequestInterceptor itcp) {
        if (itcp == null) {
            return this;
        }
        if (this.requestLast == null) {
            this.requestLast = new LinkedList();
        }
        this.requestLast.addLast(itcp);
        return this;
    }

    public final HttpClientBuilder disableCookieManagement() {
        this.cookieManagementDisabled = true;
        return this;
    }

    public final HttpClientBuilder disableContentCompression() {
        this.contentCompressionDisabled = true;
        return this;
    }

    public final HttpClientBuilder disableAuthCaching() {
        this.authCachingDisabled = true;
        return this;
    }

    public final HttpClientBuilder setHttpProcessor(HttpProcessor httpprocessor) {
        this.httpprocessor = httpprocessor;
        return this;
    }

    public final HttpClientBuilder setRetryHandler(HttpRequestRetryHandler retryHandler) {
        this.retryHandler = retryHandler;
        return this;
    }

    public final HttpClientBuilder disableAutomaticRetries() {
        this.automaticRetriesDisabled = true;
        return this;
    }

    public final HttpClientBuilder setProxy(HttpHost proxy) {
        this.proxy = proxy;
        return this;
    }

    public final HttpClientBuilder setRoutePlanner(HttpRoutePlanner routePlanner) {
        this.routePlanner = routePlanner;
        return this;
    }

    public final HttpClientBuilder setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
        return this;
    }

    public final HttpClientBuilder disableRedirectHandling() {
        this.redirectHandlingDisabled = true;
        return this;
    }

    public final HttpClientBuilder setConnectionBackoffStrategy(ConnectionBackoffStrategy connectionBackoffStrategy) {
        this.connectionBackoffStrategy = connectionBackoffStrategy;
        return this;
    }

    public final HttpClientBuilder setBackoffManager(BackoffManager backoffManager) {
        this.backoffManager = backoffManager;
        return this;
    }

    public final HttpClientBuilder setServiceUnavailableRetryStrategy(ServiceUnavailableRetryStrategy serviceUnavailStrategy) {
        this.serviceUnavailStrategy = serviceUnavailStrategy;
        return this;
    }

    public final HttpClientBuilder setDefaultCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
        return this;
    }

    public final HttpClientBuilder setDefaultCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public final HttpClientBuilder setDefaultAuthSchemeRegistry(Lookup<AuthSchemeProvider> authSchemeRegistry) {
        this.authSchemeRegistry = authSchemeRegistry;
        return this;
    }

    public final HttpClientBuilder setDefaultCookieSpecRegistry(Lookup<CookieSpecProvider> cookieSpecRegistry) {
        this.cookieSpecRegistry = cookieSpecRegistry;
        return this;
    }

    public final HttpClientBuilder setDefaultRequestConfig(RequestConfig config) {
        this.defaultRequestConfig = config;
        return this;
    }

    public final HttpClientBuilder useSystemProperties() {
        this.systemProperties = true;
        return this;
    }

    protected ClientExecChain decorateMainExec(ClientExecChain mainExec) {
        return mainExec;
    }

    protected ClientExecChain decorateProtocolExec(ClientExecChain protocolExec) {
        return protocolExec;
    }

    protected void addCloseable(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        if (this.closeables == null) {
            this.closeables = new ArrayList<Closeable>();
        }
        this.closeables.add(closeable);
    }

    private static String[] split(String s) {
        if (TextUtils.isBlank(s)) {
            return null;
        }
        return s.split(" *, *");
    }

    public CloseableHttpClient build() {
        CredentialsProvider defaultCredentialsProvider;
        CookieStore defaultCookieStore;
        Lookup<CookieSpecProvider> cookieSpecRegistry;
        Lookup<AuthSchemeProvider> authSchemeRegistry;
        ServiceUnavailableRetryStrategy serviceUnavailStrategy;
        HttpRoutePlanner routePlanner;
        UserTokenHandler userTokenHandler;
        AuthenticationStrategy proxyAuthStrategy;
        AuthenticationStrategy targetAuthStrategy;
        ConnectionKeepAliveStrategy keepAliveStrategy;
        ConnectionReuseStrategy reuseStrategy;
        HttpClientConnectionManager connManager;
        HttpRequestExecutor requestExec = this.requestExec;
        if (requestExec == null) {
            requestExec = new HttpRequestExecutor();
        }
        if ((connManager = this.connManager) == null) {
            String s;
            LayeredConnectionSocketFactory sslSocketFactory = this.sslSocketFactory;
            if (sslSocketFactory == null) {
                sslSocketFactory = this.sslcontext != null ? new SSLConnectionSocketFactory(this.sslcontext, this.hostnameVerifier) : (this.systemProperties ? new SSLConnectionSocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault(), HttpClientBuilder.split(System.getProperty("https.protocols")), HttpClientBuilder.split(System.getProperty("https.cipherSuites")), this.hostnameVerifier) : new SSLConnectionSocketFactory(SSLContexts.createDefault(), this.hostnameVerifier));
            }
            PoolingHttpClientConnectionManager poolingmgr = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)sslSocketFactory)).build());
            if (this.defaultSocketConfig != null) {
                poolingmgr.setDefaultSocketConfig(this.defaultSocketConfig);
            }
            if (this.defaultConnectionConfig != null) {
                poolingmgr.setDefaultConnectionConfig(this.defaultConnectionConfig);
            }
            if (this.systemProperties && "true".equalsIgnoreCase(s = System.getProperty("http.keepAlive", "true"))) {
                s = System.getProperty("http.maxConnections", "5");
                int max = Integer.parseInt(s);
                poolingmgr.setDefaultMaxPerRoute(max);
                poolingmgr.setMaxTotal(2 * max);
            }
            if (this.maxConnTotal > 0) {
                poolingmgr.setMaxTotal(this.maxConnTotal);
            }
            if (this.maxConnPerRoute > 0) {
                poolingmgr.setDefaultMaxPerRoute(this.maxConnPerRoute);
            }
            connManager = poolingmgr;
        }
        if ((reuseStrategy = this.reuseStrategy) == null) {
            String s;
            reuseStrategy = this.systemProperties ? ("true".equalsIgnoreCase(s = System.getProperty("http.keepAlive", "true")) ? DefaultConnectionReuseStrategy.INSTANCE : NoConnectionReuseStrategy.INSTANCE) : DefaultConnectionReuseStrategy.INSTANCE;
        }
        if ((keepAliveStrategy = this.keepAliveStrategy) == null) {
            keepAliveStrategy = DefaultConnectionKeepAliveStrategy.INSTANCE;
        }
        if ((targetAuthStrategy = this.targetAuthStrategy) == null) {
            targetAuthStrategy = TargetAuthenticationStrategy.INSTANCE;
        }
        if ((proxyAuthStrategy = this.proxyAuthStrategy) == null) {
            proxyAuthStrategy = ProxyAuthenticationStrategy.INSTANCE;
        }
        if ((userTokenHandler = this.userTokenHandler) == null) {
            userTokenHandler = !this.connectionStateDisabled ? DefaultUserTokenHandler.INSTANCE : NoopUserTokenHandler.INSTANCE;
        }
        ClientExecChain execChain = new MainClientExec(requestExec, connManager, reuseStrategy, keepAliveStrategy, targetAuthStrategy, proxyAuthStrategy, userTokenHandler);
        execChain = this.decorateMainExec(execChain);
        HttpProcessor httpprocessor = this.httpprocessor;
        if (httpprocessor == null) {
            String userAgent = this.userAgent;
            if (userAgent == null) {
                if (this.systemProperties) {
                    userAgent = System.getProperty("http.agent");
                }
                if (userAgent == null) {
                    VersionInfo vi = VersionInfo.loadVersionInfo("com.signalfx.shaded.apache.http.client", HttpClientBuilder.class.getClassLoader());
                    String release = vi != null ? vi.getRelease() : "UNAVAILABLE";
                    userAgent = "Apache-HttpClient/" + release + " (java 1.5)";
                }
            }
            HttpProcessorBuilder b = HttpProcessorBuilder.create();
            if (this.requestFirst != null) {
                for (HttpRequestInterceptor httpRequestInterceptor : this.requestFirst) {
                    b.addFirst(httpRequestInterceptor);
                }
            }
            if (this.responseFirst != null) {
                for (HttpResponseInterceptor httpResponseInterceptor : this.responseFirst) {
                    b.addFirst(httpResponseInterceptor);
                }
            }
            b.addAll(new RequestDefaultHeaders(this.defaultHeaders), new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(userAgent), new RequestExpectContinue());
            if (!this.cookieManagementDisabled) {
                b.add(new RequestAddCookies());
            }
            if (!this.contentCompressionDisabled) {
                b.add(new RequestAcceptEncoding());
            }
            if (!this.authCachingDisabled) {
                b.add(new RequestAuthCache());
            }
            if (!this.cookieManagementDisabled) {
                b.add(new ResponseProcessCookies());
            }
            if (!this.contentCompressionDisabled) {
                b.add(new ResponseContentEncoding());
            }
            if (this.requestLast != null) {
                for (HttpRequestInterceptor httpRequestInterceptor : this.requestLast) {
                    b.addLast(httpRequestInterceptor);
                }
            }
            if (this.responseLast != null) {
                for (HttpResponseInterceptor httpResponseInterceptor : this.responseLast) {
                    b.addLast(httpResponseInterceptor);
                }
            }
            httpprocessor = b.build();
        }
        execChain = new ProtocolExec(execChain, httpprocessor);
        execChain = this.decorateProtocolExec(execChain);
        if (!this.automaticRetriesDisabled) {
            HttpRequestRetryHandler retryHandler = this.retryHandler;
            if (retryHandler == null) {
                retryHandler = DefaultHttpRequestRetryHandler.INSTANCE;
            }
            execChain = new RetryExec(execChain, retryHandler);
        }
        if ((routePlanner = this.routePlanner) == null) {
            SchemePortResolver schemePortResolver = this.schemePortResolver;
            if (schemePortResolver == null) {
                schemePortResolver = DefaultSchemePortResolver.INSTANCE;
            }
            routePlanner = this.proxy != null ? new DefaultProxyRoutePlanner(this.proxy, schemePortResolver) : (this.systemProperties ? new SystemDefaultRoutePlanner(schemePortResolver, ProxySelector.getDefault()) : new DefaultRoutePlanner(schemePortResolver));
        }
        if (!this.redirectHandlingDisabled) {
            RedirectStrategy redirectStrategy = this.redirectStrategy;
            if (redirectStrategy == null) {
                redirectStrategy = DefaultRedirectStrategy.INSTANCE;
            }
            execChain = new RedirectExec(execChain, routePlanner, redirectStrategy);
        }
        if ((serviceUnavailStrategy = this.serviceUnavailStrategy) != null) {
            execChain = new ServiceUnavailableRetryExec(execChain, serviceUnavailStrategy);
        }
        BackoffManager backoffManager = this.backoffManager;
        ConnectionBackoffStrategy connectionBackoffStrategy = this.connectionBackoffStrategy;
        if (backoffManager != null && connectionBackoffStrategy != null) {
            execChain = new BackoffStrategyExec(execChain, connectionBackoffStrategy, backoffManager);
        }
        if ((authSchemeRegistry = this.authSchemeRegistry) == null) {
            authSchemeRegistry = RegistryBuilder.create().register("Basic", new BasicSchemeFactory()).register("Digest", (BasicSchemeFactory)((Object)new DigestSchemeFactory())).register("NTLM", (BasicSchemeFactory)((Object)new NTLMSchemeFactory())).register("negotiate", (BasicSchemeFactory)((Object)new SPNegoSchemeFactory())).register("Kerberos", (BasicSchemeFactory)((Object)new KerberosSchemeFactory())).build();
        }
        if ((cookieSpecRegistry = this.cookieSpecRegistry) == null) {
            cookieSpecRegistry = RegistryBuilder.create().register("best-match", new BestMatchSpecFactory()).register("standard", (BestMatchSpecFactory)((Object)new RFC2965SpecFactory())).register("compatibility", (BestMatchSpecFactory)((Object)new BrowserCompatSpecFactory())).register("netscape", (BestMatchSpecFactory)((Object)new NetscapeDraftSpecFactory())).register("ignoreCookies", (BestMatchSpecFactory)((Object)new IgnoreSpecFactory())).register("rfc2109", (BestMatchSpecFactory)((Object)new RFC2109SpecFactory())).register("rfc2965", (BestMatchSpecFactory)((Object)new RFC2965SpecFactory())).build();
        }
        if ((defaultCookieStore = this.cookieStore) == null) {
            defaultCookieStore = new BasicCookieStore();
        }
        if ((defaultCredentialsProvider = this.credentialsProvider) == null) {
            defaultCredentialsProvider = this.systemProperties ? new SystemDefaultCredentialsProvider() : new BasicCredentialsProvider();
        }
        return new InternalHttpClient(execChain, connManager, routePlanner, cookieSpecRegistry, authSchemeRegistry, defaultCookieStore, defaultCredentialsProvider, this.defaultRequestConfig != null ? this.defaultRequestConfig : RequestConfig.DEFAULT, (List<Closeable>)(this.closeables != null ? new ArrayList<Closeable>(this.closeables) : null));
    }
}

