/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.apache.http.impl.auth;

import com.signalfx.shaded.apache.commons.codec.binary.Base64;
import com.signalfx.shaded.apache.http.Consts;
import com.signalfx.shaded.apache.http.Header;
import com.signalfx.shaded.apache.http.HttpRequest;
import com.signalfx.shaded.apache.http.annotation.NotThreadSafe;
import com.signalfx.shaded.apache.http.auth.AuthenticationException;
import com.signalfx.shaded.apache.http.auth.ChallengeState;
import com.signalfx.shaded.apache.http.auth.Credentials;
import com.signalfx.shaded.apache.http.auth.MalformedChallengeException;
import com.signalfx.shaded.apache.http.impl.auth.RFC2617Scheme;
import com.signalfx.shaded.apache.http.message.BufferedHeader;
import com.signalfx.shaded.apache.http.protocol.BasicHttpContext;
import com.signalfx.shaded.apache.http.protocol.HttpContext;
import com.signalfx.shaded.apache.http.util.Args;
import com.signalfx.shaded.apache.http.util.CharArrayBuffer;
import com.signalfx.shaded.apache.http.util.EncodingUtils;
import java.nio.charset.Charset;

@NotThreadSafe
public class BasicScheme
extends RFC2617Scheme {
    private final Base64 base64codec = new Base64(0);
    private boolean complete;

    public BasicScheme(Charset credentialsCharset) {
        super(credentialsCharset);
        this.complete = false;
    }

    @Deprecated
    public BasicScheme(ChallengeState challengeState) {
        super(challengeState);
    }

    public BasicScheme() {
        this(Consts.ASCII);
    }

    public String getSchemeName() {
        return "basic";
    }

    public void processChallenge(Header header) throws MalformedChallengeException {
        super.processChallenge(header);
        this.complete = true;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isConnectionBased() {
        return false;
    }

    @Deprecated
    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        return this.authenticate(credentials, request, new BasicHttpContext());
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        Args.notNull(credentials, "Credentials");
        Args.notNull(request, "HTTP request");
        StringBuilder tmp = new StringBuilder();
        tmp.append(credentials.getUserPrincipal().getName());
        tmp.append(":");
        tmp.append(credentials.getPassword() == null ? "null" : credentials.getPassword());
        byte[] base64password = this.base64codec.encode(EncodingUtils.getBytes(tmp.toString(), this.getCredentialsCharset(request)));
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        if (this.isProxy()) {
            buffer.append("Proxy-Authorization");
        } else {
            buffer.append("Authorization");
        }
        buffer.append(": Basic ");
        buffer.append(base64password, 0, base64password.length);
        return new BufferedHeader(buffer);
    }

    @Deprecated
    public static Header authenticate(Credentials credentials, String charset, boolean proxy) {
        Args.notNull(credentials, "Credentials");
        Args.notNull(charset, "charset");
        StringBuilder tmp = new StringBuilder();
        tmp.append(credentials.getUserPrincipal().getName());
        tmp.append(":");
        tmp.append(credentials.getPassword() == null ? "null" : credentials.getPassword());
        byte[] base64password = Base64.encodeBase64(EncodingUtils.getBytes(tmp.toString(), charset), false);
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        if (proxy) {
            buffer.append("Proxy-Authorization");
        } else {
            buffer.append("Authorization");
        }
        buffer.append(": Basic ");
        buffer.append(base64password, 0, base64password.length);
        return new BufferedHeader(buffer);
    }
}

