/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.metrics.connection;

import com.signalfx.endpoint.SignalFxReceiverEndpoint;
import com.signalfx.metrics.SignalFxMetricsException;
import com.signalfx.metrics.connection.EventReceiver;
import com.signalfx.metrics.connection.EventReceiverFactory;
import com.signalfx.metrics.connection.HttpEventProtobufReceiverConnectionV2;
import com.signalfx.shaded.apache.http.conn.HttpClientConnectionManager;
import com.signalfx.shaded.apache.http.impl.conn.BasicHttpClientConnectionManager;

public class HttpEventProtobufReceiverFactory
implements EventReceiverFactory {
    public static final int DEFAULT_TIMEOUT_MS = 2000;
    public static final int DEFAULT_VERSION = 2;
    private final SignalFxReceiverEndpoint endpoint;
    private HttpClientConnectionManager httpClientConnectionManager = new BasicHttpClientConnectionManager();
    private int timeoutMs = 2000;
    private int version = 2;

    public HttpEventProtobufReceiverFactory(SignalFxReceiverEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public HttpEventProtobufReceiverFactory setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
    }

    public HttpEventProtobufReceiverFactory setVersion(int version) {
        this.version = version;
        return this;
    }

    public void setHttpClientConnectionManager(HttpClientConnectionManager httpClientConnectionManager) {
        this.httpClientConnectionManager = httpClientConnectionManager;
    }

    @Override
    public EventReceiver createEventReceiver() throws SignalFxMetricsException {
        if (this.version == 2) {
            return new HttpEventProtobufReceiverConnectionV2(this.endpoint, this.timeoutMs, this.httpClientConnectionManager);
        }
        throw new SignalFxMetricsException("Version v1 is deprecated, We encourage to use v2/event");
    }
}

