/*
 * Decompiled with CFR 0.152.
 */
package com.riskified.notifications;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.riskified.RiskifiedError;
import com.riskified.SHA256Handler;
import com.riskified.notifications.AuthError;
import com.riskified.notifications.Notification;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;

public class NotificationHandler {
    private Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private SHA256Handler sha256Handler;

    public NotificationHandler(String authKey) throws RiskifiedError {
        this.sha256Handler = new SHA256Handler(authKey);
    }

    public Notification toObject(String data, String hash) throws AuthError, JsonSyntaxException, IllegalStateException, UnsupportedEncodingException {
        String calcHash = this.sha256Handler.createSHA256(data.getBytes("UTF-8"));
        if (hash.equals(calcHash)) {
            return (Notification)this.gson.fromJson(data, Notification.class);
        }
        throw new AuthError(hash, calcHash);
    }

    public Notification parseServletPostRequest(HttpServletRequest req) throws AuthError, IOException {
        StringBuffer jb = this.getPostBody(req);
        String hash = req.getHeader("X-Riskified-Hmac-Sha256");
        return this.toObject(jb.toString(), hash);
    }

    private StringBuffer getPostBody(HttpServletRequest req) throws IOException {
        String line;
        StringBuffer jb = new StringBuffer();
        BufferedReader reader = req.getReader();
        while ((line = reader.readLine()) != null) {
            jb.append(line);
        }
        return jb;
    }
}

