/*
 * Decompiled with CFR 0.152.
 */
package com.riskified.models;

import com.riskified.models.LineItem;
import com.riskified.validations.FieldBadFormatException;
import com.riskified.validations.Validate;
import com.riskified.validations.Validation;
import java.util.Date;

public class TravelLineItem
extends LineItem {
    private int routeIndex;
    private int legIndex;
    private String departurePortCode;
    private String arrivalPortCode;
    private Date departureDate;
    private Date arrivalDate;
    private String departureCountryCode;
    private String arrivalCountryCode;
    private String departureCity;
    private String arrivalCity;
    private String ticketClass;
    private String legId;
    private String carrierName;
    private String carrierCode;
    private String transportMethod;

    public TravelLineItem(double price, int quantity, String title, String legId, int legIndex, int routeIndex) {
        super(price, quantity, title);
        this.legId = legId;
        this.legIndex = legIndex;
        this.routeIndex = routeIndex;
    }

    public TravelLineItem(double price, int quantity, String title, String productId, String legId, int legIndex, int routeIndex) {
        super(price, quantity, title, productId);
        this.legId = legId;
        this.legIndex = legIndex;
        this.routeIndex = routeIndex;
    }

    public TravelLineItem(double price, int quantity, String title, String productId) {
        super(price, quantity, title, productId);
    }

    public void validate(Validation validationType) throws FieldBadFormatException {
        super.validate(validationType);
        if (validationType == Validation.ALL) {
            Validate.notNull(this, this.routeIndex, "Route Index");
            Validate.notNull(this, this.legIndex, "Leg Index");
            Validate.notNull(this, this.legId, "Leg Id");
            Validate.notNull(this, this.departureCity, "Departure City");
            Validate.notNull(this, this.arrivalCity, "Arrival City");
            Validate.notNull(this, this.departureCountryCode, "Departure Country Code");
            Validate.notNull(this, this.arrivalCountryCode, "Arrival Country Code");
            Validate.notNull(this, this.departureDate, "Departure Date");
        }
        if (this.departureCountryCode != null) {
            Validate.countryCode(this, this.departureCountryCode, "Departure Country Code");
        }
        if (this.arrivalCountryCode != null) {
            Validate.countryCode(this, this.arrivalCountryCode, "Arrival Country Code");
        }
    }

    public Date getDepartureDate() {
        return this.departureDate;
    }

    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    public Date getArrivalDate() {
        return this.arrivalDate;
    }

    public void setArrivalDate(Date arrivalDate) {
        this.arrivalDate = arrivalDate;
    }

    public String getDepartureCountryCode() {
        return this.departureCountryCode;
    }

    public void setDepartureCountryCode(String departureCountryCode) {
        this.departureCountryCode = departureCountryCode;
    }

    public String getArrivalCountryCode() {
        return this.arrivalCountryCode;
    }

    public void setArrivalCountryCode(String arrivalCountryCode) {
        this.arrivalCountryCode = arrivalCountryCode;
    }

    public String getDepartureCity() {
        return this.departureCity;
    }

    public void setDepartureCity(String departureCity) {
        this.departureCity = departureCity;
    }

    public String getArrivalCity() {
        return this.arrivalCity;
    }

    public void setArrivalCity(String arrivalCity) {
        this.arrivalCity = arrivalCity;
    }

    public String getTicketClass() {
        return this.ticketClass;
    }

    public void setTicketClass(String ticketClass) {
        this.ticketClass = ticketClass;
    }

    public String getLegId() {
        return this.legId;
    }

    public void setLegId(String legId) {
        this.legId = legId;
    }

    public String getDeparturePortCode() {
        return this.departurePortCode;
    }

    public void setDeparturePortCode(String departurePortCode) {
        this.departurePortCode = departurePortCode;
    }

    public String getArrivalPortCode() {
        return this.arrivalPortCode;
    }

    public void setArrivalPortCode(String arrivalPortCode) {
        this.arrivalPortCode = arrivalPortCode;
    }

    public int getRouteIndex() {
        return this.routeIndex;
    }

    public void setRouteIndex(int routeIndex) {
        this.routeIndex = routeIndex;
    }

    public int getLegIndex() {
        return this.legIndex;
    }

    public void setLegIndex(int legIndex) {
        this.legIndex = legIndex;
    }

    public String getCarrierName() {
        return this.carrierName;
    }

    public void setCarrierName(String carrierName) {
        this.carrierName = carrierName;
    }

    public String getCarrierCode() {
        return this.carrierCode;
    }

    public void setCarrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
    }

    public String getTransportMethod() {
        return this.transportMethod;
    }

    public void setTransportMethod(String transportMethod) {
        this.transportMethod = transportMethod;
    }
}

