/*
 * Decompiled with CFR 0.152.
 */
package com.riskified.models;

import com.riskified.models.Address;
import com.riskified.models.LineItem;
import com.riskified.validations.FieldBadFormatException;
import com.riskified.validations.Validate;
import com.riskified.validations.Validation;
import java.util.Date;

public class RideLineItem
extends LineItem {
    private Date pickupDate;
    private Float pickupLatitude;
    private Float pickupLongitude;
    private Address pickupAddress;
    private Date dropoffDate;
    private Float dropoffLatitude;
    private Float dropoffLongitude;
    private Address dropoffAddress;
    private String transportMethod;
    private String priceBy;
    private String vehicleClass;
    private String carrierName;
    private String driverId;
    private String tariff;
    private String noteToDriver;
    private String meetNGreet;
    private String cancellationPolicy;
    private Float authorizedPayments;
    private int routeIndex;
    private int legIndex;

    public RideLineItem(double price, int quantity, String title, Date pickupDate, int routeIndex, int legIndex) {
        super(price, quantity, title);
        this.pickupDate = pickupDate;
        this.routeIndex = routeIndex;
        this.legIndex = legIndex;
        this.setProductType("ride");
        this.setRequiresShipping(false);
    }

    public void Validate(Validation validationType) throws FieldBadFormatException {
        super.validate(validationType);
        if (validationType == Validation.ALL) {
            Validate.notNull(this, this.pickupDate, "Pickup Date");
            Validate.notNull(this, this.routeIndex, "Route Index");
            Validate.notNull(this, this.legIndex, "Leg Index");
        }
    }

    public Date getPickupDate() {
        return this.pickupDate;
    }

    public void setPickupDate(Date pickupDate) {
        this.pickupDate = pickupDate;
    }

    public Float getPickupLatitude() {
        return this.pickupLatitude;
    }

    public void setPickupLatitude(Float pickupLatitude) {
        this.pickupLatitude = pickupLatitude;
    }

    public Float getPickupLongitude() {
        return this.pickupLongitude;
    }

    public void setPickupLongitude(Float pickupLongitude) {
        this.pickupLongitude = pickupLongitude;
    }

    public Address getPickupAddress() {
        return this.pickupAddress;
    }

    public void setPickupAddress(Address pickupAddress) {
        this.pickupAddress = pickupAddress;
    }

    public Date getDropoffDate() {
        return this.dropoffDate;
    }

    public void setDropoffDate(Date dropoffDate) {
        this.dropoffDate = dropoffDate;
    }

    public Float getDropoffLatitude() {
        return this.dropoffLatitude;
    }

    public void setDropoffLatitude(Float dropoffLatitude) {
        this.dropoffLatitude = dropoffLatitude;
    }

    public Float getDropoffLongitude() {
        return this.dropoffLongitude;
    }

    public void setDropoffLongitude(Float dropoffLongitude) {
        this.dropoffLongitude = dropoffLongitude;
    }

    public Address getDropoffAddress() {
        return this.dropoffAddress;
    }

    public void setDropoffAddress(Address dropoffAddress) {
        this.dropoffAddress = dropoffAddress;
    }

    public String getTransportMethod() {
        return this.transportMethod;
    }

    public void setTransportMethod(String transportMethod) {
        this.transportMethod = transportMethod;
    }

    public String getPriceBy() {
        return this.priceBy;
    }

    public void setPriceBy(String priceBy) {
        this.priceBy = priceBy;
    }

    public String getVehicleClass() {
        return this.vehicleClass;
    }

    public void setVehicleClass(String vehicleClass) {
        this.vehicleClass = vehicleClass;
    }

    public String getCarrierName() {
        return this.carrierName;
    }

    public void setCarrierName(String carrierName) {
        this.carrierName = carrierName;
    }

    public String getDriverId() {
        return this.driverId;
    }

    public void setDriverId(String driverId) {
        this.driverId = driverId;
    }

    public String getTariff() {
        return this.tariff;
    }

    public void setTariff(String tariff) {
        this.tariff = tariff;
    }

    public String getNoteToDriver() {
        return this.noteToDriver;
    }

    public void setNoteToDriver(String noteToDriver) {
        this.noteToDriver = noteToDriver;
    }

    public String getMeetNGreet() {
        return this.meetNGreet;
    }

    public void setMeetNGreet(String meetNGreet) {
        this.meetNGreet = meetNGreet;
    }

    public String getCancellationPolicy() {
        return this.cancellationPolicy;
    }

    public void setCancellationPolicy(String cancellationPolicy) {
        this.cancellationPolicy = cancellationPolicy;
    }

    public Float getAuthorizedPayments() {
        return this.authorizedPayments;
    }

    public void setAuthorizedPayments(Float authorizedPayments) {
        this.authorizedPayments = authorizedPayments;
    }

    public int getRouteIndex() {
        return this.routeIndex;
    }

    public void setRouteIndex(int routeIndex) {
        this.routeIndex = routeIndex;
    }

    public int getLegIndex() {
        return this.legIndex;
    }

    public void setLegIndex(int legIndex) {
        this.legIndex = legIndex;
    }
}

