/*
 * Decompiled with CFR 0.152.
 */
package com.riskified.models;

import com.riskified.validations.FieldBadFormatException;
import com.riskified.validations.IValidated;
import com.riskified.validations.Validate;
import com.riskified.validations.Validation;
import java.util.Date;

public class RefundDetails
implements IValidated {
    private String refundId;
    private String sku;
    private Date refundedAt;
    private Double amount;
    private String currency;
    private String reason;

    public void validate(Validation validationType) throws FieldBadFormatException {
        if (validationType == Validation.ALL) {
            Validate.notNullOrEmpty(this, this.refundId, "Refund Id");
            Validate.notNull(this, this.refundedAt, "Refunded At");
            Validate.notNull(this, this.amount, "Amount");
            Validate.notNull(this, this.currency, "Currency");
            Validate.notNull(this, this.reason, "Reason");
        }
        if (this.currency != null) {
            Validate.currencyCode(this, this.currency, "Currency");
        }
    }

    public String getRefundId() {
        return this.refundId;
    }

    public void setRefundId(String refundId) {
        this.refundId = refundId;
    }

    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public Date getRefundedAt() {
        return this.refundedAt;
    }

    public void setRefundedAt(Date refundedAt) {
        this.refundedAt = refundedAt;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
}

