/*
 * Decompiled with CFR 0.152.
 */
package com.riskified.models;

import com.riskified.models.RegistryType;
import com.riskified.models.Seller;
import com.riskified.models.TaxLine;
import com.riskified.validations.FieldBadFormatException;
import com.riskified.validations.IValidated;
import com.riskified.validations.Validate;
import com.riskified.validations.Validation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineItem
implements IValidated {
    private Double price;
    private Integer quantity;
    private String title;
    private String sku;
    private String productId;
    private String fulfillmentService;
    private String fulfillmentStatus;
    private Float grams;
    private String variantId;
    private String variantTitle;
    private String variantInventoryManagement;
    private String vendor;
    private String name;
    private Boolean requiresShipping;
    private Boolean taxable;
    private Boolean productExists;
    private List<Attributes> properties = new ArrayList<Attributes>();
    private List<TaxLine> taxLines = new ArrayList<TaxLine>();
    private String category;
    private String subCategory;
    private String condition;
    private Seller seller;
    private String brand;
    private String productType;
    private String size;
    private Date deliveredAt;
    private String deliveredTo;
    private String color;
    private RegistryType registryType;

    public LineItem(double price, int quantity, String title) {
        this.price = price;
        this.quantity = quantity;
        this.title = title;
    }

    public LineItem(double price, int quantity, String title, String productId) {
        this.price = price;
        this.quantity = quantity;
        this.title = title;
        this.productId = productId;
    }

    @Override
    public void validate(Validation validationType) throws FieldBadFormatException {
        if (validationType == Validation.ALL) {
            Validate.notNull(this, this.price, "Price");
            Validate.notNull(this, this.quantity, "Quantity");
            Validate.notNullOrEmpty(this, this.title, "Title");
        }
        if (this.seller != null) {
            this.seller.validate(validationType);
        }
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getFulfillmentService() {
        return this.fulfillmentService;
    }

    public void setFulfillmentService(String fulfillmentService) {
        this.fulfillmentService = fulfillmentService;
    }

    public String getFulfillmentStatus() {
        return this.fulfillmentStatus;
    }

    public void setFulfillmentStatus(String fulfillmentStatus) {
        this.fulfillmentStatus = fulfillmentStatus;
    }

    public Float getGrams() {
        return this.grams;
    }

    public void setGrams(Float grams) {
        this.grams = grams;
    }

    public String getVariantId() {
        return this.variantId;
    }

    public void setVariantId(String variantId) {
        this.variantId = variantId;
    }

    public String getVariantTitle() {
        return this.variantTitle;
    }

    public void setVariantTitle(String variantTitle) {
        this.variantTitle = variantTitle;
    }

    public String getVariantInventoryManagement() {
        return this.variantInventoryManagement;
    }

    public void setVariantInventoryManagement(String variantInventoryManagement) {
        this.variantInventoryManagement = variantInventoryManagement;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getRequiresShipping() {
        return this.requiresShipping;
    }

    public void setRequiresShipping(Boolean requiresShipping) {
        this.requiresShipping = requiresShipping;
    }

    public Boolean getTaxable() {
        return this.taxable;
    }

    public void setTaxable(Boolean taxable) {
        this.taxable = taxable;
    }

    public Boolean getProductExists() {
        return this.productExists;
    }

    public void setProductExists(Boolean productExists) {
        this.productExists = productExists;
    }

    public Seller getSeller() {
        return this.seller;
    }

    public void setSeller(Seller seller) {
        this.seller = seller;
    }

    public List<Attributes> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Attributes> properties) {
        this.properties = properties;
    }

    public List<TaxLine> getTaxLines() {
        return this.taxLines;
    }

    public void setTaxLines(List<TaxLine> taxLines) {
        this.taxLines = taxLines;
    }

    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getProductType() {
        return this.productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getSubCategory() {
        return this.subCategory;
    }

    public void setSubCategory(String subCategory) {
        this.subCategory = subCategory;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public Date getDeliveredAt() {
        return this.deliveredAt;
    }

    public void setDeliveredAt(Date deliveredAt) {
        this.deliveredAt = deliveredAt;
    }

    public String getDeliveredTo() {
        return this.deliveredTo;
    }

    public void setDeliveredTo(String deliveredTo) {
        this.deliveredTo = deliveredTo;
    }

    public RegistryType getRegistryType() {
        return this.registryType;
    }

    public void setRegistryType(RegistryType registryType) {
        this.registryType = registryType;
    }
}

