/*
 * Decompiled with CFR 0.152.
 */
package com.riskified.models;

import com.riskified.models.FulfillmentDetails;
import com.riskified.validations.FieldBadFormatException;
import com.riskified.validations.IValidated;
import com.riskified.validations.Validate;
import com.riskified.validations.Validation;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FulfillmentOrder
implements IValidated {
    private String id;
    private List<FulfillmentDetails> fulfillments;

    public FulfillmentOrder(String id, List<FulfillmentDetails> fulfillments) {
        this.id = id;
        this.fulfillments = fulfillments;
    }

    @Override
    public void validate(Validation validationType) throws FieldBadFormatException {
        if (validationType == Validation.ALL) {
            Validate.notNullOrEmpty(this, this.id, "Id");
            Validate.notNull(this, this.fulfillments, "Fulfillments");
        }
        if (this.fulfillments != null) {
            for (FulfillmentDetails fulfillmentDetails : this.fulfillments) {
                fulfillmentDetails.validate(validationType);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<FulfillmentDetails> getFulfillments() {
        return this.fulfillments;
    }

    public void setFulfillments(List<FulfillmentDetails> fulfillments) {
        this.fulfillments = fulfillments;
    }
}

