/*
 * Decompiled with CFR 0.152.
 */
package com.riskified.models;

import com.riskified.models.LineItem;
import com.riskified.validations.FieldBadFormatException;
import com.riskified.validations.IValidated;
import com.riskified.validations.Validate;
import com.riskified.validations.Validation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FulfillmentDetails
implements IValidated {
    private String fulfillmentId;
    private Date createdAt;
    private String status;
    private List<LineItem> lineItems;
    private String trackingCompany;
    private String trackingNumbers;
    private String trackingUrls;
    private String message;
    private String receipt;

    public FulfillmentDetails(String fulfillmentId, Date createdAt, String status) {
        this.fulfillmentId = fulfillmentId;
        this.createdAt = createdAt;
        this.status = status;
        this.lineItems = new ArrayList<LineItem>();
    }

    @Override
    public void validate(Validation validationType) throws FieldBadFormatException {
        if (validationType == Validation.ALL) {
            Validate.notNullOrEmpty(this, this.fulfillmentId, "Fulfillment Id");
            Validate.notNull(this, this.createdAt, "Created At");
            Validate.notNullOrEmpty(this, this.status, "Status");
        }
        if (this.lineItems != null) {
            for (LineItem lineItem : this.lineItems) {
                lineItem.validate(validationType);
            }
        }
    }

    public String getFulfillmentId() {
        return this.fulfillmentId;
    }

    public void setFulfillmentId(String fulfillmentId) {
        this.fulfillmentId = fulfillmentId;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public String getTrackingCompany() {
        return this.trackingCompany;
    }

    public void setTrackingCompany(String trackingCompany) {
        this.trackingCompany = trackingCompany;
    }

    public String getTrackingNumbers() {
        return this.trackingNumbers;
    }

    public void setTrackingNumbers(String trackingNumbers) {
        this.trackingNumbers = trackingNumbers;
    }

    public String getTrackingUrls() {
        return this.trackingUrls;
    }

    public void setTrackingUrls(String trackingUrls) {
        this.trackingUrls = trackingUrls;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getReceipt() {
        return this.receipt;
    }

    public void setReceipt(String receipt) {
        this.receipt = receipt;
    }
}

