/*
 * Decompiled with CFR 0.152.
 */
package com.riskified.models;

import com.riskified.models.Address;
import com.riskified.models.ClientDetails;
import com.riskified.models.Customer;
import com.riskified.models.IPaymentDetails;
import com.riskified.models.SessionDetails;
import com.riskified.models.SocialType;
import com.riskified.validations.FieldBadFormatException;
import com.riskified.validations.IValidated;
import com.riskified.validations.Validate;
import com.riskified.validations.Validation;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomerCreate
implements IValidated {
    private String customerId;
    private Boolean phoneMandatory;
    private String referrerCustomerId;
    private SocialType socialSignupType;
    private ClientDetails clientDetails;
    private SessionDetails sessionDetails;
    private Customer customer;
    private List<IPaymentDetails> paymentDetails;
    private List<Address> billingAddress;
    private List<Address> shippingAddress;
    private String vendorName;

    public CustomerCreate(String customerId, ClientDetails clientDetails, SessionDetails sessionDetails, Customer customer) {
        this.customerId = customerId;
        this.clientDetails = clientDetails;
        this.sessionDetails = sessionDetails;
        this.customer = customer;
    }

    @Override
    public void validate(Validation validationType) throws FieldBadFormatException {
        Validate.notNullOrEmpty(this, this.customerId, "Customer ID");
        Validate.notNull(this, this.clientDetails, "Client Details");
        Validate.notNull(this, this.sessionDetails, "Session Details");
        Validate.notNull(this, this.customer, "Customer");
        this.sessionDetails.validate(validationType);
        this.customer.validate(validationType);
        if (this.paymentDetails != null) {
            for (IPaymentDetails paymentDetail : this.paymentDetails) {
                paymentDetail.validate(validationType);
            }
        }
        if (this.billingAddress != null) {
            for (Address bAddress : this.billingAddress) {
                bAddress.validate(validationType);
            }
        }
        if (this.shippingAddress != null) {
            for (Address sAddress : this.shippingAddress) {
                sAddress.validate(validationType);
            }
        }
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public Boolean getPhoneMandatory() {
        return this.phoneMandatory;
    }

    public void setPhoneMandatory(Boolean phoneMandatory) {
        this.phoneMandatory = phoneMandatory;
    }

    public String getReferrerCustomerId() {
        return this.referrerCustomerId;
    }

    public void setReferrerCustomerId(String referrerCustomerId) {
        this.referrerCustomerId = referrerCustomerId;
    }

    public SocialType getSocialSignupType() {
        return this.socialSignupType;
    }

    public void setSocialSignupType(SocialType socialSignupType) {
        this.socialSignupType = socialSignupType;
    }

    public ClientDetails getClientDetails() {
        return this.clientDetails;
    }

    public void setClientDetails(ClientDetails clientDetails) {
        this.clientDetails = clientDetails;
    }

    public SessionDetails getSessionDetails() {
        return this.sessionDetails;
    }

    public void setSessionDetails(SessionDetails sessionDetails) {
        this.sessionDetails = sessionDetails;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public List<IPaymentDetails> getPaymentDetails() {
        return this.paymentDetails;
    }

    public void setPaymentDetails(List<IPaymentDetails> paymentDetails) {
        this.paymentDetails = paymentDetails;
    }

    public List<Address> getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(List<Address> billingAddress) {
        this.billingAddress = billingAddress;
    }

    public List<Address> getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(List<Address> shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }
}

