/*
 * Decompiled with CFR 0.152.
 */
package com.riskified.models;

import com.riskified.models.Address;
import com.riskified.models.Gender;
import com.riskified.models.SocialDetails;
import com.riskified.validations.FieldBadFormatException;
import com.riskified.validations.IValidated;
import com.riskified.validations.Validate;
import com.riskified.validations.Validation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Customer
implements IValidated {
    private String email;
    private String firstName;
    private String lastName;
    private Date createdAt;
    private Date updatedAt;
    private String id;
    private String groupId;
    private String groupName;
    private String note;
    private Integer ordersCount;
    private Boolean verifiedEmail;
    private Boolean acceptsMarketing;
    private String lastOrderId;
    private String lastOrderName;
    private String state;
    private Float totalSpent;
    private String tags;
    private Address defaultAddress;
    private List<SocialDetails> social;
    private Gender gender;
    private Address address;
    private String accountType;
    private Integer linkedAccounts;
    private String documentId;
    private String documentType;

    public Customer() {
    }

    public Customer(String email, String firstName, String lastName) {
        this.email = email;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public Customer(String email, String firstName, String lastName, String id, Date createdAt, Boolean verifiedEmail, Integer ordersCount) {
        this.email = email;
        this.firstName = firstName;
        this.lastName = lastName;
        this.id = id;
        this.createdAt = createdAt;
        this.verifiedEmail = verifiedEmail;
        this.ordersCount = ordersCount;
        this.setSocial(new ArrayList<SocialDetails>());
    }

    @Override
    public void validate(Validation validationType) throws FieldBadFormatException {
        if (validationType == Validation.ALL) {
            Validate.notNullOrEmpty(this, this.email, "Email");
            Validate.notNullOrEmpty(this, this.firstName, "First Name");
            Validate.notNullOrEmpty(this, this.lastName, "Last Name");
            Validate.notNullOrEmpty(this, this.id, "Id");
            Validate.notNull(this, this.createdAt, "Created At");
            Validate.notNull(this, this.verifiedEmail, "Verified Email");
        }
        if (this.email != null) {
            Validate.emailAddress(this, this.email, "Email");
        }
        if (this.social != null) {
            for (SocialDetails socialDetails : this.social) {
                socialDetails.validate(validationType);
            }
        }
    }

    public String getEmail() {
        return this.email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Integer getOrdersCount() {
        return this.ordersCount;
    }

    public void setVerifiedEmail(Boolean verifiedEmail) {
        this.verifiedEmail = verifiedEmail;
    }

    public Boolean getVerifiedEmail() {
        return this.verifiedEmail;
    }

    public Boolean getAcceptsMarketing() {
        return this.acceptsMarketing;
    }

    public void setAcceptsMarketing(Boolean acceptsMarketing) {
        this.acceptsMarketing = acceptsMarketing;
    }

    public String getLastOrderId() {
        return this.lastOrderId;
    }

    public void setLastOrderId(String lastOrderId) {
        this.lastOrderId = lastOrderId;
    }

    public String getLastOrderName() {
        return this.lastOrderName;
    }

    public void setLastOrderName(String lastOrderName) {
        this.lastOrderName = lastOrderName;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Float getTotalSpent() {
        return this.totalSpent;
    }

    public void setTotalSpent(Float totalSpent) {
        this.totalSpent = totalSpent;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public Address getDefaultAddress() {
        return this.defaultAddress;
    }

    public void setDefaultAddress(Address defaultAddress) {
        this.defaultAddress = defaultAddress;
    }

    public List<SocialDetails> getSocial() {
        return this.social;
    }

    public void setSocial(List<SocialDetails> social) {
        this.social = social;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public Integer getLinkedAccounts() {
        return this.linkedAccounts;
    }

    public void setLinkedAccounts(Integer linkedAccounts) {
        this.linkedAccounts = linkedAccounts;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }
}

