/*
 * Decompiled with CFR 0.152.
 */
package com.riskified.models;

import com.riskified.models.Address;
import com.riskified.models.Attributes;
import com.riskified.models.ChargeFreePaymentDetails;
import com.riskified.models.ClientDetails;
import com.riskified.models.CommunicationDetails;
import com.riskified.models.Custom;
import com.riskified.models.Customer;
import com.riskified.models.DecisionDetails;
import com.riskified.models.DiscountCode;
import com.riskified.models.IPaymentDetails;
import com.riskified.models.LineItem;
import com.riskified.models.NoChargeAmount;
import com.riskified.models.Passenger;
import com.riskified.models.ShippingLine;
import com.riskified.models.TaxLine;
import com.riskified.validations.FieldBadFormatException;
import com.riskified.validations.IValidated;
import com.riskified.validations.Validate;
import com.riskified.validations.Validation;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseOrder
implements IValidated {
    protected String id;
    private String email;
    private Date createdAt;
    private Date updatedAt;
    private String currency;
    private String gateway;
    private Double totalPrice;
    private NoChargeAmount nochargeAmount;
    private String browserIp;
    private Customer customer;
    private List<LineItem> lineItems;
    private String name;
    private List<String> additionalEmails;
    private String note;
    private String number;
    private String orderNumber;
    private String cancelReason;
    private Date cancelledAt;
    private Date closedAt;
    private String cartToken;
    private String deviceId;
    private String checkoutToken;
    private String token;
    private String referringSite;
    private Boolean confirmed;
    private Boolean buyerAcceptsMarketing;
    private String financialStatus;
    private String fulfillmentStatus;
    private String landingSite;
    private String landingSiteRef;
    private String locationId;
    private String source;
    private String sourceIdentifier;
    private String sourceName;
    private String sourceUrl;
    private Double subtotalPrice;
    private Boolean taxesIncluded;
    private Double totalDiscounts;
    private Double totalLineItemsPrice;
    private Double totalPriceUsd;
    private Double totalTax;
    private Double totalWeight;
    private String userId;
    private String processingMethod;
    private String checkoutId;
    private String tags;
    private String vendorId;
    private String vendorName;
    private String vendorIntegrationType;
    private Address shippingAddress;
    private Address billingAddress;
    private List<? extends IPaymentDetails> paymentDetails;
    private ClientDetails clientDetails;
    private List<DiscountCode> discountCodes;
    private List<ShippingLine> shippingLines;
    private List<Attributes> noteAttributes;
    private List<TaxLine> taxLines;
    private DecisionDetails decision;
    private List<Passenger> passengers;
    private Map<String, Object> additionalData;
    private String orderType;
    private ChargeFreePaymentDetails chargeFreePaymentDetails;
    private CommunicationDetails communicationDetails;
    private String submissionReason;
    private Custom custom;

    @Override
    public void validate(Validation validationType) throws FieldBadFormatException {
        Validate.notNullOrEmpty(this, this.id, "Id");
        if (validationType == Validation.ALL) {
            Validate.notNullOrEmpty(this, this.name, "Name");
            Validate.notNullOrEmpty(this, this.email, "Email");
            Validate.notNull(this, this.createdAt, "Created At");
            Validate.notNull(this, this.updatedAt, "Updated At");
            Validate.notNullOrEmpty(this, this.gateway, "Gateway");
            Validate.notNullOrEmpty(this, this.browserIp, "Browser IP");
            Validate.notNull(this, this.totalPrice, "Total Price");
            Validate.notNull(this, this.lineItems, "Line Items");
            Validate.notNull(this, this.paymentDetails, "Payment Details");
            Validate.notNull(this, this.customer, "Customer");
            Validate.notNull(this, this.billingAddress, "Billing Address");
        }
        if (this.totalPrice != null) {
            Validate.isNumberNegativeOrZero((Object)this, this.totalPrice, "Total Price");
        }
        if (this.browserIp != null) {
            Validate.ipAddress(this, this.browserIp, "Browser IP");
        }
        if (this.currency != null) {
            Validate.currencyCode(this, this.currency, "Currency");
        }
        if (this.email != null) {
            Validate.emailAddress(this, this.email, "Email");
        }
        if (this.lineItems != null) {
            for (LineItem lineItem : this.lineItems) {
                lineItem.validate(validationType);
            }
        }
        if (this.discountCodes != null) {
            for (DiscountCode discountCode : this.discountCodes) {
                discountCode.validate(validationType);
            }
        }
        if (this.shippingLines != null) {
            for (ShippingLine shippingLine : this.shippingLines) {
                shippingLine.validate(validationType);
            }
        }
        if (this.paymentDetails != null) {
            for (IPaymentDetails iPaymentDetails : this.paymentDetails) {
                iPaymentDetails.validate(validationType);
            }
        }
        if (this.customer != null) {
            this.customer.validate(validationType);
        }
        if (this.billingAddress != null) {
            this.billingAddress.validate(validationType);
        }
        if (this.shippingAddress != null) {
            this.shippingAddress.validate(validationType);
        }
        if (this.decision != null) {
            this.decision.validate(validationType);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public double getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(double totalPrice) {
        this.totalPrice = totalPrice;
    }

    public String getBrowserIp() {
        return this.browserIp;
    }

    public void setBrowserIp(String browserIp) {
        this.browserIp = browserIp;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getAdditionalEmails() {
        return this.additionalEmails;
    }

    public void setAdditionalEmails(List<String> additionalEmails) {
        this.additionalEmails = additionalEmails;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }

    public void setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    public Date getCancelledAt() {
        return this.cancelledAt;
    }

    public void setCancelledAt(Date cancelledAt) {
        this.cancelledAt = cancelledAt;
    }

    public Date getClosedAt() {
        return this.closedAt;
    }

    public void setClosedAt(Date closedAt) {
        this.closedAt = closedAt;
    }

    public String getCartToken() {
        return this.cartToken;
    }

    public void setCartToken(String cartToken) {
        this.cartToken = cartToken;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getCheckoutToken() {
        return this.checkoutToken;
    }

    public void setCheckoutToken(String checkoutToken) {
        this.checkoutToken = checkoutToken;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getReferringSite() {
        return this.referringSite;
    }

    public void setReferringSite(String referringSite) {
        this.referringSite = referringSite;
    }

    public Boolean getConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(Boolean confirmed) {
        this.confirmed = confirmed;
    }

    public Boolean getBuyerAcceptsMarketing() {
        return this.buyerAcceptsMarketing;
    }

    public void setBuyerAcceptsMarketing(Boolean buyerAcceptsMarketing) {
        this.buyerAcceptsMarketing = buyerAcceptsMarketing;
    }

    public String getFinancialStatus() {
        return this.financialStatus;
    }

    public void setFinancialStatus(String financialStatus) {
        this.financialStatus = financialStatus;
    }

    public String getFulfillmentStatus() {
        return this.fulfillmentStatus;
    }

    public void setFulfillmentStatus(String fulfillmentStatus) {
        this.fulfillmentStatus = fulfillmentStatus;
    }

    public String getLandingSite() {
        return this.landingSite;
    }

    public void setLandingSite(String landingSite) {
        this.landingSite = landingSite;
    }

    public String getLandingSiteRef() {
        return this.landingSiteRef;
    }

    public void setLandingSiteRef(String landingSiteRef) {
        this.landingSiteRef = landingSiteRef;
    }

    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public void setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public double getSubtotalPrice() {
        return this.subtotalPrice;
    }

    public void setSubtotalPrice(double subtotalPrice) {
        this.subtotalPrice = subtotalPrice;
    }

    public Boolean getTaxesIncluded() {
        return this.taxesIncluded;
    }

    public void setTaxesIncluded(Boolean taxesIncluded) {
        this.taxesIncluded = taxesIncluded;
    }

    public double getTotalDiscounts() {
        return this.totalDiscounts;
    }

    public void setTotalDiscounts(double totalDiscounts) {
        this.totalDiscounts = totalDiscounts;
    }

    public double getTotalLineItemsPrice() {
        return this.totalLineItemsPrice;
    }

    public void setTotalLineItemsPrice(double totalLineItemsPrice) {
        this.totalLineItemsPrice = totalLineItemsPrice;
    }

    public double getTotalPriceUsd() {
        return this.totalPriceUsd;
    }

    public void setTotalPriceUsd(double totalPriceUsd) {
        this.totalPriceUsd = totalPriceUsd;
    }

    public double getTotalTax() {
        return this.totalTax;
    }

    public void setTotalTax(double totalTax) {
        this.totalTax = totalTax;
    }

    public double getTotalWeight() {
        return this.totalWeight;
    }

    public void setTotalWeight(double totalWeight) {
        this.totalWeight = totalWeight;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getProcessingMethod() {
        return this.processingMethod;
    }

    public void setProcessingMethod(String processingMethod) {
        this.processingMethod = processingMethod;
    }

    public String getCheckoutId() {
        return this.checkoutId;
    }

    public void setCheckoutId(String checkoutId) {
        this.checkoutId = checkoutId;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getVendorId() {
        return this.vendorId;
    }

    public void setVendorId(String vendorId) {
        this.vendorId = vendorId;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public String getVendorIntegrationType() {
        return this.vendorIntegrationType;
    }

    public void setVendorIntegrationType(String vendorIntegrationType) {
        this.vendorIntegrationType = vendorIntegrationType;
    }

    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public List<? extends IPaymentDetails> getPaymentDetails() {
        return this.paymentDetails;
    }

    public void setPaymentDetails(List<? extends IPaymentDetails> paymentDetails) {
        this.paymentDetails = paymentDetails;
    }

    public ClientDetails getClientDetails() {
        return this.clientDetails;
    }

    public void setClientDetails(ClientDetails clientDetails) {
        this.clientDetails = clientDetails;
    }

    public List<DiscountCode> getDiscountCodes() {
        return this.discountCodes;
    }

    public void setDiscountCodes(List<DiscountCode> discountCodes) {
        this.discountCodes = discountCodes;
    }

    public List<ShippingLine> getShippingLines() {
        return this.shippingLines;
    }

    public void setShippingLines(List<ShippingLine> shippingLines) {
        this.shippingLines = shippingLines;
    }

    public List<Attributes> getNoteAttributes() {
        return this.noteAttributes;
    }

    public void setNoteAttributes(List<Attributes> noteAttributes) {
        this.noteAttributes = noteAttributes;
    }

    public List<TaxLine> getTaxLines() {
        return this.taxLines;
    }

    public void setTaxLines(List<TaxLine> taxLines) {
        this.taxLines = taxLines;
    }

    public DecisionDetails getDecision() {
        return this.decision;
    }

    public void setDecision(DecisionDetails decision) {
        this.decision = decision;
    }

    public List<Passenger> getPassengers() {
        return this.passengers;
    }

    public void setPassengers(List<Passenger> passengers) {
        this.passengers = passengers;
    }

    public Map<String, Object> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, Object> additionalData) {
        this.additionalData = additionalData;
    }

    public NoChargeAmount getNochargeAmount() {
        return this.nochargeAmount;
    }

    public void setNochargeAmount(NoChargeAmount nochargeAmount) {
        this.nochargeAmount = nochargeAmount;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public ChargeFreePaymentDetails getChargeFreePaymentDetails() {
        return this.chargeFreePaymentDetails;
    }

    public void setChargeFreePaymentDetails(ChargeFreePaymentDetails chargeFreePaymentDetails) {
        this.chargeFreePaymentDetails = chargeFreePaymentDetails;
    }

    public String getSubmissionReason() {
        return this.submissionReason;
    }

    public void setSubmissionReason(String submissionReason) {
        this.submissionReason = submissionReason;
    }

    public CommunicationDetails getCommunicationDetails() {
        return this.communicationDetails;
    }

    public void setCommunicationDetails(CommunicationDetails communicationDetails) {
        this.communicationDetails = communicationDetails;
    }

    public Custom getCustom() {
        return this.custom;
    }

    public void setCustom(Custom custom) {
        this.custom = custom;
    }
}

