/*
 * Decompiled with CFR 0.152.
 */
package com.riskified;

import com.riskified.Environment;

public class Utils {
    public static final String DEBUG_ENVIRONMENT = "http://localhost:3000";
    public static final String SANDBOX_ENVIRONMENT = "https://sandbox.riskified.com";
    public static final String PRODUCTION_ENVIRONMENT = "https://wh.riskified.com";
    public static final String PRODUCTION_SYNC_ANALYZE_ENVIRONMENT = "https://wh-sync.riskified.com";
    public static final String DECO_SANDBOX_ENVIRONMENT = "https://sandboxw.decopayments.com";
    public static final String DECO_PRODUCTION_ENVIRONMENT = "https://w.decopayments.com";
    public static final String ACCOUNT_SANDBOX_ENVIRONMENT = "https://api-sandbox.riskified.com";
    public static final String ACCOUNT_PRODUCTION_ENVIRONMENT = "https://api.riskified.com";
    public static final String SCREEN_SANDBOX_ENVIRONMENT = "https://screen-sandbox.riskified.com";

    public static String getBaseUrlFromEnvironment(Environment environmentType) {
        return Utils.getUrlString(environmentType, SANDBOX_ENVIRONMENT, PRODUCTION_ENVIRONMENT);
    }

    public static String getBaseUrlSyncAnalyzeFromEnvironment(Environment environmentType) {
        return Utils.getUrlString(environmentType, SANDBOX_ENVIRONMENT, PRODUCTION_SYNC_ANALYZE_ENVIRONMENT);
    }

    public static String getDecoBaseFromEnvironment(Environment environmentType) {
        return Utils.getUrlString(environmentType, DECO_SANDBOX_ENVIRONMENT, DECO_PRODUCTION_ENVIRONMENT);
    }

    public static String getAccountBaseFromEnvironment(Environment environmentType) {
        return Utils.getUrlString(environmentType, ACCOUNT_SANDBOX_ENVIRONMENT, ACCOUNT_PRODUCTION_ENVIRONMENT);
    }

    public static String getScreenBaseFromEnvironment(Environment environmentType) {
        return Utils.getUrlString(environmentType, SCREEN_SANDBOX_ENVIRONMENT, PRODUCTION_ENVIRONMENT);
    }

    private static String getUrlString(Environment environmentType, String sandboxEnvironment, String productionEnvironment) {
        String url = null;
        if (environmentType != null) {
            switch (environmentType) {
                case DEBUG: {
                    url = DEBUG_ENVIRONMENT;
                    break;
                }
                case SANDBOX: {
                    url = sandboxEnvironment;
                    break;
                }
                case PRODUCTION: {
                    url = productionEnvironment;
                }
            }
        }
        return url;
    }
}

