/*
 * Decompiled with CFR 0.152.
 */
package com.riskified;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.riskified.Environment;
import com.riskified.JSONFormater;
import com.riskified.ProxyClientDetails;
import com.riskified.RiskifiedError;
import com.riskified.SHA256Handler;
import com.riskified.Utils;
import com.riskified.models.ArrayOrders;
import com.riskified.models.CancelOrder;
import com.riskified.models.ChargebackOrder;
import com.riskified.models.CheckoutDeniedOrder;
import com.riskified.models.CheckoutOrder;
import com.riskified.models.CheckoutOrderWrapper;
import com.riskified.models.CheckoutResponse;
import com.riskified.models.Contact;
import com.riskified.models.CustomerCreate;
import com.riskified.models.CustomerUpdate;
import com.riskified.models.DecisionOrder;
import com.riskified.models.FulfillmentOrder;
import com.riskified.models.Login;
import com.riskified.models.Logout;
import com.riskified.models.Order;
import com.riskified.models.OrderWrapper;
import com.riskified.models.Redeem;
import com.riskified.models.RefundOrder;
import com.riskified.models.ResetPassword;
import com.riskified.models.Response;
import com.riskified.models.Verification;
import com.riskified.models.Wishlist;
import com.riskified.validations.FieldBadFormatException;
import com.riskified.validations.IValidated;
import com.riskified.validations.Validation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class RiskifiedClient {
    private Validation validation = Validation.ALL;
    private Environment environment = Environment.SANDBOX;
    private String baseUrl;
    private String baseUrlSyncAnalyze;
    private String decoBaseUrl;
    private String screenBaseUrl;
    private String accountBaseUrl;
    private String shopUrl;
    private SHA256Handler sha256Handler;
    private int requestTimeout = 10000;
    private int connectionTimeout = 5000;
    private String authKey;
    private String proxyUrl;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private HttpClientContext context;

    public RiskifiedClient() throws RiskifiedError {
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getClassLoader().getResourceAsStream("riskified_sdk.properties"));
        }
        catch (IOException e) {
            throw new RiskifiedError("There was an error reading the config file in: src/main/resources/riskified_sdk.properties");
        }
        String shopUrl = properties.getProperty("shopUrl");
        String authKey = properties.getProperty("authKey");
        String environmentType = properties.getProperty("environment");
        String validationType = properties.getProperty("validation");
        String proxyUrl = properties.getProperty("proxyUrl");
        String proxyPort = properties.getProperty("proxyPort");
        String proxyUserName = properties.getProperty("proxyUsername");
        String proxyPassword = properties.getProperty("proxyPassword");
        if (validationType.equals("NONE")) {
            this.validation = Validation.NONE;
        } else if (validationType.equals("IGNORE_MISSING")) {
            this.validation = Validation.IGNORE_MISSING;
        } else if (validationType.equals("ALL")) {
            this.validation = Validation.ALL;
        }
        if (environmentType.equals("DEBUG")) {
            this.environment = Environment.DEBUG;
        } else if (environmentType.equals("PRODUCTION")) {
            this.environment = Environment.PRODUCTION;
        } else if (environmentType.equals("SANDBOX")) {
            this.environment = Environment.SANDBOX;
        }
        this.init(shopUrl, authKey, Utils.getBaseUrlFromEnvironment(this.environment), Utils.getBaseUrlSyncAnalyzeFromEnvironment(this.environment), Utils.getDecoBaseFromEnvironment(this.environment), Utils.getAccountBaseFromEnvironment(this.environment), Utils.getScreenBaseFromEnvironment(this.environment), this.validation);
        if (proxyUrl != null) {
            this.initProxy(proxyUrl, proxyPort, proxyUserName, proxyPassword);
        }
    }

    public RiskifiedClient(String shopUrl, String authKey, Environment environment) throws RiskifiedError {
        this.init(shopUrl, authKey, Utils.getBaseUrlFromEnvironment(environment), Utils.getBaseUrlSyncAnalyzeFromEnvironment(environment), Utils.getDecoBaseFromEnvironment(environment), Utils.getAccountBaseFromEnvironment(environment), Utils.getScreenBaseFromEnvironment(environment), Validation.ALL);
    }

    public RiskifiedClient(String shopUrl, String authKey, Environment environment, ProxyClientDetails proxyClientDetails) throws RiskifiedError {
        this.init(shopUrl, authKey, Utils.getBaseUrlFromEnvironment(environment), Utils.getBaseUrlSyncAnalyzeFromEnvironment(environment), Utils.getDecoBaseFromEnvironment(environment), Utils.getAccountBaseFromEnvironment(environment), Utils.getScreenBaseFromEnvironment(environment), Validation.ALL);
        this.initProxy(proxyClientDetails);
    }

    public RiskifiedClient(String shopUrl, String authKey, Environment environment, Validation validation) throws RiskifiedError {
        this.init(shopUrl, authKey, Utils.getBaseUrlFromEnvironment(environment), Utils.getBaseUrlSyncAnalyzeFromEnvironment(environment), Utils.getDecoBaseFromEnvironment(environment), Utils.getAccountBaseFromEnvironment(environment), Utils.getScreenBaseFromEnvironment(environment), validation);
    }

    public RiskifiedClient(String shopUrl, String authKey, Environment environment, Validation validation, ProxyClientDetails proxyClientDetails) throws RiskifiedError {
        this.init(shopUrl, authKey, Utils.getBaseUrlFromEnvironment(environment), Utils.getBaseUrlSyncAnalyzeFromEnvironment(environment), Utils.getDecoBaseFromEnvironment(environment), Utils.getAccountBaseFromEnvironment(environment), Utils.getScreenBaseFromEnvironment(environment), validation);
        this.initProxy(proxyClientDetails);
    }

    public RiskifiedClient(String shopUrl, String authKey, Validation validation, String baseUrl, String baseUrlSyncAnalyze, String decoBaseUrl, String accountBaseUrl, String screenBaseUrl) throws RiskifiedError {
        this.init(shopUrl, authKey, baseUrl, baseUrlSyncAnalyze, decoBaseUrl, accountBaseUrl, screenBaseUrl, validation);
    }

    private void init(String shopUrl, String authKey, String baseUrl, String baseUrlSyncAnalyze, String decoBaseUrl, String accountBaseUrl, String screenBaseUrl, Validation validationType) throws RiskifiedError {
        this.baseUrl = baseUrl;
        this.baseUrlSyncAnalyze = baseUrlSyncAnalyze;
        this.decoBaseUrl = decoBaseUrl;
        this.accountBaseUrl = accountBaseUrl;
        this.screenBaseUrl = screenBaseUrl;
        this.shopUrl = shopUrl;
        this.sha256Handler = new SHA256Handler(authKey);
        this.validation = validationType;
    }

    private void initProxy(String proxyUrl, String proxyPort, String proxyUsername, String proxyPassword) {
        this.proxyUrl = proxyUrl;
        this.proxyPort = Integer.parseInt(proxyPort);
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
    }

    private void initProxy(ProxyClientDetails proxyClientDetails) {
        this.proxyUrl = proxyClientDetails.getProxyUrl();
        this.proxyPort = proxyClientDetails.getProxyPort();
        this.proxyUsername = proxyClientDetails.getProxyUsername();
        this.proxyPassword = proxyClientDetails.getProxyPassword();
    }

    public Response checkoutOrder(CheckoutOrder order) throws IOException, FieldBadFormatException {
        String url = this.baseUrl + "/api/checkout_create";
        if (this.validation != Validation.NONE) {
            this.validate(order, Validation.IGNORE_MISSING);
        }
        return this.postCheckoutOrder(new CheckoutOrderWrapper<CheckoutOrder>(order), url);
    }

    public Response adviseOrder(CheckoutOrder order) throws IOException, FieldBadFormatException {
        String url = this.baseUrl + "/api/advise";
        if (this.validation != Validation.NONE) {
            this.validate(order, Validation.IGNORE_MISSING);
        }
        return this.postCheckoutOrder(new CheckoutOrderWrapper<CheckoutOrder>(order), url);
    }

    public Response checkoutOrder(CheckoutOrder order, Validation validation) throws IOException, FieldBadFormatException {
        String url = this.baseUrl + "/api/checkout_create";
        this.validate(order, validation);
        return this.postCheckoutOrder(new CheckoutOrderWrapper<CheckoutOrder>(order), url);
    }

    public Response checkoutDeniedOrder(CheckoutDeniedOrder order) throws IOException, FieldBadFormatException {
        String url = this.baseUrl + "/api/checkout_denied";
        this.validate(order);
        return this.postCheckoutOrder(new CheckoutOrderWrapper<CheckoutDeniedOrder>(order), url);
    }

    public Response checkoutDeniedOrder(CheckoutDeniedOrder order, Validation validation) throws IOException, FieldBadFormatException {
        String url = this.baseUrl + "/api/checkout_denied";
        this.validate(order, validation);
        return this.postCheckoutOrder(new CheckoutOrderWrapper<CheckoutDeniedOrder>(order), url);
    }

    public Response createOrder(Order order) throws IOException, FieldBadFormatException {
        String url = this.baseUrl + "/api/create";
        this.validate(order);
        return this.postOrder(new OrderWrapper<Order>(order), url);
    }

    public Response createOrder(Order order, Validation validation) throws IOException, FieldBadFormatException {
        String url = this.baseUrl + "/api/create";
        this.validate(order, validation);
        return this.postOrder(new OrderWrapper<Order>(order), url);
    }

    public Response submitOrder(Order order) throws IOException, FieldBadFormatException {
        return this.submitOrder(order, this.validation);
    }

    public Response submitOrder(Order order, Validation validation) throws IOException, FieldBadFormatException {
        String url = this.baseUrl + "/api/submit";
        this.validate(order, validation);
        return this.postOrder(new OrderWrapper<Order>(order), url);
    }

    public Response updateOrder(Order order) throws IOException, FieldBadFormatException {
        String url = this.baseUrl + "/api/update";
        if (this.validation != Validation.NONE) {
            this.validate(order, Validation.IGNORE_MISSING);
        }
        return this.postOrder(new OrderWrapper<Order>(order), url);
    }

    public Response updateOrder(Order order, Validation validation) throws IOException, FieldBadFormatException {
        String url = this.baseUrl + "/api/update";
        this.validate(order, validation);
        return this.postOrder(new OrderWrapper<Order>(order), url);
    }

    public Response cancelOrder(CancelOrder order) throws IOException, FieldBadFormatException {
        String url = this.baseUrl + "/api/cancel";
        this.validate(order);
        return this.postOrder(new OrderWrapper<CancelOrder>(order), url);
    }

    public Response cancelOrder(CancelOrder order, Validation validation) throws IOException, FieldBadFormatException {
        String url = this.baseUrl + "/api/cancel";
        this.validate(order, validation);
        return this.postOrder(new OrderWrapper<CancelOrder>(order), url);
    }

    public Response refundOrder(RefundOrder order) throws IOException, FieldBadFormatException {
        String url = this.baseUrl + "/api/refund";
        this.validate(order);
        return this.postOrder(new OrderWrapper<RefundOrder>(order), url);
    }

    public Response refundOrder(RefundOrder order, Validation validation) throws IOException, FieldBadFormatException {
        String url = this.baseUrl + "/api/refund";
        this.validate(order, validation);
        return this.postOrder(new OrderWrapper<RefundOrder>(order), url);
    }

    public Response fulfillOrder(FulfillmentOrder order) throws IOException, FieldBadFormatException {
        String url = this.baseUrl + "/api/fulfill";
        this.validate(order);
        return this.postOrder(new OrderWrapper<FulfillmentOrder>(order), url);
    }

    public Response fulfillOrder(FulfillmentOrder order, Validation validation) throws IOException, FieldBadFormatException {
        String url = this.baseUrl + "/api/fulfill";
        this.validate(order, validation);
        return this.postOrder(new OrderWrapper<FulfillmentOrder>(order), url);
    }

    public Response decisionOrder(DecisionOrder order) throws IOException, FieldBadFormatException {
        String url = this.baseUrl + "/api/decision";
        this.validate(order);
        return this.postOrder(new OrderWrapper<DecisionOrder>(order), url);
    }

    public Response decisionOrder(DecisionOrder order, Validation validation) throws IOException, FieldBadFormatException {
        String url = this.baseUrl + "/api/decision";
        this.validate(order, validation);
        return this.postOrder(new OrderWrapper<DecisionOrder>(order), url);
    }

    public Response screenOrder(CheckoutOrder order) throws IOException, FieldBadFormatException {
        String url = this.screenBaseUrl + "/api/screen";
        this.validate(order, this.validation);
        return this.postCheckoutOrder(new CheckoutOrderWrapper<CheckoutOrder>(order), url);
    }

    public Response analyzeOrder(Order order) throws IOException, FieldBadFormatException {
        String url = this.baseUrlSyncAnalyze + "/api/decide";
        this.validate(order);
        return this.postOrder(new OrderWrapper<Order>(order), url);
    }

    public Response eligible(Order order) throws IOException, FieldBadFormatException {
        String url = this.decoBaseUrl + "/api/eligible";
        return this.postOrder(new OrderWrapper<Order>(order), url);
    }

    public Response opt_in(Order order) throws IOException, FieldBadFormatException {
        String url = this.decoBaseUrl + "/api/opt_in";
        return this.postOrder(new OrderWrapper<Order>(order), url);
    }

    public Response chargebackOrder(ChargebackOrder order) throws IOException, FieldBadFormatException {
        String url = this.baseUrl + "/api/chargeback";
        this.validate(order);
        return this.postOrder(new OrderWrapper<ChargebackOrder>(order), url);
    }

    public Response historicalOrders(ArrayOrders orders) throws IOException, FieldBadFormatException {
        String url = this.baseUrl + "/api/historical";
        this.validate(orders);
        return this.postOrder(orders, url);
    }

    public Response historicalOrders(ArrayOrders orders, Validation validation) throws IOException, FieldBadFormatException {
        String url = this.baseUrl + "/api/historical";
        this.validate(orders, validation);
        return this.postOrder(orders, url);
    }

    public Response login(Login login) throws IOException, FieldBadFormatException {
        String url = this.accountBaseUrl + "/customers/login";
        this.validate(login, this.validation);
        return this.postOrder(login, url);
    }

    public Response customerCreate(CustomerCreate customerCreate) throws IOException, FieldBadFormatException {
        String url = this.accountBaseUrl + "/customers/customer_create";
        this.validate(customerCreate, this.validation);
        return this.postOrder(customerCreate, url);
    }

    public Response customerUpdate(CustomerUpdate customerUpdate) throws IOException, FieldBadFormatException {
        String url = this.accountBaseUrl + "/customers/customer_update";
        this.validate(customerUpdate, this.validation);
        return this.postOrder(customerUpdate, url);
    }

    public Response logout(Logout logout) throws IOException, FieldBadFormatException {
        String url = this.accountBaseUrl + "/customers/logout";
        this.validate(logout, this.validation);
        return this.postOrder(logout, url);
    }

    public Response resetPassword(ResetPassword resetPassword) throws IOException, FieldBadFormatException {
        String url = this.accountBaseUrl + "/customers/reset_password";
        this.validate(resetPassword, this.validation);
        return this.postOrder(resetPassword, url);
    }

    public Response wishlist(Wishlist wishlist) throws IOException, FieldBadFormatException {
        String url = this.accountBaseUrl + "/customers/wishlist";
        this.validate(wishlist, this.validation);
        return this.postOrder(wishlist, url);
    }

    public Response redeem(Redeem redeem) throws IOException, FieldBadFormatException {
        String url = this.accountBaseUrl + "/customers/redeem";
        this.validate(redeem, this.validation);
        return this.postOrder(redeem, url);
    }

    public Response contact(Contact contact) throws IOException, FieldBadFormatException {
        String url = this.accountBaseUrl + "/customers/contact";
        this.validate(contact, this.validation);
        return this.postOrder(contact, url);
    }

    public Response verification(Verification verification) throws IOException, FieldBadFormatException {
        String url = this.accountBaseUrl + "/customers/verification";
        this.validate(verification, this.validation);
        return this.postOrder(verification, url);
    }

    private Response postCheckoutOrder(Object data, String url) throws IOException, FieldBadFormatException {
        HttpPost request = this.createPostRequest(url);
        this.addDataToRequest(data, request);
        HttpClient client = this.constructHttpClient();
        HttpResponse response = this.executeClient(client, request);
        String postBody = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        int status = response.getStatusLine().getStatusCode();
        CheckoutResponse responseObject = this.getCheckoutResponseObject(postBody);
        switch (status) {
            case 200: {
                return responseObject;
            }
            case 400: {
                throw new HttpResponseException(status, responseObject.getError().getMessage());
            }
            case 401: {
                throw new HttpResponseException(status, responseObject.getError().getMessage());
            }
            case 404: {
                throw new HttpResponseException(status, responseObject.getError().getMessage());
            }
            case 504: {
                throw new HttpResponseException(status, "Temporary error, please retry");
            }
        }
        throw new HttpResponseException(500, "Contact Riskified support");
    }

    private HttpClient constructHttpClient() {
        RequestConfig.Builder requestBuilder = RequestConfig.custom().setConnectTimeout(this.connectionTimeout).setConnectionRequestTimeout(this.requestTimeout);
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultRequestConfig(requestBuilder.build());
        if (this.proxyUrl != null) {
            this.setProxyWithAuth(builder);
        }
        return builder.build();
    }

    private HttpResponse executeClient(HttpClient client, HttpPost request) throws IOException {
        HttpResponse response = this.context != null ? client.execute((HttpUriRequest)request, (HttpContext)this.context) : client.execute((HttpUriRequest)request);
        return response;
    }

    private CredentialsProvider getHttpProxyCredentials() {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(new HttpHost(this.proxyUrl, this.proxyPort)), (Credentials)new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword));
        return credsProvider;
    }

    private void setProxyWithAuth(HttpClientBuilder builder) {
        builder.setProxy(new HttpHost(this.proxyUrl, this.proxyPort));
        builder.setDefaultCredentialsProvider(this.getHttpProxyCredentials());
        builder.setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
        if (this.context == null) {
            try {
                this.setProxyContext();
            }
            catch (MalformedChallengeException e) {
                System.out.println("Error: failed to process challenge for proxy");
            }
        }
    }

    private void setProxyContext() throws MalformedChallengeException {
        BasicScheme proxyAuth = new BasicScheme();
        proxyAuth.processChallenge((Header)new BasicHeader("Proxy-Authenticate", "BASIC realm=default"));
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(new HttpHost(this.proxyUrl, this.proxyPort), (AuthScheme)proxyAuth);
        HttpClientContext context = HttpClientContext.create();
        context.setAuthCache((AuthCache)authCache);
        context.setCredentialsProvider(this.getHttpProxyCredentials());
        this.context = context;
    }

    private Response postOrder(Object data, String url) throws IOException {
        HttpPost request = this.createPostRequest(url);
        this.addDataToRequest(data, request);
        HttpClient client = this.constructHttpClient();
        HttpResponse response = this.executeClient(client, request);
        String postBody = EntityUtils.toString((HttpEntity)response.getEntity());
        int status = response.getStatusLine().getStatusCode();
        Response responseObject = this.getResponseObject(postBody);
        switch (status) {
            case 200: {
                return responseObject;
            }
            case 400: {
                throw new HttpResponseException(status, postBody);
            }
            case 401: {
                throw new HttpResponseException(status, postBody);
            }
            case 404: {
                throw new HttpResponseException(status, postBody);
            }
            case 504: {
                throw new HttpResponseException(status, "Temporary error, please retry");
            }
        }
        throw new HttpResponseException(500, "Contact Riskified support");
    }

    private Response getResponseObject(String postBody) throws IOException {
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        Response res = (Response)gson.fromJson(postBody, Response.class);
        return res;
    }

    private CheckoutResponse getCheckoutResponseObject(String postBody) throws IOException {
        Gson gson = new Gson();
        CheckoutResponse res = (CheckoutResponse)gson.fromJson(postBody, CheckoutResponse.class);
        res.setOrder(res.getCheckout());
        return res;
    }

    private void addDataToRequest(Object data, HttpPost postRequest) throws IllegalStateException, UnsupportedEncodingException {
        String jsonData = JSONFormater.toJson(data);
        byte[] body = jsonData.getBytes("UTF-8");
        String hmac = this.sha256Handler.createSHA256(body);
        postRequest.setHeader("X-RISKIFIED-HMAC-SHA256", hmac);
        ByteArrayEntity input = new ByteArrayEntity(body, ContentType.APPLICATION_JSON);
        postRequest.setEntity((HttpEntity)input);
    }

    private HttpPost createPostRequest(String url) {
        HttpPost postRequest = new HttpPost(url);
        postRequest.setHeader("Accept", "application/vnd.riskified.com; version=2");
        postRequest.setHeader("X-RISKIFIED-SHOP-DOMAIN", this.shopUrl);
        postRequest.setHeader("User-Agent", "riskified_java_sdk/1.3.5");
        return postRequest;
    }

    private void validate(IValidated objToValidated) throws FieldBadFormatException {
        if (this.validation != Validation.NONE) {
            objToValidated.validate(this.validation);
        }
    }

    private void validate(IValidated objToValidated, Validation validationType) throws FieldBadFormatException {
        if (validationType != Validation.NONE) {
            objToValidated.validate(validationType);
        }
    }

    public String getShopUrl() {
        return this.shopUrl;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getAuthKey() {
        return this.authKey;
    }

    public void setBaseUrl(String url) {
        this.baseUrl = url;
    }

    public Validation getValidation() {
        return this.validation;
    }

    public void setValidation(Validation validation) {
        this.validation = validation;
    }

    public RiskifiedClient(RiskifiedClientBuilder riskifiedClientBuilder) throws RiskifiedError {
        this.shopUrl = riskifiedClientBuilder.shopUrl;
        this.authKey = riskifiedClientBuilder.authKey;
        this.environment = riskifiedClientBuilder.environment;
        if (riskifiedClientBuilder.validation != null) {
            this.validation = riskifiedClientBuilder.validation;
        }
        if (riskifiedClientBuilder.requestTimeout != null) {
            this.requestTimeout = riskifiedClientBuilder.requestTimeout;
        }
        if (riskifiedClientBuilder.connectionTimeout != null) {
            this.connectionTimeout = riskifiedClientBuilder.connectionTimeout;
        }
        this.sha256Handler = new SHA256Handler(this.authKey);
        this.baseUrl = Utils.getBaseUrlFromEnvironment(this.environment);
        this.baseUrlSyncAnalyze = Utils.getBaseUrlSyncAnalyzeFromEnvironment(this.environment);
        this.decoBaseUrl = Utils.getDecoBaseFromEnvironment(this.environment);
        this.accountBaseUrl = Utils.getAccountBaseFromEnvironment(this.environment);
    }

    public static class RiskifiedClientBuilder {
        private String shopUrl;
        private String authKey;
        private Environment environment;
        private Integer requestTimeout;
        private Integer connectionTimeout;
        private Validation validation;

        public RiskifiedClientBuilder(String shopUrl, String authKey, Environment environment) {
            this.shopUrl = shopUrl;
            this.authKey = authKey;
            this.environment = environment;
        }

        public RiskifiedClientBuilder setRequestTimeout(Integer requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public RiskifiedClientBuilder setConnectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public RiskifiedClientBuilder setValidation(Validation validation) {
            this.validation = validation;
            return this;
        }

        public RiskifiedClient build() throws RiskifiedError {
            return new RiskifiedClient(this);
        }
    }
}

