/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.numeric;

import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import com.redis.om.spring.search.stream.predicates.jedis.JedisValues;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;
import redis.clients.jedis.search.querybuilder.QueryNode;
import redis.clients.jedis.search.querybuilder.Value;
import redis.clients.jedis.search.querybuilder.Values;

public class InPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private final List<T> values;

    public InPredicate(SearchFieldAccessor field, List<T> values) {
        super(field);
        this.values = values;
    }

    public List<T> getValues() {
        return this.values;
    }

    @Override
    public Node apply(Node root) {
        if (ObjectUtils.isEmpty(this.getValues())) {
            return root;
        }
        QueryNode or = QueryBuilders.union((Node[])new Node[0]);
        Class<?> cls = this.values.get(0).getClass();
        for (T value : this.getValues()) {
            if (cls == Integer.class) {
                or.add(this.getSearchAlias(), new Value[]{Values.eq((int)Integer.parseInt(value.toString()))});
                continue;
            }
            if (cls == Long.class) {
                or.add(this.getSearchAlias(), new Value[]{Values.eq((double)Long.parseLong(value.toString()))});
                continue;
            }
            if (cls == LocalDate.class) {
                or.add(this.getSearchAlias(), new Value[]{JedisValues.eq((LocalDate)value)});
                continue;
            }
            if (cls == Date.class) {
                or.add(this.getSearchAlias(), new Value[]{JedisValues.eq((Date)value)});
                continue;
            }
            if (cls == LocalDateTime.class) {
                or.add(this.getSearchAlias(), new Value[]{JedisValues.eq((LocalDateTime)value)});
                continue;
            }
            if (cls == Instant.class) {
                or.add(this.getSearchAlias(), new Value[]{JedisValues.eq((Instant)value)});
                continue;
            }
            or.add(this.getSearchAlias(), new Value[]{Values.eq((double)Double.parseDouble(value.toString()))});
        }
        return QueryBuilders.intersect((Node[])new Node[]{root, or});
    }
}

