/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring;

import jakarta.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="redis.om.spring", ignoreInvalidFields=true)
public class RedisOMProperties {
    public static int MAX_SEARCH_RESULTS = 10000;
    private final Repository repository = new Repository();
    private final Djl djl = new Djl();

    public Repository getRepository() {
        return this.repository;
    }

    public Djl getDjl() {
        return this.djl;
    }

    public static class Repository {
        private final Query query = new Query();

        public Query getQuery() {
            return this.query;
        }

        public static class Query {
            private int limit = MAX_SEARCH_RESULTS;

            public int getLimit() {
                return this.limit;
            }

            public void setLimit(int limit) {
                this.limit = limit;
            }
        }
    }

    public static class Djl {
        private static final String DEFAULT_ENGINE = "PyTorch";
        private boolean enabled = false;
        @NotNull
        private String imageEmbeddingModelEngine = "PyTorch";
        @NotNull
        private String imageEmbeddingModelModelUrls = "djl://ai.djl.pytorch/resnet18_embedding";
        private int defaultImagePipelineResizeWidth = 224;
        private int defaultImagePipelineResizeHeight = 224;
        private boolean defaultImagePipelineCenterCrop = true;
        @NotNull
        private String sentenceTokenizerMaxLength = "768";
        @NotNull
        private String sentenceTokenizerModelMaxLength = "768";
        @NotNull
        private String sentenceTokenizerModel = "sentence-transformers/all-mpnet-base-v2";
        @NotNull
        private String faceDetectionModelEngine = "PyTorch";
        @NotNull
        private String faceDetectionModelName = "retinaface";
        @NotNull
        private String faceDetectionModelModelUrls = "https://resources.djl.ai/test-models/pytorch/retinaface.zip";
        @NotNull
        private String faceEmbeddingModelEngine = "PyTorch";
        @NotNull
        private String faceEmbeddingModelName = "face_feature";
        @NotNull
        private String faceEmbeddingModelModelUrls = "https://resources.djl.ai/test-models/pytorch/face_feature.zip";

        public boolean isEnabled() {
            return this.enabled;
        }

        @NotNull
        public String getImageEmbeddingModelEngine() {
            return this.imageEmbeddingModelEngine;
        }

        @NotNull
        public String getImageEmbeddingModelModelUrls() {
            return this.imageEmbeddingModelModelUrls;
        }

        public int getDefaultImagePipelineResizeWidth() {
            return this.defaultImagePipelineResizeWidth;
        }

        public int getDefaultImagePipelineResizeHeight() {
            return this.defaultImagePipelineResizeHeight;
        }

        public boolean isDefaultImagePipelineCenterCrop() {
            return this.defaultImagePipelineCenterCrop;
        }

        @NotNull
        public String getSentenceTokenizerMaxLength() {
            return this.sentenceTokenizerMaxLength;
        }

        @NotNull
        public String getSentenceTokenizerModelMaxLength() {
            return this.sentenceTokenizerModelMaxLength;
        }

        @NotNull
        public String getSentenceTokenizerModel() {
            return this.sentenceTokenizerModel;
        }

        @NotNull
        public String getFaceDetectionModelEngine() {
            return this.faceDetectionModelEngine;
        }

        @NotNull
        public String getFaceDetectionModelName() {
            return this.faceDetectionModelName;
        }

        @NotNull
        public String getFaceDetectionModelModelUrls() {
            return this.faceDetectionModelModelUrls;
        }

        @NotNull
        public String getFaceEmbeddingModelEngine() {
            return this.faceEmbeddingModelEngine;
        }

        @NotNull
        public String getFaceEmbeddingModelName() {
            return this.faceEmbeddingModelName;
        }

        @NotNull
        public String getFaceEmbeddingModelModelUrls() {
            return this.faceEmbeddingModelModelUrls;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setImageEmbeddingModelEngine(@NotNull String imageEmbeddingModelEngine) {
            this.imageEmbeddingModelEngine = imageEmbeddingModelEngine;
        }

        public void setImageEmbeddingModelModelUrls(@NotNull String imageEmbeddingModelModelUrls) {
            this.imageEmbeddingModelModelUrls = imageEmbeddingModelModelUrls;
        }

        public void setDefaultImagePipelineResizeWidth(int defaultImagePipelineResizeWidth) {
            this.defaultImagePipelineResizeWidth = defaultImagePipelineResizeWidth;
        }

        public void setDefaultImagePipelineResizeHeight(int defaultImagePipelineResizeHeight) {
            this.defaultImagePipelineResizeHeight = defaultImagePipelineResizeHeight;
        }

        public void setDefaultImagePipelineCenterCrop(boolean defaultImagePipelineCenterCrop) {
            this.defaultImagePipelineCenterCrop = defaultImagePipelineCenterCrop;
        }

        public void setSentenceTokenizerMaxLength(@NotNull String sentenceTokenizerMaxLength) {
            this.sentenceTokenizerMaxLength = sentenceTokenizerMaxLength;
        }

        public void setSentenceTokenizerModelMaxLength(@NotNull String sentenceTokenizerModelMaxLength) {
            this.sentenceTokenizerModelMaxLength = sentenceTokenizerModelMaxLength;
        }

        public void setSentenceTokenizerModel(@NotNull String sentenceTokenizerModel) {
            this.sentenceTokenizerModel = sentenceTokenizerModel;
        }

        public void setFaceDetectionModelEngine(@NotNull String faceDetectionModelEngine) {
            this.faceDetectionModelEngine = faceDetectionModelEngine;
        }

        public void setFaceDetectionModelName(@NotNull String faceDetectionModelName) {
            this.faceDetectionModelName = faceDetectionModelName;
        }

        public void setFaceDetectionModelModelUrls(@NotNull String faceDetectionModelModelUrls) {
            this.faceDetectionModelModelUrls = faceDetectionModelModelUrls;
        }

        public void setFaceEmbeddingModelEngine(@NotNull String faceEmbeddingModelEngine) {
            this.faceEmbeddingModelEngine = faceEmbeddingModelEngine;
        }

        public void setFaceEmbeddingModelName(@NotNull String faceEmbeddingModelName) {
            this.faceEmbeddingModelName = faceEmbeddingModelName;
        }

        public void setFaceEmbeddingModelModelUrls(@NotNull String faceEmbeddingModelModelUrls) {
            this.faceEmbeddingModelModelUrls = faceEmbeddingModelModelUrls;
        }

        public String toString() {
            return "RedisOMSpringProperties.Djl(enabled=" + this.isEnabled() + ", imageEmbeddingModelEngine=" + this.getImageEmbeddingModelEngine() + ", imageEmbeddingModelModelUrls=" + this.getImageEmbeddingModelModelUrls() + ", defaultImagePipelineResizeWidth=" + this.getDefaultImagePipelineResizeWidth() + ", defaultImagePipelineResizeHeight=" + this.getDefaultImagePipelineResizeHeight() + ", defaultImagePipelineCenterCrop=" + this.isDefaultImagePipelineCenterCrop() + ", sentenceTokenizerMaxLength=" + this.getSentenceTokenizerMaxLength() + ", sentenceTokenizerModelMaxLength=" + this.getSentenceTokenizerModelMaxLength() + ", sentenceTokenizerModel=" + this.getSentenceTokenizerModel() + ", faceDetectionModelEngine=" + this.getFaceDetectionModelEngine() + ", faceDetectionModelName=" + this.getFaceDetectionModelName() + ", faceDetectionModelModelUrls=" + this.getFaceDetectionModelModelUrls() + ", faceEmbeddingModelEngine=" + this.getFaceEmbeddingModelEngine() + ", faceEmbeddingModelName=" + this.getFaceEmbeddingModelName() + ", faceEmbeddingModelModelUrls=" + this.getFaceEmbeddingModelModelUrls() + ")";
        }
    }
}

