/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.http.client.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.rabbitmq.http.client.domain.OwnerPidDetails;
import com.rabbitmq.http.client.domain.RateDetails;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(value={"backing_queue_status"})
public class QueueInfo {
    private String vhost;
    private String name;
    private boolean durable;
    private boolean exclusive;
    @JsonProperty(value="auto_delete")
    private boolean autoDelete;
    private Map<String, Object> arguments;
    private String node;
    @JsonProperty(value="exclusive_consumer_tag")
    private String exclusiveConsumerTag;
    private String state;
    private String policy;
    @JsonProperty(value="idle_since")
    private String idleSince;
    @JsonProperty(value="disk_reads")
    private long diskReads;
    @JsonProperty(value="disk_writes")
    private long diskWrites;
    @JsonProperty(value="memory")
    private long memoryUsed;
    @JsonProperty(value="message_bytes")
    private long messageBytes;
    @JsonProperty(value="message_bytes_persistent")
    private long messageBytesPersistent;
    @JsonProperty(value="message_bytes_ram")
    private long messageBytesRAM;
    @JsonProperty(value="message_bytes_ready")
    private long messageBytesReady;
    @JsonProperty(value="message_bytes_unacknowledged")
    private long messageBytesUnacknowledged;
    @JsonProperty(value="messages")
    private long totalMessages;
    @JsonProperty(value="message_stats")
    private RateDetails messageStats;
    @JsonProperty(value="messages_persistent")
    private long totalPersistentMessages;
    @JsonProperty(value="messages_ram")
    private long totalTransientMessages;
    @JsonProperty(value="messages_ready")
    private long messagesReady;
    @JsonProperty(value="messages_ready_details")
    private RateDetails messagesReadyDetails;
    @JsonProperty(value="messages_unacknowledged")
    private long messagesUnacknowledged;
    @JsonProperty(value="messages_unacknowledged_details")
    private RateDetails messagesUnacknowledgedDetails;
    @JsonProperty(value="owner_pid_details")
    private OwnerPidDetails ownerPidDetails;
    @JsonProperty(value="consumers")
    private long consumerCount;
    @JsonIgnore
    @JsonProperty(value="consumer_utilisation")
    private long consumerUtilisation;

    public QueueInfo() {
    }

    public QueueInfo(boolean durable, boolean exclusive, boolean autoDelete) {
        this(durable, exclusive, autoDelete, new HashMap<String, Object>());
    }

    public QueueInfo(boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) {
        this.durable = durable;
        this.exclusive = exclusive;
        this.autoDelete = autoDelete;
        this.arguments = arguments;
    }

    public String getVhost() {
        return this.vhost;
    }

    public void setVhost(String vhost) {
        this.vhost = vhost;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public boolean isExclusive() {
        return this.exclusive || this.ownerPidDetails != null;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public void setAutoDelete(boolean autoDelete) {
        this.autoDelete = autoDelete;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public void setArguments(Map<String, Object> arguments) {
        this.arguments = arguments;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public String getExclusiveConsumerTag() {
        return this.exclusiveConsumerTag;
    }

    public void setExclusiveConsumerTag(String exclusiveConsumerTag) {
        this.exclusiveConsumerTag = exclusiveConsumerTag;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public String getIdleSince() {
        return this.idleSince;
    }

    public void setIdleSince(String idleSince) {
        this.idleSince = idleSince;
    }

    public long getDiskReads() {
        return this.diskReads;
    }

    public void setDiskReads(long diskReads) {
        this.diskReads = diskReads;
    }

    public long getDiskWrites() {
        return this.diskWrites;
    }

    public void setDiskWrites(long diskWrites) {
        this.diskWrites = diskWrites;
    }

    public long getMemoryUsed() {
        return this.memoryUsed;
    }

    public void setMemoryUsed(long memoryUsed) {
        this.memoryUsed = memoryUsed;
    }

    public long getMessageBytes() {
        return this.messageBytes;
    }

    public void setMessageBytes(long messageBytes) {
        this.messageBytes = messageBytes;
    }

    public long getMessageBytesPersistent() {
        return this.messageBytesPersistent;
    }

    public void setMessageBytesPersistent(long messageBytesPersistent) {
        this.messageBytesPersistent = messageBytesPersistent;
    }

    public long getMessageBytesRAM() {
        return this.messageBytesRAM;
    }

    public void setMessageBytesRAM(long messageBytesRAM) {
        this.messageBytesRAM = messageBytesRAM;
    }

    public long getMessageBytesReady() {
        return this.messageBytesReady;
    }

    public void setMessageBytesReady(long messageBytesReady) {
        this.messageBytesReady = messageBytesReady;
    }

    public long getMessageBytesUnacknowledged() {
        return this.messageBytesUnacknowledged;
    }

    public void setMessageBytesUnacknowledged(long messageBytesUnacknowledged) {
        this.messageBytesUnacknowledged = messageBytesUnacknowledged;
    }

    public long getTotalMessages() {
        return this.totalMessages;
    }

    public void setTotalMessages(long totalMessages) {
        this.totalMessages = totalMessages;
    }

    public RateDetails getMessageStats() {
        return this.messageStats;
    }

    public void setMessageStats(RateDetails messageStats) {
        this.messageStats = messageStats;
    }

    public long getTotalPersistentMessages() {
        return this.totalPersistentMessages;
    }

    public void setTotalPersistentMessages(long totalPersistentMessages) {
        this.totalPersistentMessages = totalPersistentMessages;
    }

    public long getTotalTransientMessages() {
        return this.totalTransientMessages;
    }

    public void setTotalTransientMessages(long totalTransientMessages) {
        this.totalTransientMessages = totalTransientMessages;
    }

    public long getMessagesReady() {
        return this.messagesReady;
    }

    public void setMessagesReady(long messagesReady) {
        this.messagesReady = messagesReady;
    }

    public RateDetails getMessagesReadyDetails() {
        return this.messagesReadyDetails;
    }

    public void setMessagesReadyDetails(RateDetails messagesReadyDetails) {
        this.messagesReadyDetails = messagesReadyDetails;
    }

    public long getMessagesUnacknowledged() {
        return this.messagesUnacknowledged;
    }

    public void setMessagesUnacknowledged(long messagesUnacknowledged) {
        this.messagesUnacknowledged = messagesUnacknowledged;
    }

    public RateDetails getMessagesUnacknowledgedDetails() {
        return this.messagesUnacknowledgedDetails;
    }

    public void setMessagesUnacknowledgedDetails(RateDetails messagesUnacknowledgedDetails) {
        this.messagesUnacknowledgedDetails = messagesUnacknowledgedDetails;
    }

    public long getConsumerCount() {
        return this.consumerCount;
    }

    public void setConsumerCount(long consumerCount) {
        this.consumerCount = consumerCount;
    }

    public long getConsumerUtilisation() {
        return this.consumerUtilisation;
    }

    public void setConsumerUtilisation(long consumerUtilisation) {
        this.consumerUtilisation = consumerUtilisation;
    }

    public void setOwnerPidDetails(OwnerPidDetails ownerPidDetails) {
        this.ownerPidDetails = ownerPidDetails;
    }

    public String toString() {
        return "QueueInfo{vhost='" + this.vhost + '\'' + ", name='" + this.name + '\'' + ", durable=" + this.durable + ", exclusive=" + this.exclusive + ", autoDelete=" + this.autoDelete + ", arguments=" + this.arguments + ", node='" + this.node + '\'' + ", exclusiveConsumerTag='" + this.exclusiveConsumerTag + '\'' + ", state='" + this.state + '\'' + ", policy='" + this.policy + '\'' + ", idleSince='" + this.idleSince + '\'' + ", diskReads=" + this.diskReads + ", diskWrites=" + this.diskWrites + ", memoryUsed=" + this.memoryUsed + ", messageBytes=" + this.messageBytes + ", messageBytesPersistent=" + this.messageBytesPersistent + ", messageBytesRAM=" + this.messageBytesRAM + ", messageBytesReady=" + this.messageBytesReady + ", messageBytesUnacknowledged=" + this.messageBytesUnacknowledged + ", totalMessages=" + this.totalMessages + ", messageStats=" + this.messageStats + ", totalPersistentMessages=" + this.totalPersistentMessages + ", totalTransientMessages=" + this.totalTransientMessages + ", messagesReady=" + this.messagesReady + ", messagesReadyDetails=" + this.messagesReadyDetails + ", messagesUnacknowledged=" + this.messagesUnacknowledged + ", messagesUnacknowledgedDetails=" + this.messagesUnacknowledgedDetails + ", consumerCount=" + this.consumerCount + '}';
    }
}

