/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.ExceptionHandler;
import com.rabbitmq.client.impl.ForgivingExceptionHandler;
import java.io.IOException;
import java.util.concurrent.TimeoutException;

public class StrictExceptionHandler
extends ForgivingExceptionHandler
implements ExceptionHandler {
    @Override
    public void handleReturnListenerException(Channel channel, Throwable exception) {
        this.handleChannelKiller(channel, exception, "ReturnListener.handleReturn");
    }

    @Override
    public void handleFlowListenerException(Channel channel, Throwable exception) {
        this.handleChannelKiller(channel, exception, "FlowListener.handleFlow");
    }

    @Override
    public void handleConfirmListenerException(Channel channel, Throwable exception) {
        this.handleChannelKiller(channel, exception, "ConfirmListener.handle{N,A}ck");
    }

    @Override
    public void handleBlockedListenerException(Connection connection, Throwable exception) {
        this.handleConnectionKiller(connection, exception, "BlockedListener");
    }

    @Override
    public void handleConsumerException(Channel channel, Throwable exception, Consumer consumer, String consumerTag, String methodName) {
        this.handleChannelKiller(channel, exception, "Consumer " + consumer + " (" + consumerTag + ") method " + methodName + " for channel " + channel);
    }

    @Override
    protected void handleChannelKiller(Channel channel, Throwable exception, String what) {
        this.log(what + " threw an exception for channel " + channel, exception);
        try {
            channel.close(200, "Closed due to exception from " + what);
        }
        catch (AlreadyClosedException alreadyClosedException) {
        }
        catch (TimeoutException timeoutException) {
        }
        catch (IOException ioe) {
            this.log("Failure during close of channel " + channel + " after " + exception, ioe);
            channel.getConnection().abort(541, "Internal error closing channel for " + what);
        }
    }
}

