/*
 * Copyright 2015, The Querydsl Team (http://www.querydsl.com/team)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.querydsl

/**
 * Common definitions used by this querydsl-scala
 */
package object scala {

  import com.querydsl.core.types._

  type Ex[T] = Expression[T]

  type Tu2Ex[A,B] = Tuple2Expression[A,B]

  type Tu3Ex[A,B,C] = Tuple3Expression[A,B,C]

  type Tu4Ex[A,B,C,D] = Tuple4Expression[A,B,C,D]

  type Tu5Ex[A,B,C,D,E] = Tuple5Expression[A,B,C,D,E]

  type Tu6Ex[A,B,C,D,E,F] = Tuple6Expression[A,B,C,D,E,F]

  type Tu7Ex[A,B,C,D,E,F,G] = Tuple7Expression[A,B,C,D,E,F,G]

  type Tu8Ex[A,B,C,D,E,F,G,H] = Tuple8Expression[A,B,C,D,E,F,G,H]

  type Tu9Ex[A,B,C,D,E,F,G,H,I] = Tuple9Expression[A,B,C,D,E,F,G,H,I]

  type Tu10Ex[A,B,C,D,E,F,G,H,I,J] = Tuple10Expression[A,B,C,D,E,F,G,H,I,J]

  type Tu11Ex[A,B,C,D,E,F,G,H,I,J,K] = Tuple11Expression[A,B,C,D,E,F,G,H,I,J,K]

  type Tu12Ex[A,B,C,D,E,F,G,H,I,J,K,L] = Tuple12Expression[A,B,C,D,E,F,G,H,I,J,K,L]

  type Tu13Ex[A,B,C,D,E,F,G,H,I,J,K,L,M] = Tuple13Expression[A,B,C,D,E,F,G,H,I,J,K,L,M]

  type Tu14Ex[A,B,C,D,E,F,G,H,I,J,K,L,M,N] = Tuple14Expression[A,B,C,D,E,F,G,H,I,J,K,L,M,N]

  type Tu15Ex[A,B,C,D,E,F,G,H,I,J,K,L,M,N,O] = Tuple15Expression[A,B,C,D,E,F,G,H,I,J,K,L,M,N,O]

  type Tu16Ex[A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P] = Tuple16Expression[A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P]

  type Tu17Ex[A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q] = Tuple17Expression[A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q]

  type Tu18Ex[A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R] = Tuple18Expression[A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R]

  type Tu19Ex[A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S] = Tuple19Expression[A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S]

  type Tu20Ex[A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T] = Tuple20Expression[A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T]

}