/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.JavadocDetailNodeParser;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.utils.BlockCommentPosition;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class AbstractJavadocCheck
extends AbstractCheck {
    public static final String MSG_JAVADOC_MISSED_HTML_CLOSE = "javadoc.missed.html.close";
    public static final String MSG_JAVADOC_WRONG_SINGLETON_TAG = "javadoc.wrong.singleton.html.tag";
    public static final String MSG_JAVADOC_PARSE_RULE_ERROR = "javadoc.parse.rule.error";
    public static final String MSG_KEY_PARSE_ERROR = "javadoc.parse.error";
    public static final String MSG_KEY_UNRECOGNIZED_ANTLR_ERROR = "javadoc.unrecognized.antlr.error";
    private static final ThreadLocal<Map<String, JavadocDetailNodeParser.ParseStatus>> TREE_CACHE = new ThreadLocal<Map<String, JavadocDetailNodeParser.ParseStatus>>(){

        @Override
        protected Map<String, JavadocDetailNodeParser.ParseStatus> initialValue() {
            return new HashMap<String, JavadocDetailNodeParser.ParseStatus>();
        }
    };
    private final JavadocDetailNodeParser parser = new JavadocDetailNodeParser();
    private final Set<Integer> javadocTokens = new HashSet<Integer>();
    private DetailAST blockCommentAst;

    public abstract int[] getDefaultJavadocTokens();

    public abstract void visitJavadocToken(DetailNode var1);

    public int[] getAcceptableJavadocTokens() {
        int[] defaultJavadocTokens = this.getDefaultJavadocTokens();
        int[] copy = new int[defaultJavadocTokens.length];
        System.arraycopy(defaultJavadocTokens, 0, copy, 0, defaultJavadocTokens.length);
        return copy;
    }

    public int[] getRequiredJavadocTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    public final void setJavadocTokens(String ... strRep) {
        this.javadocTokens.clear();
        for (String str : strRep) {
            this.javadocTokens.add(JavadocUtils.getTokenId(str));
        }
    }

    @Override
    public void init() {
        this.validateDefaultJavadocTokens();
        if (this.javadocTokens.isEmpty()) {
            for (int id : this.getDefaultJavadocTokens()) {
                this.javadocTokens.add(id);
            }
        } else {
            int[] acceptableJavadocTokens = this.getAcceptableJavadocTokens();
            Arrays.sort(acceptableJavadocTokens);
            for (Integer javadocTokenId : this.javadocTokens) {
                if (Arrays.binarySearch(acceptableJavadocTokens, javadocTokenId) >= 0) continue;
                String message = String.format(Locale.ROOT, "Javadoc Token \"%s\" was not found in Acceptable javadoc tokens list in check %s", JavadocUtils.getTokenName(javadocTokenId), this.getClass().getName());
                throw new IllegalStateException(message);
            }
        }
    }

    private void validateDefaultJavadocTokens() {
        if (this.getRequiredJavadocTokens().length != 0) {
            int[] defaultJavadocTokens = this.getDefaultJavadocTokens();
            Arrays.sort(defaultJavadocTokens);
            for (int javadocToken : this.getRequiredJavadocTokens()) {
                if (Arrays.binarySearch(defaultJavadocTokens, javadocToken) >= 0) continue;
                String message = String.format(Locale.ROOT, "Javadoc Token \"%s\" from required javadoc tokens was not found in default javadoc tokens list in check %s", javadocToken, this.getClass().getName());
                throw new IllegalStateException(message);
            }
        }
    }

    public void beginJavadocTree(DetailNode rootAst) {
    }

    public void finishJavadocTree(DetailNode rootAst) {
    }

    public void leaveJavadocToken(DetailNode ast) {
    }

    @Override
    public final int[] getDefaultTokens() {
        return new int[]{145};
    }

    @Override
    public final boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public final void beginTree(DetailAST rootAST) {
        TREE_CACHE.get().clear();
    }

    @Override
    public final void finishTree(DetailAST rootAST) {
        TREE_CACHE.get().clear();
    }

    @Override
    public final void visitToken(DetailAST blockCommentNode) {
        if (JavadocUtils.isJavadocComment(blockCommentNode) && AbstractJavadocCheck.isCorrectJavadocPosition(blockCommentNode)) {
            JavadocDetailNodeParser.ParseStatus result;
            this.blockCommentAst = blockCommentNode;
            String treeCacheKey = blockCommentNode.getLineNo() + ":" + blockCommentNode.getColumnNo();
            if (TREE_CACHE.get().containsKey(treeCacheKey)) {
                result = TREE_CACHE.get().get(treeCacheKey);
            } else {
                result = this.parser.parseJavadocAsDetailNode(blockCommentNode);
                TREE_CACHE.get().put(treeCacheKey, result);
            }
            if (result.getParseErrorMessage() == null) {
                this.processTree(result.getTree());
            } else {
                JavadocDetailNodeParser.ParseErrorMessage parseErrorMessage = result.getParseErrorMessage();
                this.log(parseErrorMessage.getLineNumber(), parseErrorMessage.getMessageKey(), parseErrorMessage.getMessageArguments());
            }
        }
    }

    protected DetailAST getBlockCommentAst() {
        return this.blockCommentAst;
    }

    private static boolean isCorrectJavadocPosition(DetailAST blockComment) {
        return BlockCommentPosition.isOnClass(blockComment) || BlockCommentPosition.isOnInterface(blockComment) || BlockCommentPosition.isOnEnum(blockComment) || BlockCommentPosition.isOnMethod(blockComment) || BlockCommentPosition.isOnField(blockComment) || BlockCommentPosition.isOnConstructor(blockComment) || BlockCommentPosition.isOnEnumConstant(blockComment) || BlockCommentPosition.isOnAnnotationDef(blockComment);
    }

    private void processTree(DetailNode root) {
        this.beginJavadocTree(root);
        this.walk(root);
        this.finishJavadocTree(root);
    }

    private void walk(DetailNode root) {
        DetailNode curNode = root;
        while (curNode != null) {
            boolean waitsForProcessing = this.shouldBeProcessed(curNode);
            if (waitsForProcessing) {
                this.visitJavadocToken(curNode);
            }
            DetailNode toVisit = JavadocUtils.getFirstChild(curNode);
            while (curNode != null && toVisit == null) {
                if (waitsForProcessing) {
                    this.leaveJavadocToken(curNode);
                }
                if ((toVisit = JavadocUtils.getNextSibling(curNode)) != null || (curNode = curNode.getParent()) == null) continue;
                waitsForProcessing = this.shouldBeProcessed(curNode);
            }
            curNode = toVisit;
        }
    }

    private boolean shouldBeProcessed(DetailNode curNode) {
        return this.javadocTokens.contains(curNode.getType());
    }
}

