/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.AbstractLoader;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.checks.imports.AbstractImportRule;
import com.puppycrawl.tools.checkstyle.checks.imports.ClassImportRule;
import com.puppycrawl.tools.checkstyle.checks.imports.ImportControl;
import com.puppycrawl.tools.checkstyle.checks.imports.MismatchStrategy;
import com.puppycrawl.tools.checkstyle.checks.imports.PkgImportRule;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class ImportControlLoader
extends AbstractLoader {
    private static final String DTD_PUBLIC_ID_1_0 = "-//Puppy Crawl//DTD Import Control 1.0//EN";
    private static final String DTD_PUBLIC_ID_1_1 = "-//Puppy Crawl//DTD Import Control 1.1//EN";
    private static final String DTD_PUBLIC_ID_1_2 = "-//Puppy Crawl//DTD Import Control 1.2//EN";
    private static final String DTD_PUBLIC_ID_1_3 = "-//Puppy Crawl//DTD Import Control 1.3//EN";
    private static final String DTD_RESOURCE_NAME_1_0 = "com/puppycrawl/tools/checkstyle/checks/imports/import_control_1_0.dtd";
    private static final String DTD_RESOURCE_NAME_1_1 = "com/puppycrawl/tools/checkstyle/checks/imports/import_control_1_1.dtd";
    private static final String DTD_RESOURCE_NAME_1_2 = "com/puppycrawl/tools/checkstyle/checks/imports/import_control_1_2.dtd";
    private static final String DTD_RESOURCE_NAME_1_3 = "com/puppycrawl/tools/checkstyle/checks/imports/import_control_1_3.dtd";
    private static final Map<String, String> DTD_RESOURCE_BY_ID = new HashMap<String, String>();
    private static final String PKG_ATTRIBUTE_NAME = "pkg";
    private static final String STRATEGY_ON_MISMATCH_ATTRIBUTE_NAME = "strategyOnMismatch";
    private static final String STRATEGY_ON_MISMATCH_ALLOWED_VALUE = "allowed";
    private static final String STRATEGY_ON_MISMATCH_DISALLOWED_VALUE = "disallowed";
    private static final String SUBPACKAGE_ELEMENT_NAME = "subpackage";
    private static final String ALLOW_ELEMENT_NAME = "allow";
    private final Deque<ImportControl> stack = new ArrayDeque<ImportControl>();

    private ImportControlLoader() throws ParserConfigurationException, SAXException {
        super(DTD_RESOURCE_BY_ID);
    }

    @Override
    public void startElement(String namespaceUri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("import-control".equals(qName)) {
            String pkg = ImportControlLoader.safeGet(attributes, PKG_ATTRIBUTE_NAME);
            MismatchStrategy strategyOnMismatch = ImportControlLoader.getStrategyForImportControl(attributes);
            boolean regex = ImportControlLoader.containsRegexAttribute(attributes);
            this.stack.push(new ImportControl(pkg, regex, strategyOnMismatch));
        } else if (SUBPACKAGE_ELEMENT_NAME.equals(qName)) {
            String name = ImportControlLoader.safeGet(attributes, "name");
            MismatchStrategy strategyOnMismatch = ImportControlLoader.getStrategyForSubpackage(attributes);
            boolean regex = ImportControlLoader.containsRegexAttribute(attributes);
            this.stack.push(new ImportControl(this.stack.peek(), name, regex, strategyOnMismatch));
        } else if (ALLOW_ELEMENT_NAME.equals(qName) || "disallow".equals(qName)) {
            AbstractImportRule rule;
            boolean isAllow = ALLOW_ELEMENT_NAME.equals(qName);
            boolean isLocalOnly = attributes.getValue("local-only") != null;
            String pkg = attributes.getValue(PKG_ATTRIBUTE_NAME);
            boolean regex = ImportControlLoader.containsRegexAttribute(attributes);
            if (pkg == null) {
                String clazz = ImportControlLoader.safeGet(attributes, "class");
                rule = new ClassImportRule(isAllow, isLocalOnly, clazz, regex);
            } else {
                boolean exactMatch = attributes.getValue("exact-match") != null;
                rule = new PkgImportRule(isAllow, isLocalOnly, pkg, exactMatch, regex);
            }
            this.stack.peek().addImportRule(rule);
        }
    }

    private static boolean containsRegexAttribute(Attributes attributes) {
        return attributes.getValue("regex") != null;
    }

    @Override
    public void endElement(String namespaceUri, String localName, String qName) {
        if (SUBPACKAGE_ELEMENT_NAME.equals(qName)) {
            this.stack.pop();
        }
    }

    public static ImportControl load(URI uri) throws CheckstyleException {
        InputStream inputStream = null;
        try {
            inputStream = uri.toURL().openStream();
            InputSource source = new InputSource(inputStream);
            ImportControl importControl = ImportControlLoader.load(source, uri);
            return importControl;
        }
        catch (MalformedURLException ex) {
            throw new CheckstyleException("syntax error in url " + uri, ex);
        }
        catch (IOException ex) {
            throw new CheckstyleException("unable to find " + uri, ex);
        }
        finally {
            ImportControlLoader.closeStream(inputStream);
        }
    }

    private static ImportControl load(InputSource source, URI uri) throws CheckstyleException {
        try {
            ImportControlLoader loader = new ImportControlLoader();
            loader.parseInputSource(source);
            return loader.getRoot();
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new CheckstyleException("unable to parse " + uri + " - " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new CheckstyleException("unable to read " + uri, ex);
        }
    }

    private static void closeStream(InputStream inputStream) throws CheckstyleException {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException ex) {
                throw new CheckstyleException("unable to close input stream", ex);
            }
        }
    }

    private ImportControl getRoot() {
        return this.stack.peek();
    }

    private static MismatchStrategy getStrategyForImportControl(Attributes attributes) {
        String returnValue = attributes.getValue(STRATEGY_ON_MISMATCH_ATTRIBUTE_NAME);
        MismatchStrategy strategyOnMismatch = MismatchStrategy.DISALLOWED;
        if (STRATEGY_ON_MISMATCH_ALLOWED_VALUE.equals(returnValue)) {
            strategyOnMismatch = MismatchStrategy.ALLOWED;
        }
        return strategyOnMismatch;
    }

    private static MismatchStrategy getStrategyForSubpackage(Attributes attributes) {
        String returnValue = attributes.getValue(STRATEGY_ON_MISMATCH_ATTRIBUTE_NAME);
        MismatchStrategy strategyOnMismatch = MismatchStrategy.DELEGATE_TO_PARENT;
        if (STRATEGY_ON_MISMATCH_ALLOWED_VALUE.equals(returnValue)) {
            strategyOnMismatch = MismatchStrategy.ALLOWED;
        } else if (STRATEGY_ON_MISMATCH_DISALLOWED_VALUE.equals(returnValue)) {
            strategyOnMismatch = MismatchStrategy.DISALLOWED;
        }
        return strategyOnMismatch;
    }

    private static String safeGet(Attributes attributes, String name) throws SAXException {
        String returnValue = attributes.getValue(name);
        if (returnValue == null) {
            throw new SAXException("missing attribute " + name);
        }
        return returnValue;
    }

    static {
        DTD_RESOURCE_BY_ID.put(DTD_PUBLIC_ID_1_0, DTD_RESOURCE_NAME_1_0);
        DTD_RESOURCE_BY_ID.put(DTD_PUBLIC_ID_1_1, DTD_RESOURCE_NAME_1_1);
        DTD_RESOURCE_BY_ID.put(DTD_PUBLIC_ID_1_2, DTD_RESOURCE_NAME_1_2);
        DTD_RESOURCE_BY_ID.put(DTD_PUBLIC_ID_1_3, DTD_RESOURCE_NAME_1_3);
    }
}

