/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.checks.imports.AbstractImportRule;
import com.puppycrawl.tools.checkstyle.checks.imports.AccessResult;
import com.puppycrawl.tools.checkstyle.checks.imports.MismatchStrategy;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

class ImportControl {
    private static final String DOT = ".";
    private static final Pattern DOT_PATTERN = Pattern.compile(".", 16);
    private static final String DOT_REGEX = "\\.";
    private final Deque<AbstractImportRule> rules = new LinkedList<AbstractImportRule>();
    private final List<ImportControl> children = new ArrayList<ImportControl>();
    private final ImportControl parent;
    private final String fullPackage;
    private final Pattern patternForPartialMatch;
    private final Pattern patternForExactMatch;
    private final boolean regex;
    private final MismatchStrategy strategyOnMismatch;

    ImportControl(String pkgName, boolean regex, MismatchStrategy strategyOnMismatch) {
        this.parent = null;
        this.regex = regex;
        this.strategyOnMismatch = strategyOnMismatch;
        if (regex) {
            this.fullPackage = ImportControl.encloseInGroup(pkgName);
            this.patternForPartialMatch = ImportControl.createPatternForPartialMatch(this.fullPackage);
            this.patternForExactMatch = ImportControl.createPatternForExactMatch(this.fullPackage);
        } else {
            this.fullPackage = pkgName;
            this.patternForPartialMatch = null;
            this.patternForExactMatch = null;
        }
    }

    ImportControl(String pkgName, boolean regex) {
        this(pkgName, regex, MismatchStrategy.DISALLOWED);
    }

    ImportControl(ImportControl parent, String subPkg, boolean regex, MismatchStrategy strategyOnMismatch) {
        this.parent = parent;
        this.strategyOnMismatch = strategyOnMismatch;
        if (regex || parent.regex) {
            String parentRegex = ImportControl.ensureSelfContainedRegex(parent.fullPackage, parent.regex);
            String thisRegex = ImportControl.ensureSelfContainedRegex(subPkg, regex);
            this.fullPackage = parentRegex + DOT_REGEX + thisRegex;
            this.patternForPartialMatch = ImportControl.createPatternForPartialMatch(this.fullPackage);
            this.patternForExactMatch = ImportControl.createPatternForExactMatch(this.fullPackage);
            this.regex = true;
        } else {
            this.fullPackage = parent.fullPackage + DOT + subPkg;
            this.patternForPartialMatch = null;
            this.patternForExactMatch = null;
            this.regex = false;
        }
        parent.children.add(this);
    }

    ImportControl(ImportControl parent, String subPkg, boolean regex) {
        this(parent, subPkg, regex, MismatchStrategy.DELEGATE_TO_PARENT);
    }

    private static String ensureSelfContainedRegex(String input, boolean alreadyRegex) {
        String result = alreadyRegex ? ImportControl.encloseInGroup(input) : ImportControl.toRegex(input);
        return result;
    }

    private static String encloseInGroup(String expression) {
        return "(?:" + expression + ")";
    }

    private static String toRegex(String input) {
        return DOT_PATTERN.matcher(input).replaceAll(DOT_REGEX);
    }

    private static Pattern createPatternForPartialMatch(String expression) {
        return Pattern.compile(expression + "(?:\\..*)?");
    }

    private static Pattern createPatternForExactMatch(String expression) {
        return Pattern.compile(expression);
    }

    protected void addImportRule(AbstractImportRule rule) {
        this.rules.addFirst(rule);
    }

    public ImportControl locateFinest(String forPkg) {
        ImportControl finestMatch = null;
        if (this.matchesAtFront(forPkg)) {
            finestMatch = this;
            for (ImportControl child : this.children) {
                ImportControl match = child.locateFinest(forPkg);
                if (match == null) continue;
                finestMatch = match;
                break;
            }
        }
        return finestMatch;
    }

    private boolean matchesAtFront(String pkg) {
        boolean result = this.regex ? this.patternForPartialMatch.matcher(pkg).matches() : this.matchesAtFrontNoRegex(pkg);
        return result;
    }

    private boolean matchesAtFrontNoRegex(String pkg) {
        return pkg.startsWith(this.fullPackage) && (pkg.length() == this.fullPackage.length() || pkg.charAt(this.fullPackage.length()) == '.');
    }

    public AccessResult checkAccess(String inPkg, String forImport) {
        AccessResult returnValue = this.localCheckAccess(inPkg, forImport);
        AccessResult result = returnValue != AccessResult.UNKNOWN ? returnValue : (this.parent == null ? (this.strategyOnMismatch == MismatchStrategy.ALLOWED ? AccessResult.ALLOWED : AccessResult.DISALLOWED) : (this.strategyOnMismatch == MismatchStrategy.ALLOWED ? AccessResult.ALLOWED : (this.strategyOnMismatch == MismatchStrategy.DISALLOWED ? AccessResult.DISALLOWED : this.parent.checkAccess(inPkg, forImport))));
        return result;
    }

    private AccessResult localCheckAccess(String inPkg, String forImport) {
        AccessResult localCheckAccessResult = AccessResult.UNKNOWN;
        for (AbstractImportRule importRule : this.rules) {
            AccessResult result;
            if (importRule.isLocalOnly() && !this.matchesExactly(inPkg) || (result = importRule.verifyImport(forImport)) == AccessResult.UNKNOWN) continue;
            localCheckAccessResult = result;
            break;
        }
        return localCheckAccessResult;
    }

    private boolean matchesExactly(String pkg) {
        boolean result = this.regex ? this.patternForExactMatch.matcher(pkg).matches() : this.fullPackage.equals(pkg);
        return result;
    }
}

