/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.checks.javadoc.HtmlTag;
import java.util.List;

class TagParser {
    private final List<HtmlTag> mTags = Lists.newLinkedList();

    public TagParser(String[] aText, int aLineNo) {
        this.parseTags(aText, aLineNo);
    }

    public HtmlTag nextTag() {
        return this.mTags.remove(0);
    }

    public boolean hasNextTag() {
        return !this.mTags.isEmpty();
    }

    private void add(HtmlTag aTag) {
        this.mTags.add(aTag);
    }

    private void parseTags(String[] aText, int aLineNo) {
        int nLines = aText.length;
        Point position = new Point(0, 0);
        position = this.findChar(aText, '<', position);
        while (position.getLineNo() < nLines) {
            if (this.isCommentTag(aText, position)) {
                position = this.skipHtmlComment(aText, position);
            } else if (!this.isTag(aText, position)) {
                position = this.getNextCharPos(aText, position);
            } else {
                Point endTag = this.findChar(aText, '>', position);
                boolean incompleteTag = endTag.getLineNo() >= nLines;
                String tagId = incompleteTag ? "" : this.getTagId(aText, position);
                boolean closedTag = endTag.getLineNo() < nLines && endTag.getColumnNo() > 0 && aText[endTag.getLineNo()].charAt(endTag.getColumnNo() - 1) == '/';
                this.add(new HtmlTag(tagId, position.getLineNo() + aLineNo, position.getColumnNo(), closedTag, incompleteTag, aText[position.getLineNo()]));
                position = endTag;
            }
            position = this.findChar(aText, '<', position);
        }
    }

    private boolean isTag(String[] aText, Point aPos) {
        String text;
        int column = aPos.getColumnNo() + 1;
        return column < (text = aText[aPos.getLineNo()]).length() && (Character.isJavaIdentifierStart(text.charAt(column)) || Character.isJavaIdentifierPart(text.charAt(column)) || text.charAt(column) == '/') || column >= text.length();
    }

    private String getTagId(String[] aText, Point aTagStart) {
        String text;
        int column = aTagStart.getColumnNo() + 1;
        if (column >= (text = aText[aTagStart.getLineNo()]).length()) {
            return "";
        }
        if (text.charAt(column) == '/') {
            ++column;
        }
        text = text.substring(column).trim();
        for (column = 0; column < text.length() && (Character.isJavaIdentifierStart(text.charAt(column)) || Character.isJavaIdentifierPart(text.charAt(column))); ++column) {
        }
        return text.substring(0, column);
    }

    private boolean isCommentTag(String[] aText, Point aPos) {
        return aText[aPos.getLineNo()].startsWith("<!--", aPos.getColumnNo());
    }

    private Point skipHtmlComment(String[] aText, Point aFrom) {
        Point to = aFrom;
        to = this.findChar(aText, '>', to);
        while (to.getLineNo() < aText.length && !aText[to.getLineNo()].substring(0, to.getColumnNo() + 1).endsWith("-->")) {
            to = this.findChar(aText, '>', this.getNextCharPos(aText, to));
        }
        return to;
    }

    private Point findChar(String[] aText, char aChar, Point aFrom) {
        Point curr = new Point(aFrom.getLineNo(), aFrom.getColumnNo());
        while (curr.getLineNo() < aText.length && aText[curr.getLineNo()].charAt(curr.getColumnNo()) != aChar) {
            curr = this.getNextCharPos(aText, curr);
        }
        return curr;
    }

    private Point getNextCharPos(String[] aText, Point aFrom) {
        int line = aFrom.getLineNo();
        int column = aFrom.getColumnNo() + 1;
        while (line < aText.length && column >= aText[line].length()) {
            column = 0;
            if (++line >= aText.length) continue;
            String currentLine = aText[line];
            while (column < currentLine.length() && (Character.isWhitespace(currentLine.charAt(column)) || currentLine.charAt(column) == '*')) {
                if (++column >= currentLine.length() || currentLine.charAt(column - 1) != '*' || currentLine.charAt(column) != '/') continue;
                column = currentLine.length();
            }
        }
        return new Point(line, column);
    }

    private static final class Point {
        private final int mLine;
        private final int mColumn;

        public Point(int aLineNo, int aColumnNo) {
            this.mLine = aLineNo;
            this.mColumn = aColumnNo;
        }

        public int getLineNo() {
            return this.mLine;
        }

        public int getColumnNo() {
            return this.mColumn;
        }
    }
}

