/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.duplicates;

import java.util.Arrays;

final class ChecksumInfo {
    private static final int[] NO_LINES = new int[0];
    private int[] mSortedChecksums;
    private int[] mOrigIdx;

    ChecksumInfo(int[] aBlockChecksums) {
        int csLen = aBlockChecksums.length;
        int[] relevant = new int[csLen];
        int[] reverse = new int[csLen];
        int count = 0;
        for (int j = 0; j < csLen; ++j) {
            int checksum = aBlockChecksums[j];
            if (checksum == Integer.MIN_VALUE) continue;
            reverse[count] = j;
            relevant[count++] = checksum;
        }
        this.mSortedChecksums = new int[count];
        this.mOrigIdx = new int[count];
        System.arraycopy(relevant, 0, this.mSortedChecksums, 0, count);
        System.arraycopy(reverse, 0, this.mOrigIdx, 0, count);
        this.sort();
    }

    private void sort() {
        int[] arr = this.mSortedChecksums;
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            for (int j = i; j > 0 && arr[j] < arr[j - 1]; --j) {
                int k = j - 1;
                int v = arr[j];
                arr[j] = arr[k];
                arr[k] = v;
                int z = this.mOrigIdx[j];
                this.mOrigIdx[j] = this.mOrigIdx[k];
                this.mOrigIdx[k] = z;
            }
        }
    }

    boolean hasChecksumOverlapsWith(ChecksumInfo aChecksumInfo) {
        int[] jSortedrelevantChecksums = aChecksumInfo.mSortedChecksums;
        int iLen = this.mSortedChecksums.length;
        int jLen = jSortedrelevantChecksums.length;
        int jdx = 0;
        int idx = 0;
        while (jdx < jLen && idx < iLen) {
            long iSum = this.mSortedChecksums[idx];
            long jSum = jSortedrelevantChecksums[jdx];
            if (iSum < jSum) {
                ++idx;
                continue;
            }
            if (iSum > jSum) {
                ++jdx;
                continue;
            }
            return true;
        }
        return false;
    }

    int[] findLinesWithChecksum(int aSum) {
        int end;
        int idx = Arrays.binarySearch(this.mSortedChecksums, aSum);
        if (idx < 0) {
            return NO_LINES;
        }
        while (idx > 0 && this.mSortedChecksums[idx - 1] == aSum) {
            --idx;
        }
        int start = idx;
        for (end = start + 1; end < this.mSortedChecksums.length && this.mSortedChecksums[end] == this.mSortedChecksums[end - 1]; ++end) {
        }
        int[] ret = new int[end - start];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.mOrigIdx[start + i];
        }
        Arrays.sort(ret);
        return ret;
    }
}

