/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;

@StatelessCheck
public class WhitespaceAroundCheck
extends AbstractCheck {
    public static final String MSG_WS_NOT_PRECEDED = "ws.notPreceded";
    public static final String MSG_WS_NOT_FOLLOWED = "ws.notFollowed";
    private boolean allowEmptyConstructors;
    private boolean allowEmptyMethods;
    private boolean allowEmptyTypes;
    private boolean allowEmptyLoops;
    private boolean allowEmptyLambdas;
    private boolean allowEmptyCatches;
    private boolean allowEmptySwitchBlockStatements;
    private boolean ignoreEnhancedForColon = true;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{80, 114, 106, 112, 108, 124, 104, 113, 107, 82, 127, 101, 175, 116, 120, 118, 181, 111, 72, 119, 96, 85, 92, 97, 91, 83, 88, 89, 67, 95, 84, 110, 117, 126, 99, 128, 102, 115, 125, 98, 109, 73, 122, 7, 105, 123, 103, 60, 100, 151, 174, 214};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{80, 29, 114, 106, 112, 108, 124, 104, 113, 107, 82, 127, 101, 175, 116, 120, 118, 181, 111, 72, 119, 96, 85, 92, 97, 91, 83, 88, 89, 67, 95, 84, 110, 117, 126, 99, 128, 102, 115, 125, 98, 109, 73, 122, 7, 105, 123, 103, 60, 100, 151, 174, 167, 172, 173, 171, 214};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    public void setAllowEmptyMethods(boolean allow) {
        this.allowEmptyMethods = allow;
    }

    public void setAllowEmptyConstructors(boolean allow) {
        this.allowEmptyConstructors = allow;
    }

    public void setIgnoreEnhancedForColon(boolean ignore) {
        this.ignoreEnhancedForColon = ignore;
    }

    public void setAllowEmptyTypes(boolean allow) {
        this.allowEmptyTypes = allow;
    }

    public void setAllowEmptyLoops(boolean allow) {
        this.allowEmptyLoops = allow;
    }

    public void setAllowEmptyLambdas(boolean allow) {
        this.allowEmptyLambdas = allow;
    }

    public void setAllowEmptyCatches(boolean allow) {
        this.allowEmptyCatches = allow;
    }

    public void setAllowEmptySwitchBlockStatements(boolean allow) {
        this.allowEmptySwitchBlockStatements = allow;
    }

    @Override
    public void visitToken(DetailAST ast) {
        int currentType = ast.getType();
        if (!this.isNotRelevantSituation(ast, currentType)) {
            char nextChar;
            int[] line = this.getLineCodePoints(ast.getLineNo() - 1);
            int before = ast.getColumnNo() - 1;
            int after = ast.getColumnNo() + ast.getText().length();
            if (before >= 0 && WhitespaceAroundCheck.shouldCheckSeparationFromPreviousToken(ast) && !CommonUtil.isCodePointWhitespace(line, before)) {
                this.log(ast, MSG_WS_NOT_PRECEDED, ast.getText());
            }
            if (after < line.length && this.shouldCheckSeparationFromNextToken(ast, nextChar = Character.toChars(line[after])[0]) && !Character.isWhitespace(nextChar)) {
                this.log(ast, MSG_WS_NOT_FOLLOWED, ast.getText());
            }
        }
    }

    private boolean isNotRelevantSituation(DetailAST ast, int currentType) {
        int parentType = ast.getParent().getType();
        return switch (parentType) {
            case 59 -> {
                if (currentType == 60) {
                    yield true;
                }
                yield false;
            }
            case 33, 93, 94 -> true;
            case 156 -> this.ignoreEnhancedForColon;
            case 28 -> {
                if (currentType == 89) {
                    yield true;
                }
                yield false;
            }
            case 29, 162 -> {
                if (currentType == 73) {
                    yield true;
                }
                yield false;
            }
            default -> this.isEmptyBlock(ast, parentType) || this.allowEmptyTypes && WhitespaceAroundCheck.isEmptyType(ast);
        };
    }

    private static boolean shouldCheckSeparationFromPreviousToken(DetailAST ast) {
        return !WhitespaceAroundCheck.isPartOfDoubleBraceInitializerForPreviousToken(ast);
    }

    private boolean shouldCheckSeparationFromNextToken(DetailAST ast, char nextChar) {
        return !this.isEmptyCtorBlockCheckedFromSlist(ast) && (ast.getType() != 88 || ast.getFirstChild().getType() != 45) && ast.getType() != 29 && !WhitespaceAroundCheck.isAnonymousInnerClassEnd(ast.getType(), nextChar) && !WhitespaceAroundCheck.isPartOfDoubleBraceInitializerForNextToken(ast);
    }

    private static boolean isAnonymousInnerClassEnd(int currentType, char nextChar) {
        return currentType == 73 && (nextChar == ')' || nextChar == ';' || nextChar == ',' || nextChar == '.');
    }

    private boolean isEmptyBlock(DetailAST ast, int parentType) {
        return this.isEmptyMethodBlock(ast, parentType) || this.isEmptyCtorBlockCheckedFromRcurly(ast) || this.isEmptyLoop(ast, parentType) || this.isEmptyLambda(ast, parentType) || this.isEmptyCatch(ast, parentType) || this.isEmptySwitchBlockStatement(ast);
    }

    private static boolean isEmptyBlock(DetailAST ast, int parentType, int match) {
        boolean result;
        int type = ast.getType();
        if (type == 73) {
            DetailAST parent = ast.getParent();
            DetailAST grandParent = ast.getParent().getParent();
            result = parent.getFirstChild().getType() == 73 && grandParent.getType() == match;
        } else {
            result = type == 7 && parentType == match && ast.getFirstChild().getType() == 73;
        }
        return result;
    }

    private boolean isEmptyMethodBlock(DetailAST ast, int parentType) {
        return this.allowEmptyMethods && WhitespaceAroundCheck.isEmptyBlock(ast, parentType, 9);
    }

    private boolean isEmptyCtorBlockCheckedFromRcurly(DetailAST ast) {
        DetailAST parent = ast.getParent();
        DetailAST grandParent = ast.getParent().getParent();
        return this.allowEmptyConstructors && parent.getFirstChild().getType() == 73 && (grandParent.getType() == 8 || grandParent.getType() == 203);
    }

    private boolean isEmptyCtorBlockCheckedFromSlist(DetailAST ast) {
        return this.allowEmptyConstructors && (ast.getParent().getType() == 8 || ast.getParent().getType() == 203) && ast.getFirstChild().getType() == 73;
    }

    private boolean isEmptyLoop(DetailAST ast, int parentType) {
        return this.allowEmptyLoops && (WhitespaceAroundCheck.isEmptyBlock(ast, parentType, 91) || WhitespaceAroundCheck.isEmptyBlock(ast, parentType, 84) || WhitespaceAroundCheck.isEmptyBlock(ast, parentType, 85));
    }

    private boolean isEmptyLambda(DetailAST ast, int parentType) {
        return this.allowEmptyLambdas && WhitespaceAroundCheck.isEmptyBlock(ast, parentType, 181);
    }

    private boolean isEmptyCatch(DetailAST ast, int parentType) {
        return this.allowEmptyCatches && WhitespaceAroundCheck.isEmptyBlock(ast, parentType, 96);
    }

    private boolean isEmptySwitchBlockStatement(DetailAST ast) {
        boolean isEmptySwitchBlockStatement;
        if (this.allowEmptySwitchBlockStatements) {
            DetailAST parent = ast.getParent();
            DetailAST grandParent = parent.getParent();
            boolean isEmptyCaseInSwitchRule = WhitespaceAroundCheck.isEmptyBlock(ast, parent.getType(), 208);
            boolean isEmptyCaseGroupCheckedFromLcurly = WhitespaceAroundCheck.isEmptyBlock(ast, grandParent.getType(), 33);
            boolean isEmptyCaseGroupCheckedFromRcurly = parent.getFirstChild().getType() == 73 && grandParent.getParent().getType() == 33;
            isEmptySwitchBlockStatement = isEmptyCaseInSwitchRule || isEmptyCaseGroupCheckedFromLcurly || isEmptyCaseGroupCheckedFromRcurly;
        } else {
            isEmptySwitchBlockStatement = false;
        }
        return isEmptySwitchBlockStatement;
    }

    private static boolean isEmptyType(DetailAST ast) {
        int type = ast.getType();
        DetailAST nextSibling = ast.getNextSibling();
        DetailAST previousSibling = ast.getPreviousSibling();
        return type == 72 && nextSibling.getType() == 73 || previousSibling != null && previousSibling.getType() == 72;
    }

    private static boolean isPartOfDoubleBraceInitializerForPreviousToken(DetailAST ast) {
        boolean initializerBeginsAfterClassBegins = ast.getParent().getType() == 11;
        boolean classEndsAfterInitializerEnds = ast.getPreviousSibling() != null && ast.getPreviousSibling().getType() == 11;
        return initializerBeginsAfterClassBegins || classEndsAfterInitializerEnds;
    }

    private static boolean isPartOfDoubleBraceInitializerForNextToken(DetailAST ast) {
        boolean classBeginBeforeInitializerBegin = ast.getType() == 72 && ast.getNextSibling().getType() == 11;
        boolean initializerEndsBeforeClassEnds = ast.getParent().getParent().getType() == 11 && ast.getParent().getParent().getNextSibling().getType() == 73;
        return classBeginBeforeInitializerBegin || initializerEndsBeforeClassEnds;
    }
}

