/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.io.File;
import java.util.regex.Pattern;

@StatelessCheck
public class LineLengthCheck
extends AbstractFileSetCheck {
    public static final String MSG_KEY = "maxLineLen";
    private static final int DEFAULT_MAX_COLUMNS = 80;
    private int max = 80;
    private Pattern ignorePattern = Pattern.compile("^(package|import) .*");

    @Override
    protected void processFiltered(File file, FileText fileText) {
        for (int i = 0; i < fileText.size(); ++i) {
            String line = fileText.get(i);
            int realLength = CommonUtil.lengthExpandedTabs(line, line.codePointCount(0, line.length()), this.getTabWidth());
            if (realLength <= this.max || this.ignorePattern.matcher(line).find()) continue;
            this.log(i + 1, MSG_KEY, this.max, realLength);
        }
    }

    public void setMax(int length) {
        this.max = length;
    }

    public final void setIgnorePattern(Pattern pattern) {
        this.ignorePattern = pattern;
    }

    @Override
    public final void setFileExtensions(String ... extensions) {
        super.setFileExtensions(extensions);
    }
}

