/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.BlockParentHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;

public class SwitchHandler
extends BlockParentHandler {
    private static final int[] LINE_WRAPPING_INDENT_TRIGGERS = new int[]{80, 208, 181};

    public SwitchHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "switch", ast, parent);
    }

    @Override
    protected DetailAST getLeftCurly() {
        return this.getMainAst().findFirstToken(72);
    }

    @Override
    protected DetailAST getRightCurly() {
        return this.getMainAst().findFirstToken(73);
    }

    @Override
    protected DetailAST getListChild() {
        return null;
    }

    @Override
    protected DetailAST getNonListChild() {
        return null;
    }

    private void checkSwitchExpr() {
        this.checkExpressionSubtree(this.getMainAst().findFirstToken(76).getNextSibling(), this.getIndent(), false, false);
    }

    @Override
    protected IndentLevel getIndentImpl() {
        DetailAST grandParent;
        DetailAST parent;
        IndentLevel indentLevel = super.getIndentImpl();
        if (this.isOnStartOfLine(this.getMainAst()) && this.shouldIndentDueToWrapping(parent = this.getMainAst().getParent(), grandParent = parent.getParent())) {
            indentLevel = new IndentLevel(indentLevel, this.getIndentCheck().getLineWrappingIndentation());
        }
        return indentLevel;
    }

    private boolean shouldIndentDueToWrapping(DetailAST directParent, DetailAST grandParent) {
        DetailAST enclosingHandlerNode = this.getParent().getMainAst();
        boolean isDirectParentTheHandler = directParent.equals(enclosingHandlerNode);
        boolean shouldIndentForDirectParent = !isDirectParentTheHandler && SwitchHandler.isWrappingTrigger(directParent);
        boolean shouldIndentForGrandParent = !isDirectParentTheHandler && !grandParent.equals(enclosingHandlerNode) && SwitchHandler.isWrappingTrigger(grandParent);
        return shouldIndentForDirectParent || shouldIndentForGrandParent;
    }

    private static boolean isWrappingTrigger(DetailAST astNode) {
        return TokenUtil.isOfType(astNode, LINE_WRAPPING_INDENT_TRIGGERS);
    }

    @Override
    public void checkIndentation() {
        this.checkSwitchExpr();
        super.checkIndentation();
    }
}

