/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AbstractAutomaticBean;
import com.puppycrawl.tools.checkstyle.AuditEventDefaultFormatter;
import com.puppycrawl.tools.checkstyle.AuditEventFormatter;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;

public class MetadataGeneratorLogger
extends AbstractAutomaticBean
implements AuditListener {
    private final PrintWriter errorWriter;
    private final AuditEventFormatter formatter;
    private final boolean closeErrorWriter;

    public MetadataGeneratorLogger(OutputStream outputStream, AbstractAutomaticBean.OutputStreamOptions outputStreamOptions) {
        OutputStreamWriter errorStreamWriter = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        this.errorWriter = new PrintWriter(errorStreamWriter);
        this.formatter = new AuditEventDefaultFormatter();
        this.closeErrorWriter = outputStreamOptions == AbstractAutomaticBean.OutputStreamOptions.CLOSE;
    }

    @Override
    public void auditStarted(AuditEvent event) {
        this.errorWriter.flush();
    }

    @Override
    public void auditFinished(AuditEvent event) {
        this.errorWriter.flush();
        if (this.closeErrorWriter) {
            this.errorWriter.close();
        }
    }

    @Override
    public void fileStarted(AuditEvent event) {
    }

    @Override
    public void fileFinished(AuditEvent event) {
        this.errorWriter.flush();
    }

    @Override
    public void addError(AuditEvent event) {
        SeverityLevel severityLevel = event.getSeverityLevel();
        if (severityLevel != SeverityLevel.IGNORE) {
            String errorMessage = this.formatter.format(event);
            this.errorWriter.println(errorMessage);
        }
    }

    @Override
    public void addException(AuditEvent event, Throwable throwable) {
        throwable.printStackTrace(this.errorWriter);
    }

    @Override
    protected void finishLocalSetup() {
    }
}

