/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.modifier;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@StatelessCheck
public class RedundantModifierCheck
extends AbstractCheck {
    public static final String MSG_KEY = "redundantModifier";
    private static final int[] TOKENS_FOR_INTERFACE_MODIFIERS = new int[]{64, 40};
    private static final int JDK_22 = 22;
    private static final int JDK_17 = 17;
    private int jdkVersion = 22;

    public void setJdkVersion(String jdkVersion) {
        String singleVersionNumber = jdkVersion.startsWith("1.") ? jdkVersion.substring(2) : jdkVersion;
        this.jdkVersion = Integer.parseInt(singleVersionNumber);
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9, 10, 161, 15, 8, 14, 154, 178, 157, 199, 198, 96, 181};
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 15: 
            case 157: {
                this.checkInterfaceModifiers(ast);
                break;
            }
            case 154: {
                this.checkForRedundantModifier(ast, 64);
                break;
            }
            case 8: {
                this.checkConstructorModifiers(ast);
                break;
            }
            case 9: {
                this.processMethods(ast);
                break;
            }
            case 178: {
                this.processResources(ast);
                break;
            }
            case 199: {
                this.checkForRedundantModifier(ast, 39, 64);
                break;
            }
            case 10: 
            case 198: {
                this.checkUnnamedVariables(ast);
                break;
            }
            case 96: {
                this.checkUnnamedVariables(ast.findFirstToken(21));
                break;
            }
            case 181: {
                this.processLambdaParameters(ast);
                break;
            }
            case 14: 
            case 161: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected token type: " + ast.getType());
            }
        }
        if (RedundantModifierCheck.isInterfaceOrAnnotationMember(ast)) {
            this.processInterfaceOrAnnotation(ast);
        }
        if (this.jdkVersion >= 17) {
            this.checkForRedundantModifier(ast, 41);
        }
    }

    private void processLambdaParameters(DetailAST lambdaAst) {
        DetailAST lambdaParameters = lambdaAst.findFirstToken(20);
        if (lambdaParameters != null) {
            TokenUtil.forEachChild(lambdaParameters, 21, this::checkUnnamedVariables);
        }
    }

    private void checkUnnamedVariables(DetailAST ast) {
        if (this.jdkVersion >= 22 && RedundantModifierCheck.isUnnamedVariable(ast)) {
            this.checkForRedundantModifier(ast, 39);
        }
    }

    private static boolean isUnnamedVariable(DetailAST ast) {
        return "_".equals(ast.findFirstToken(58).getText());
    }

    private void checkConstructorModifiers(DetailAST ctorDefAst) {
        if (RedundantModifierCheck.isEnumMember(ctorDefAst)) {
            this.checkEnumConstructorModifiers(ctorDefAst);
        } else {
            this.checkClassConstructorModifiers(ctorDefAst);
        }
    }

    private void checkInterfaceModifiers(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        for (int tokenType : TOKENS_FOR_INTERFACE_MODIFIERS) {
            DetailAST modifier = modifiers.findFirstToken(tokenType);
            if (modifier == null) continue;
            this.log(modifier, MSG_KEY, modifier.getText());
        }
    }

    private void checkEnumConstructorModifiers(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        TokenUtil.findFirstTokenByPredicate(modifiers, mod -> mod.getType() != 159).ifPresent(modifier -> this.log((DetailAST)modifier, MSG_KEY, (Object)modifier.getText()));
    }

    private void processInterfaceOrAnnotation(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        for (DetailAST modifier = modifiers.getFirstChild(); modifier != null; modifier = modifier.getNextSibling()) {
            int type = modifier.getType();
            if (!(type == 62 || type == 64 && ast.getType() != 9 || type == 40 && ast.getType() != 14) && (type != 39 || ast.getType() == 14)) continue;
            this.log(modifier, MSG_KEY, modifier.getText());
        }
    }

    private void processMethods(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        boolean checkFinal = modifiers.findFirstToken(61) != null;
        DetailAST parent = ast;
        while (parent != null && !checkFinal) {
            if (parent.getType() == 14) {
                DetailAST classModifiers = parent.findFirstToken(5);
                checkFinal = classModifiers.findFirstToken(39) != null;
                parent = null;
                continue;
            }
            if (parent.getType() == 136 || parent.getType() == 155) {
                checkFinal = true;
                parent = null;
                continue;
            }
            if (parent.getType() == 154) {
                checkFinal = modifiers.findFirstToken(64) != null;
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        if (checkFinal && !RedundantModifierCheck.isAnnotatedWithSafeVarargs(ast)) {
            this.checkForRedundantModifier(ast, 39);
        }
        if (ast.findFirstToken(7) == null) {
            this.processAbstractMethodParameters(ast);
        }
    }

    private void processAbstractMethodParameters(DetailAST ast) {
        DetailAST parameters = ast.findFirstToken(20);
        TokenUtil.forEachChild(parameters, 21, paramDef -> this.checkForRedundantModifier((DetailAST)paramDef, 39));
    }

    private void checkClassConstructorModifiers(DetailAST classCtorAst) {
        DetailAST classDef = classCtorAst.getParent().getParent();
        if (!RedundantModifierCheck.isClassPublic(classDef) && !RedundantModifierCheck.isClassProtected(classDef)) {
            this.checkForRedundantModifier(classCtorAst, 62);
        }
    }

    private void processResources(DetailAST ast) {
        this.checkForRedundantModifier(ast, 39);
    }

    private void checkForRedundantModifier(DetailAST ast, int ... modifierTypes) {
        Optional.ofNullable(ast.findFirstToken(5)).ifPresent(modifiers -> {
            for (DetailAST childAst = modifiers.getFirstChild(); childAst != null; childAst = childAst.getNextSibling()) {
                if (!TokenUtil.isOfType(childAst, modifierTypes)) continue;
                this.log(childAst, MSG_KEY, childAst.getText());
            }
        });
    }

    private static boolean isClassProtected(DetailAST classDef) {
        DetailAST classModifiers = classDef.findFirstToken(5);
        return classModifiers.findFirstToken(63) != null;
    }

    private static boolean isClassPublic(DetailAST ast) {
        boolean hasPublicModifier;
        boolean isAccessibleFromPublic = false;
        DetailAST modifiersAst = ast.findFirstToken(5);
        boolean bl = hasPublicModifier = modifiersAst.findFirstToken(62) != null;
        if (TokenUtil.isRootNode(ast.getParent())) {
            isAccessibleFromPublic = hasPublicModifier;
        } else {
            DetailAST parentClassAst = ast.getParent().getParent();
            if (hasPublicModifier || parentClassAst.getType() == 15) {
                isAccessibleFromPublic = RedundantModifierCheck.isClassPublic(parentClassAst);
            }
        }
        return isAccessibleFromPublic;
    }

    private static boolean isEnumMember(DetailAST ast) {
        DetailAST parentTypeDef = ast.getParent().getParent();
        return parentTypeDef.getType() == 154;
    }

    private static boolean isInterfaceOrAnnotationMember(DetailAST ast) {
        DetailAST parentTypeDef = ast.getParent();
        return (parentTypeDef = parentTypeDef.getParent()) != null && (parentTypeDef.getType() == 15 || parentTypeDef.getType() == 157);
    }

    private static boolean isAnnotatedWithSafeVarargs(DetailAST methodDef) {
        boolean result = false;
        List<DetailAST> methodAnnotationsList = RedundantModifierCheck.getMethodAnnotationsList(methodDef);
        for (DetailAST annotationNode : methodAnnotationsList) {
            if (!"SafeVarargs".equals(annotationNode.getLastChild().getText())) continue;
            result = true;
            break;
        }
        return result;
    }

    private static List<DetailAST> getMethodAnnotationsList(DetailAST methodDef) {
        ArrayList<DetailAST> annotationsList = new ArrayList<DetailAST>();
        DetailAST modifiers = methodDef.findFirstToken(5);
        TokenUtil.forEachChild(modifiers, 159, annotationsList::add);
        return annotationsList;
    }
}

