/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.javadoc.HtmlTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.checks.javadoc.TagParser;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@StatelessCheck
public class JavadocStyleCheck
extends AbstractCheck {
    public static final String MSG_EMPTY = "javadoc.empty";
    public static final String MSG_NO_PERIOD = "javadoc.noPeriod";
    public static final String MSG_INCOMPLETE_TAG = "javadoc.incompleteTag";
    public static final String MSG_UNCLOSED_HTML = "javadoc.unclosedHtml";
    public static final String MSG_EXTRA_HTML = "javadoc.extraHtml";
    private static final Set<String> SINGLE_TAGS = Set.of("br", "li", "dt", "dd", "hr", "img", "p", "td", "tr", "th");
    private static final Set<String> ALLOWED_TAGS = Set.of("a", "abbr", "acronym", "address", "area", "b", "bdo", "big", "blockquote", "br", "caption", "cite", "code", "colgroup", "dd", "del", "dfn", "div", "dl", "dt", "em", "fieldset", "font", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "img", "ins", "kbd", "li", "ol", "p", "pre", "q", "samp", "small", "span", "strong", "sub", "sup", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "tt", "u", "ul", "var");
    private static final Pattern INLINE_RETURN_TAG_PATTERN = Pattern.compile("\\{@return.*?}\\s*");
    private static final Pattern SENTENCE_SEPARATOR = Pattern.compile("\\.(?=\\s|$)");
    private Scope scope = Scope.PRIVATE;
    private Scope excludeScope;
    private Pattern endOfSentenceFormat = Pattern.compile("([.?!][ \t\n\r\f<])|([.?!]$)");
    private boolean checkFirstSentence = true;
    private boolean checkHtml = true;
    private boolean checkEmptyJavadoc;

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{157, 161, 14, 8, 155, 154, 15, 9, 16, 10, 199, 203};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (this.shouldCheck(ast)) {
            FileContents contents = this.getFileContents();
            TextBlock textBlock = contents.getJavadocBefore(ast.getFirstChild().getLineNo());
            this.checkComment(ast, textBlock);
        }
    }

    private boolean shouldCheck(DetailAST ast) {
        boolean check = false;
        if (ast.getType() == 16) {
            check = CheckUtil.isPackageInfo(this.getFilePath());
        } else if (!ScopeUtil.isInCodeBlock(ast)) {
            Scope customScope = ScopeUtil.getScope(ast);
            Scope surroundingScope = ScopeUtil.getSurroundingScope(ast);
            check = customScope.isIn(this.scope) && surroundingScope.isIn(this.scope) && (this.excludeScope == null || !customScope.isIn(this.excludeScope) || !surroundingScope.isIn(this.excludeScope));
        }
        return check;
    }

    private void checkComment(DetailAST ast, TextBlock comment) {
        if (comment != null) {
            if (this.checkFirstSentence) {
                this.checkFirstSentenceEnding(ast, comment);
            }
            if (this.checkHtml) {
                this.checkHtmlTags(ast, comment);
            }
            if (this.checkEmptyJavadoc) {
                this.checkJavadocIsNotEmpty(comment);
            }
        }
    }

    private void checkFirstSentenceEnding(DetailAST ast, TextBlock comment) {
        String commentText = JavadocStyleCheck.getCommentText(comment.getText());
        boolean hasInLineReturnTag = Arrays.stream(SENTENCE_SEPARATOR.split(commentText)).findFirst().map(INLINE_RETURN_TAG_PATTERN::matcher).filter(Matcher::find).isPresent();
        if (!(hasInLineReturnTag || commentText.isEmpty() || this.endOfSentenceFormat.matcher(commentText).find() || commentText.startsWith("{@inheritDoc}") && JavadocTagInfo.INHERIT_DOC.isValidOn(ast))) {
            this.log(comment.getStartLineNo(), MSG_NO_PERIOD, new Object[0]);
        }
    }

    private void checkJavadocIsNotEmpty(TextBlock comment) {
        String commentText = JavadocStyleCheck.getCommentText(comment.getText());
        if (commentText.isEmpty()) {
            this.log(comment.getStartLineNo(), MSG_EMPTY, new Object[0]);
        }
    }

    private static String getCommentText(String ... comments) {
        StringBuilder builder = new StringBuilder(1024);
        for (String line : comments) {
            int textStart = JavadocStyleCheck.findTextStart(line);
            if (textStart == -1) continue;
            if (line.charAt(textStart) == '@') break;
            builder.append(line.substring(textStart));
            JavadocStyleCheck.trimTail(builder);
            builder.append('\n');
        }
        return builder.toString().trim();
    }

    private static int findTextStart(String line) {
        int textStart = -1;
        for (int index = 0; index < line.length(); ++index) {
            if (Character.isWhitespace(line.charAt(index))) continue;
            if (line.regionMatches(index, "/**", 0, "/**".length()) || line.regionMatches(index, "*/", 0, 2)) {
                ++index;
                continue;
            }
            if (line.charAt(index) == '*') continue;
            textStart = index;
            break;
        }
        return textStart;
    }

    private static void trimTail(StringBuilder builder) {
        int index = builder.length() - 1;
        while (true) {
            if (Character.isWhitespace(builder.charAt(index))) {
                builder.deleteCharAt(index);
            } else {
                if (index <= 0 || builder.charAt(index) != '/' || builder.charAt(index - 1) != '*') break;
                builder.deleteCharAt(index);
                builder.deleteCharAt(index - 1);
                --index;
                while (builder.charAt(index - 1) == '*') {
                    builder.deleteCharAt(index - 1);
                    --index;
                }
            }
            --index;
        }
    }

    private void checkHtmlTags(DetailAST ast, TextBlock comment) {
        int lineNo = comment.getStartLineNo();
        ArrayDeque<HtmlTag> htmlStack = new ArrayDeque<HtmlTag>();
        String[] text = comment.getText();
        TagParser parser = new TagParser(text, lineNo);
        while (parser.hasNextTag()) {
            HtmlTag tag = parser.nextTag();
            if (tag.isIncompleteTag()) {
                this.log(tag.getLineNo(), MSG_INCOMPLETE_TAG, text[tag.getLineNo() - lineNo]);
                return;
            }
            if (tag.isClosedTag()) continue;
            if (tag.isCloseTag()) {
                if (JavadocStyleCheck.isExtraHtml(tag.getId(), htmlStack)) {
                    this.log(tag.getLineNo(), tag.getPosition(), MSG_EXTRA_HTML, tag.getText());
                    continue;
                }
                this.checkUnclosedTags(htmlStack, tag.getId());
                continue;
            }
            if (!JavadocStyleCheck.isAllowedTag(tag)) continue;
            htmlStack.push(tag);
        }
        String lastFound = "";
        List<String> typeParameters = CheckUtil.getTypeParameterNames(ast);
        for (HtmlTag htmlTag : htmlStack) {
            if (JavadocStyleCheck.isSingleTag(htmlTag) || htmlTag.getId().equals(lastFound) || typeParameters.contains(htmlTag.getId())) continue;
            this.log(htmlTag.getLineNo(), htmlTag.getPosition(), MSG_UNCLOSED_HTML, htmlTag.getText());
            lastFound = htmlTag.getId();
        }
    }

    private void checkUnclosedTags(Deque<HtmlTag> htmlStack, String token) {
        ArrayDeque<HtmlTag> unclosedTags = new ArrayDeque<HtmlTag>();
        HtmlTag lastOpenTag = htmlStack.pop();
        while (!token.equalsIgnoreCase(lastOpenTag.getId())) {
            if (JavadocStyleCheck.isSingleTag(lastOpenTag)) {
                lastOpenTag = htmlStack.pop();
                continue;
            }
            unclosedTags.push(lastOpenTag);
            lastOpenTag = htmlStack.pop();
        }
        String lastFound = "";
        for (HtmlTag htag : unclosedTags) {
            lastOpenTag = htag;
            if (lastOpenTag.getId().equals(lastFound)) continue;
            lastFound = lastOpenTag.getId();
            this.log(lastOpenTag.getLineNo(), lastOpenTag.getPosition(), MSG_UNCLOSED_HTML, lastOpenTag.getText());
        }
    }

    private static boolean isSingleTag(HtmlTag tag) {
        return SINGLE_TAGS.contains(tag.getId().toLowerCase(Locale.ENGLISH));
    }

    private static boolean isAllowedTag(HtmlTag tag) {
        return ALLOWED_TAGS.contains(tag.getId().toLowerCase(Locale.ENGLISH));
    }

    private static boolean isExtraHtml(String token, Deque<HtmlTag> htmlStack) {
        boolean isExtra = true;
        for (HtmlTag tag : htmlStack) {
            if (!token.equalsIgnoreCase(tag.getId())) continue;
            isExtra = false;
            break;
        }
        return isExtra;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setExcludeScope(Scope excludeScope) {
        this.excludeScope = excludeScope;
    }

    public void setEndOfSentenceFormat(Pattern pattern) {
        this.endOfSentenceFormat = pattern;
    }

    public void setCheckFirstSentence(boolean flag) {
        this.checkFirstSentence = flag;
    }

    public void setCheckHtml(boolean flag) {
        this.checkHtml = flag;
    }

    public void setCheckEmptyJavadoc(boolean flag) {
        this.checkEmptyJavadoc = flag;
    }
}

