/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.PropertyType;
import com.puppycrawl.tools.checkstyle.XdocsPropertyType;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

@FileStatefulCheck
public class MultipleStringLiteralsCheck
extends AbstractCheck {
    public static final String MSG_KEY = "multiple.string.literal";
    private static final Pattern ALL_NEW_LINES = Pattern.compile("\\R");
    private static final String QUOTE = "\"";
    private final Map<String, List<DetailAST>> stringMap = new HashMap<String, List<DetailAST>>();
    @XdocsPropertyType(value=PropertyType.TOKEN_ARRAY)
    private final BitSet ignoreOccurrenceContext = new BitSet();
    private int allowedDuplicates = 1;
    private Pattern ignoreStringsRegexp;

    public MultipleStringLiteralsCheck() {
        this.setIgnoreStringsRegexp(Pattern.compile("^\"\"$"));
        this.ignoreOccurrenceContext.set(159);
    }

    public void setAllowedDuplicates(int allowedDuplicates) {
        this.allowedDuplicates = allowedDuplicates;
    }

    public final void setIgnoreStringsRegexp(Pattern ignoreStringsRegexp) {
        this.ignoreStringsRegexp = ignoreStringsRegexp == null || ignoreStringsRegexp.pattern().isEmpty() ? null : ignoreStringsRegexp;
    }

    public final void setIgnoreOccurrenceContext(String ... strRep) {
        this.ignoreOccurrenceContext.clear();
        for (String s : strRep) {
            int type = TokenUtil.getTokenId(s);
            this.ignoreOccurrenceContext.set(type);
        }
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{139, 205};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (!this.isInIgnoreOccurrenceContext(ast)) {
            Object currentString;
            if (ast.getType() == 205) {
                String strippedString = CheckUtil.stripIndentAndInitialNewLineFromTextBlock(ast.getText());
                currentString = QUOTE + strippedString + QUOTE;
            } else {
                currentString = ast.getText();
            }
            if (this.ignoreStringsRegexp == null || !this.ignoreStringsRegexp.matcher((CharSequence)currentString).find()) {
                this.stringMap.computeIfAbsent((String)currentString, key -> new ArrayList()).add(ast);
            }
        }
    }

    private boolean isInIgnoreOccurrenceContext(DetailAST ast) {
        boolean isInIgnoreOccurrenceContext = false;
        for (DetailAST token = ast; token != null; token = token.getParent()) {
            int type = token.getType();
            if (!this.ignoreOccurrenceContext.get(type)) continue;
            isInIgnoreOccurrenceContext = true;
            break;
        }
        return isInIgnoreOccurrenceContext;
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.stringMap.clear();
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        for (Map.Entry<String, List<DetailAST>> stringListEntry : this.stringMap.entrySet()) {
            List<DetailAST> hits = stringListEntry.getValue();
            if (hits.size() <= this.allowedDuplicates) continue;
            DetailAST firstFinding = hits.get(0);
            String recurringString = ALL_NEW_LINES.matcher(stringListEntry.getKey()).replaceAll("\\\\n");
            this.log(firstFinding, MSG_KEY, recurringString, hits.size());
        }
    }
}

