/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.DetailNode;
import org.antlr.v4.runtime.Token;

public class JavadocNodeImpl
implements DetailNode {
    private int type;
    private String text;
    private int lineNumber;
    private int columnNumber;
    private JavadocNodeImpl parent;
    private JavadocNodeImpl nextSibling;
    private JavadocNodeImpl previousSibling;
    private JavadocNodeImpl firstChild;

    public void initialize(Token token) {
        this.type = token.getType();
        this.text = token.getText();
        this.lineNumber = token.getLine() - 1;
        this.columnNumber = token.getCharPositionInLine();
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public int getLineNumber() {
        JavadocNodeImpl node = this.firstChild;
        if (node != null) {
            this.lineNumber = node.getLineNumber();
        }
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        JavadocNodeImpl node = this.firstChild;
        if (node != null) {
            this.columnNumber = node.getColumnNumber();
        }
        return this.columnNumber;
    }

    @Override
    public DetailNode getParent() {
        return this.parent;
    }

    @Override
    public DetailNode getNextSibling() {
        return this.nextSibling;
    }

    @Override
    public DetailNode getPreviousSibling() {
        return this.previousSibling;
    }

    @Override
    public JavadocNodeImpl getFirstChild() {
        return this.firstChild;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public void setParent(DetailNode node) {
        JavadocNodeImpl instance = this;
        JavadocNodeImpl newParent = (JavadocNodeImpl)node;
        do {
            instance.parent = newParent;
        } while ((instance = instance.nextSibling) != null);
    }

    public void setNextSibling(DetailNode nextSibling) {
        this.nextSibling = (JavadocNodeImpl)nextSibling;
        ((JavadocNodeImpl)nextSibling).setParent(this.parent);
        ((JavadocNodeImpl)nextSibling).previousSibling = this;
    }

    public void addChild(DetailNode newChild) {
        JavadocNodeImpl astImpl = (JavadocNodeImpl)newChild;
        astImpl.setParent(this);
        DetailNode temp = this.firstChild;
        if (temp == null) {
            this.firstChild = (JavadocNodeImpl)newChild;
        } else {
            while (temp.getNextSibling() != null) {
                temp = temp.getNextSibling();
            }
            temp.setNextSibling(newChild);
        }
    }

    public String toString() {
        return this.text + "[" + this.getLineNumber() + "x" + this.getColumnNumber() + "]";
    }
}

