/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;

@StatelessCheck
public class JavadocMissingLeadingAsteriskCheck
extends AbstractJavadocCheck {
    public static final String MSG_MISSING_ASTERISK = "javadoc.missing.asterisk";

    @Override
    public int[] getRequiredJavadocTokens() {
        return new int[]{3};
    }

    @Override
    public int[] getAcceptableJavadocTokens() {
        return this.getRequiredJavadocTokens();
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return this.getRequiredJavadocTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode detailNode) {
        DetailNode nextSibling;
        if (!(JavadocMissingLeadingAsteriskCheck.isInsideHtmlComment(detailNode) || (nextSibling = detailNode.getNextSibling()) == null || JavadocMissingLeadingAsteriskCheck.isLeadingAsterisk(nextSibling) || JavadocMissingLeadingAsteriskCheck.isLastLine(nextSibling))) {
            this.log(nextSibling.getLineNumber(), MSG_MISSING_ASTERISK, new Object[0]);
        }
    }

    private static boolean isInsideHtmlComment(DetailNode detailNode) {
        int parentType = detailNode.getParent().getType();
        return parentType == 107 || parentType == 106;
    }

    private static boolean isLeadingAsterisk(DetailNode detailNode) {
        return detailNode.getType() == 2;
    }

    private static boolean isLastLine(DetailNode detailNode) {
        DetailNode node = CommonUtil.isBlank(detailNode.getText()) ? detailNode.getNextSibling() : detailNode;
        return node == null;
    }
}

