/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc.utils;

import com.puppycrawl.tools.checkstyle.api.LineColumn;
import com.puppycrawl.tools.checkstyle.checks.javadoc.utils.TagInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class BlockTagUtil {
    private static final Pattern BLOCK_TAG_PATTERN_FIRST_LINE = Pattern.compile("/\\*{2,}\\s*@(\\p{Alpha}+)(\\s|$)");
    private static final Pattern BLOCK_TAG_PATTERN = Pattern.compile("^\\s*\\**\\s*@(\\p{Alpha}+)(\\s|$)");
    private static final String JAVADOC_CLOSING_TAG = "*/";

    private BlockTagUtil() {
    }

    public static List<TagInfo> extractBlockTags(String ... lines) {
        ArrayList<TagInfo> tags = new ArrayList<TagInfo>();
        for (int i = 0; i < lines.length; ++i) {
            String line;
            boolean isFirstLine = i == 0;
            Pattern pattern = isFirstLine ? BLOCK_TAG_PATTERN_FIRST_LINE : BLOCK_TAG_PATTERN;
            Matcher tagMatcher = pattern.matcher(line = lines[i]);
            if (!tagMatcher.find()) continue;
            String tagName = tagMatcher.group(1);
            int colNum = tagMatcher.start(1) - 1;
            int lineNum = i + 1;
            String remainder = line.substring(tagMatcher.end(1));
            String tagValue = remainder.trim();
            if (tagValue.endsWith(JAVADOC_CLOSING_TAG)) {
                int endIndex = tagValue.length() - JAVADOC_CLOSING_TAG.length();
                tagValue = tagValue.substring(0, endIndex).trim();
            }
            LineColumn position = new LineColumn(lineNum, colNum);
            tags.add(new TagInfo(tagName, tagValue, position));
        }
        return tags;
    }
}

