/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.configuration.testing;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import com.proofpoint.configuration.ConfigurationFactory;
import com.proofpoint.configuration.ConfigurationMetadata;
import com.proofpoint.configuration.MapClasses;
import com.proofpoint.configuration.testing.ConfigAssertions$$;
import com.proofpoint.testing.Assertions;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.testng.Assert;

public final class ConfigAssertions {
    private static final Method GET_RECORDING_CONFIG_METHOD;

    private ConfigAssertions() {
    }

    public static <T> void assertFullMapping(Map<String, String> properties, T expected) {
        Assert.assertNotNull(properties, (String)"properties");
        Assert.assertNotNull(expected, (String)"expected");
        Class<?> configClass = expected.getClass();
        ConfigurationMetadata<?> metadata = ConfigurationMetadata.getValidConfigurationMetadata(configClass);
        ConfigAssertions.assertPropertiesSupported(metadata, properties.keySet(), false);
        TreeSet<String> untestedProperties = new TreeSet<String>();
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            String property = attribute.getInjectionPoint().getProperty();
            if (property == null || ConfigAssertions.isPropertyTested(property, attribute, properties.keySet())) continue;
            untestedProperties.add(property);
        }
        if (!untestedProperties.isEmpty()) {
            Assert.fail((String)("Untested properties: " + untestedProperties));
        }
        Object actual = ConfigAssertions.newInstance(configClass, properties);
        Object defaultInstance = ConfigAssertions.newDefaultInstance(configClass);
        ConfigAssertions.assertAttributesNotEqual(metadata, actual, defaultInstance);
        ConfigAssertions.assertAttributesEqual(metadata, actual, expected);
    }

    private static boolean isPropertyTested(String property, ConfigurationMetadata.AttributeMetadata attribute, Set<String> testedProperties) {
        MapClasses configMap = attribute.getMapClasses();
        if (configMap == null) {
            return testedProperties.contains(property);
        }
        if (ConfigurationMetadata.isConfigClass(configMap.getValue())) {
            for (String testedProperty : testedProperties) {
                if (!testedProperty.startsWith(property) || testedProperty.charAt(property.length()) != '.' || !testedProperty.substring(property.length() + 1).contains(".")) continue;
                return true;
            }
        } else {
            for (String testedProperty : testedProperties) {
                if (!testedProperty.startsWith(property) || testedProperty.charAt(property.length()) != '.' || testedProperty.substring(property.length() + 1).contains(".")) continue;
                return true;
            }
        }
        return false;
    }

    @SafeVarargs
    public static <T> void assertLegacyEquivalence(Class<T> configClass, Map<String, String> currentProperties, Map<String, String> ... oldPropertiesList) {
        Assert.assertNotNull(configClass, (String)"configClass");
        Assert.assertNotNull(currentProperties, (String)"currentProperties");
        Assert.assertNotNull(oldPropertiesList, (String)"oldPropertiesList");
        ConfigurationMetadata<T> metadata = ConfigurationMetadata.getValidConfigurationMetadata(configClass);
        ConfigAssertions.assertPropertiesSupported(metadata, currentProperties.keySet(), false);
        for (Map<String, String> evenOlderProperties : oldPropertiesList) {
            ConfigAssertions.assertPropertiesSupported(metadata, evenOlderProperties.keySet(), true);
        }
        TreeSet<String> suppliedDeprecatedProperties = new TreeSet<String>();
        for (Map<String, String> evenOlderProperties : oldPropertiesList) {
            suppliedDeprecatedProperties.addAll(evenOlderProperties.keySet());
        }
        TreeSet<String> untestedDeprecatedProperties = new TreeSet<String>();
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            for (ConfigurationMetadata.InjectionPointMetaData deprecated : attribute.getLegacyInjectionPoints()) {
                if (ConfigAssertions.isPropertyTested(deprecated.getProperty(), attribute, suppliedDeprecatedProperties)) continue;
                untestedDeprecatedProperties.add(deprecated.getProperty());
            }
        }
        if (!untestedDeprecatedProperties.isEmpty()) {
            Assert.fail((String)("Untested deprecated properties: " + untestedDeprecatedProperties));
        }
        T currentConfiguration = ConfigAssertions.newInstance(configClass, currentProperties);
        for (Map<String, String> evenOlderProperties : oldPropertiesList) {
            T evenOlderConfiguration = ConfigAssertions.newInstance(configClass, evenOlderProperties);
            ConfigAssertions.assertAttributesEqual(metadata, currentConfiguration, evenOlderConfiguration);
        }
    }

    private static void assertPropertiesSupported(ConfigurationMetadata<?> metadata, Set<String> propertyNames, boolean allowDeprecatedProperties) {
        TreeSet<String> unsupportedProperties = new TreeSet<String>(propertyNames);
        TreeSet<String> deprecatedProperties = new TreeSet<String>(propertyNames);
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            String property = attribute.getInjectionPoint().getProperty();
            MapClasses mapClasses = attribute.getMapClasses();
            if (property != null) {
                ConfigAssertions.markPropertySupported(property, mapClasses, unsupportedProperties, deprecatedProperties);
            }
            for (ConfigurationMetadata.InjectionPointMetaData deprecated : attribute.getLegacyInjectionPoints()) {
                ConfigAssertions.markPropertySupported(deprecated.getProperty(), mapClasses, unsupportedProperties, null);
            }
        }
        if (!unsupportedProperties.isEmpty()) {
            Assert.fail((String)("Properties are not consumed by any configuration attribute: " + unsupportedProperties));
        }
        if (!allowDeprecatedProperties && !deprecatedProperties.isEmpty()) {
            Assert.fail((String)("Deprecated properties in current properties map: " + deprecatedProperties));
        }
    }

    private static void markPropertySupported(String property, MapClasses mapClasses, Set<String> unsupportedProperties, Set<String> deprecatedProperties) {
        if (mapClasses == null) {
            if (deprecatedProperties != null) {
                deprecatedProperties.remove(property);
            }
            unsupportedProperties.remove(property);
        } else if (ConfigurationMetadata.isConfigClass(mapClasses.getValue())) {
            Iterator<String> iterator = unsupportedProperties.iterator();
            while (iterator.hasNext()) {
                String unsupportedProperty = iterator.next();
                if (!unsupportedProperty.startsWith(property) || unsupportedProperty.charAt(property.length()) != '.' || !unsupportedProperty.substring(property.length() + 1).contains(".")) continue;
                if (deprecatedProperties != null) {
                    deprecatedProperties.remove(unsupportedProperty);
                }
                iterator.remove();
            }
        } else {
            Iterator<String> iterator = unsupportedProperties.iterator();
            while (iterator.hasNext()) {
                String unsupportedProperty = iterator.next();
                if (!unsupportedProperty.startsWith(property) || unsupportedProperty.charAt(property.length()) != '.' || unsupportedProperty.substring(property.length() + 1).contains(".")) continue;
                if (deprecatedProperties != null) {
                    deprecatedProperties.remove(unsupportedProperty);
                }
                iterator.remove();
            }
        }
    }

    private static <T> void assertAttributesEqual(ConfigurationMetadata<T> metadata, T actual, T expected) {
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            Method getter = attribute.getGetter();
            if (getter == null) continue;
            Object actualAttributeValue = ConfigAssertions.invoke(actual, getter);
            Object expectedAttributeValue = ConfigAssertions.invoke(expected, getter);
            Assert.assertEquals((Object)actualAttributeValue, (Object)expectedAttributeValue, (String)("Value parsed from property for attribute " + attribute.getName()));
        }
    }

    private static <T> void assertAttributesNotEqual(ConfigurationMetadata<T> metadata, T actual, T expected) {
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            Method getter = attribute.getGetter();
            if (getter == null) continue;
            Object actualAttributeValue = ConfigAssertions.invoke(actual, getter);
            Object expectedAttributeValue = ConfigAssertions.invoke(expected, getter);
            Assertions.assertNotEquals((Object)actualAttributeValue, (Object)expectedAttributeValue, (String)("Attribute " + attribute.getName() + " must be tested with non-default value:"));
        }
    }

    public static <T> void assertRecordedDefaults(T recordedConfig) {
        $$RecordedConfigData<T> recordedConfigData = ConfigAssertions.getRecordedConfig(recordedConfig);
        Set<Method> invokedMethods = recordedConfigData.getInvokedMethods();
        T config = recordedConfigData.getInstance();
        Class<?> configClass = config.getClass();
        ConfigurationMetadata<?> metadata = ConfigurationMetadata.getValidConfigurationMetadata(configClass);
        TreeMap<String, Object> attributeValues = new TreeMap<String, Object>();
        TreeSet<String> setDeprecatedAttributes = new TreeSet<String>();
        HashSet<Method> validSetterMethods = new HashSet<Method>();
        for (ConfigurationMetadata.AttributeMetadata attributeMetadata : metadata.getAttributes().values()) {
            if (attributeMetadata.getInjectionPoint().getProperty() != null) {
                validSetterMethods.add(attributeMetadata.getInjectionPoint().getSetter());
            }
            if (!invokedMethods.contains(attributeMetadata.getInjectionPoint().getSetter())) continue;
            if (attributeMetadata.getInjectionPoint().getProperty() != null) {
                Object value = ConfigAssertions.invoke(config, attributeMetadata.getGetter());
                attributeValues.put(attributeMetadata.getName(), value);
                continue;
            }
            setDeprecatedAttributes.add(attributeMetadata.getName());
        }
        if (!setDeprecatedAttributes.isEmpty()) {
            Assert.fail((String)("Invoked deprecated attribute setter methods: " + setDeprecatedAttributes));
        }
        if (!validSetterMethods.containsAll(invokedMethods)) {
            HashSet<Method> invalidInvocations = new HashSet<Method>(invokedMethods);
            invalidInvocations.removeAll(validSetterMethods);
            Assert.fail((String)("Invoked setter without @Config: " + invalidInvocations));
        }
        if (!metadata.getAttributes().keySet().containsAll(attributeValues.keySet())) {
            TreeSet unsupportedAttributes = new TreeSet(attributeValues.keySet());
            unsupportedAttributes.removeAll(metadata.getAttributes().keySet());
            Assert.fail((String)("Unsupported attributes: " + unsupportedAttributes));
        }
        TreeSet<String> nonDeprecatedAttributes = new TreeSet<String>();
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            if (attribute.getInjectionPoint().getProperty() == null) continue;
            nonDeprecatedAttributes.add(attribute.getName());
        }
        if (!nonDeprecatedAttributes.containsAll(attributeValues.keySet())) {
            TreeSet treeSet = new TreeSet(attributeValues.keySet());
            treeSet.removeAll(nonDeprecatedAttributes);
            Assert.fail((String)("Deprecated attributes: " + treeSet));
        }
        if (!attributeValues.keySet().containsAll(nonDeprecatedAttributes)) {
            TreeSet treeSet = new TreeSet(nonDeprecatedAttributes);
            treeSet.removeAll(attributeValues.keySet());
            Assert.fail((String)("Untested attributes: " + treeSet));
        }
        Object obj = ConfigAssertions.newDefaultInstance(configClass);
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            Method getter = attribute.getGetter();
            if (getter == null) continue;
            Object actualAttributeValue = ConfigAssertions.invoke(obj, getter);
            Object expectedAttributeValue = attributeValues.get(attribute.getName());
            Assert.assertEquals((Object)actualAttributeValue, expectedAttributeValue, (String)("Default value for " + attribute.getName()));
        }
    }

    public static <T> T recordDefaults(Class<T> type) {
        final T instance = ConfigAssertions.newDefaultInstance(type);
        Object proxy = Enhancer.create(type, (Class[])new Class[]{$$RecordingConfigProxy.class}, (Callback)new MethodInterceptor(){
            private final ConcurrentMap<Method, Object> invokedMethods = new MapMaker().makeMap();

            public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
                if (GET_RECORDING_CONFIG_METHOD.equals(method)) {
                    return new $$RecordedConfigData<Object>(instance, (Set<Method>)ImmutableSet.copyOf(this.invokedMethods.keySet()));
                }
                this.invokedMethods.put(method, Boolean.TRUE);
                Object result = methodProxy.invoke(instance, args);
                if (result == instance) {
                    return proxy;
                }
                return result;
            }
        });
        return (T)proxy;
    }

    static <T> $$RecordedConfigData<T> getRecordedConfig(T config) {
        if (!(config instanceof $$RecordingConfigProxy)) {
            throw new IllegalArgumentException("Configuration was not created with the recordDefaults method");
        }
        return (($$RecordingConfigProxy)config).$$getRecordedConfig();
    }

    private static <T> T newInstance(Class<T> configClass, Map<String, String> properties) {
        ConfigurationFactory configurationFactory = new ConfigurationFactory(properties);
        return configurationFactory.build(configClass);
    }

    private static <T> T newDefaultInstance(Class<T> configClass) {
        try {
            return configClass.newInstance();
        }
        catch (Exception e) {
            AssertionError error = new AssertionError((Object)String.format("Exception creating default instance of %s", configClass.getName()));
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
    }

    private static <T> Object invoke(T actual, Method getter) {
        try {
            return getter.invoke(actual, new Object[0]);
        }
        catch (Exception e) {
            AssertionError error = new AssertionError((Object)String.format("Exception invoking %s", getter.toGenericString()));
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
    }

    static {
        try {
            GET_RECORDING_CONFIG_METHOD = $$RecordingConfigProxy.class.getMethod("$$getRecordedConfig", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

