/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.configuration;

import com.google.inject.Inject;
import com.google.inject.Key;
import com.proofpoint.configuration.ConfigurationAwareProvider;
import com.proofpoint.configuration.ConfigurationFactory;
import com.proofpoint.configuration.ConfigurationMetadata;
import java.util.Objects;

public class ConfigurationProvider<T>
implements ConfigurationAwareProvider<T> {
    private final Key<T> key;
    private final Class<T> configClass;
    private final String prefix;
    private ConfigurationFactory configurationFactory;

    public ConfigurationProvider(Key<T> key, Class<T> configClass, String prefix) {
        Objects.requireNonNull(key, "key is null");
        Objects.requireNonNull(configClass, "configClass is null");
        this.key = key;
        this.configClass = configClass;
        this.prefix = prefix;
    }

    @Override
    @Inject
    public void setConfigurationFactory(ConfigurationFactory configurationFactory) {
        this.configurationFactory = configurationFactory;
    }

    ConfigurationFactory getConfigurationFactory() {
        return this.configurationFactory;
    }

    public Key<T> getKey() {
        return this.key;
    }

    public Class<T> getConfigClass() {
        return this.configClass;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ConfigurationMetadata<T> getConfigurationMetadata() {
        return ConfigurationMetadata.getConfigurationMetadata(this.configClass);
    }

    public T get() {
        Objects.requireNonNull(this.configurationFactory, "configurationFactory is null");
        return this.configurationFactory.build(this.configClass, this.prefix, this.key);
    }

    public int hashCode() {
        return Objects.hash(this.configClass, this.prefix);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationProvider other = (ConfigurationProvider)obj;
        return Objects.equals(this.configClass, other.configClass) && Objects.equals(this.prefix, other.prefix);
    }
}

