/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.configuration;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.ConfigurationException;
import com.google.inject.spi.Message;
import com.proofpoint.configuration.Config;
import com.proofpoint.configuration.ConfigDescription;
import com.proofpoint.configuration.ConfigSecuritySensitive;
import com.proofpoint.configuration.DefunctConfig;
import com.proofpoint.configuration.LegacyConfig;
import com.proofpoint.configuration.MapClasses;
import com.proofpoint.configuration.Problems;
import com.proofpoint.configuration.TypeParameterUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class ConfigurationMetadata<T> {
    private final Class<T> configClass;
    private final Problems problems;
    private final Constructor<T> constructor;
    private final Map<String, AttributeMetadata> attributes;
    private final Set<String> defunctConfig;

    public static <T> ConfigurationMetadata<T> getValidConfigurationMetadata(Class<T> configClass) throws ConfigurationException {
        return ConfigurationMetadata.getValidConfigurationMetadata(configClass, Problems.NULL_MONITOR);
    }

    static <T> ConfigurationMetadata<T> getValidConfigurationMetadata(Class<T> configClass, Problems.Monitor monitor) throws ConfigurationException {
        ConfigurationMetadata<T> metadata = ConfigurationMetadata.getConfigurationMetadata(configClass, monitor);
        metadata.getProblems().throwIfHasErrors();
        return metadata;
    }

    public static <T> ConfigurationMetadata<T> getConfigurationMetadata(Class<T> configClass) {
        return ConfigurationMetadata.getConfigurationMetadata(configClass, Problems.NULL_MONITOR);
    }

    static <T> ConfigurationMetadata<T> getConfigurationMetadata(Class<T> configClass, Problems.Monitor monitor) {
        return new ConfigurationMetadata<T>(configClass, monitor);
    }

    private ConfigurationMetadata(Class<T> configClass, Problems.Monitor monitor) {
        if (configClass == null) {
            throw new NullPointerException("configClass is null");
        }
        this.problems = new Problems(monitor);
        this.configClass = configClass;
        if (Modifier.isAbstract(configClass.getModifiers())) {
            this.problems.addError("Config class [%s] is abstract", configClass.getName());
        }
        this.defunctConfig = Sets.newHashSet();
        if (configClass.isAnnotationPresent(DefunctConfig.class)) {
            DefunctConfig defunctConfig = configClass.getAnnotation(DefunctConfig.class);
            if (defunctConfig.value().length < 1) {
                this.problems.addError("@DefunctConfig annotation on class [%s] is empty", configClass.getName());
            }
            for (String defunct : configClass.getAnnotation(DefunctConfig.class).value()) {
                if (defunct.isEmpty()) {
                    this.problems.addError("@DefunctConfig annotation on class [%s] contains empty values", configClass.getName());
                    continue;
                }
                if (this.defunctConfig.add(defunct)) continue;
                this.problems.addError("Defunct property '%s' is listed more than once in @DefunctConfig for class [%s]", defunct, configClass.getName());
            }
        }
        Constructor<T> constructor = null;
        try {
            constructor = configClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
        }
        catch (Exception e) {
            this.problems.addError("Configuration class [%s] does not have a no-arg constructor", configClass.getName());
        }
        this.constructor = constructor;
        this.attributes = ImmutableSortedMap.copyOf(this.buildAttributeMetadata(configClass));
        for (Class<T> clazz = configClass; clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Config.class) || !Modifier.isStatic(method.getModifiers())) continue;
                this.problems.addError("@Config method [%s] is static", method.toGenericString());
            }
        }
        if (this.problems.getErrors().isEmpty() && this.attributes.isEmpty() && this.defunctConfig.isEmpty()) {
            this.problems.addError("Configuration class [%s] does not have any @Config annotations", configClass.getName());
        }
    }

    public static boolean isConfigClass(Class<?> classz) {
        for (Method method : classz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Config.class)) continue;
            return true;
        }
        return false;
    }

    public Class<T> getConfigClass() {
        return this.configClass;
    }

    public Constructor<T> getConstructor() {
        return this.constructor;
    }

    public Map<String, AttributeMetadata> getAttributes() {
        return this.attributes;
    }

    Problems getProblems() {
        return this.problems;
    }

    private boolean validateAnnotations(Method configMethod) {
        Config config = configMethod.getAnnotation(Config.class);
        LegacyConfig legacyConfig = configMethod.getAnnotation(LegacyConfig.class);
        if (config == null) {
            this.problems.addError("Method [%s] must have @Config annotation", configMethod.toGenericString());
            return false;
        }
        boolean isValid = true;
        if (config.value().isEmpty()) {
            this.problems.addError("@Config method [%s] annotation has an empty value", configMethod.toGenericString());
            isValid = false;
        }
        if (legacyConfig != null) {
            if (legacyConfig.value().length == 0) {
                this.problems.addError("@LegacyConfig method [%s] annotation has an empty list", configMethod.toGenericString());
                isValid = false;
            }
            if (!legacyConfig.replacedBy().isEmpty()) {
                this.problems.addError("@Config method [%s] has annotation claiming to be replaced by another property ('%s')", configMethod.toGenericString(), legacyConfig.replacedBy());
                isValid = false;
            }
            for (String arrayEntry : legacyConfig.value()) {
                if (arrayEntry == null || arrayEntry.isEmpty()) {
                    this.problems.addError("@LegacyConfig method [%s] annotation contains null or empty value", configMethod.toGenericString());
                    isValid = false;
                    continue;
                }
                if (!arrayEntry.equals(config.value())) continue;
                this.problems.addError("@Config property name '%s' appears in @LegacyConfig annotation for method [%s]", config.value(), configMethod.toGenericString());
                isValid = false;
            }
        }
        return isValid;
    }

    private boolean validateSetter(final Method method) {
        boolean isValid = true;
        if (method == null) {
            return false;
        }
        if (!method.getName().startsWith("set")) {
            this.problems.addError("Method [%s] is not a valid setter (e.g. setFoo) for configuration annotation", method.toGenericString());
            return false;
        }
        if (method.getParameterTypes().length != 1) {
            this.problems.addError("Configuration setter method [%s] does not have exactly one parameter", method.toGenericString());
            return false;
        }
        if (method.getParameterTypes()[0] == Map.class) {
            Type[] mapTypes = TypeParameterUtils.getTypeParameters(Map.class, method.getGenericParameterTypes()[0]);
            if (mapTypes == null) {
                this.problems.addError("Configuration setter method [%s] Map is a raw type", method.toGenericString());
                return false;
            }
            if (!(mapTypes[0] instanceof Class)) {
                this.problems.addError("Configuration setter method [%s] Map key type is not a concrete class", method.toGenericString());
                isValid = false;
            }
            if (!(mapTypes[1] instanceof Class)) {
                this.problems.addError("Configuration setter method [%s] Map value type is not a concrete class", method.toGenericString());
                isValid = false;
            } else {
                final Class valueClass = (Class)mapTypes[1];
                if (ConfigurationMetadata.isConfigClass(valueClass)) {
                    ConfigurationMetadata.getConfigurationMetadata(valueClass, new Problems.Monitor(){

                        @Override
                        public void onError(Message errorMessage) {
                            ConfigurationMetadata.this.problems.addError(errorMessage.getCause(), "Configuration setter method [%s] Map value type %s: %s", method.toGenericString(), valueClass.getSimpleName(), errorMessage.getMessage());
                        }

                        @Override
                        public void onWarning(Message warningMessage) {
                            ConfigurationMetadata.this.problems.addWarning("Configuration setter method [%s] Map value type %s: %s", method.toGenericString(), valueClass.getSimpleName(), warningMessage.getMessage());
                        }
                    });
                }
            }
        }
        return isValid;
    }

    private Map<String, AttributeMetadata> buildAttributeMetadata(Class<T> configClass) {
        HashMap attributes = Maps.newHashMap();
        for (Method method : ConfigurationMetadata.findConfigMethods(configClass)) {
            method.setAccessible(true);
            AttributeMetadata attribute = this.buildAttributeMetadata(configClass, method);
            if (attribute == null) continue;
            if (attributes.containsKey(attribute.getName())) {
                this.problems.addError("Configuration class [%s] Multiple methods are annotated for @Config attribute [%s]", configClass.getName(), attribute.getName());
            }
            attributes.put(attribute.getName(), attribute);
        }
        Collection<Method> legacyMethods = ConfigurationMetadata.findLegacyConfigMethods(configClass);
        for (AttributeMetadata attribute : attributes.values()) {
            for (InjectionPointMetaData injectionPoint : attribute.getLegacyInjectionPoints()) {
                if (!legacyMethods.contains(injectionPoint.getSetter())) continue;
                legacyMethods.remove(injectionPoint.getSetter());
            }
        }
        for (Method method : legacyMethods) {
            if (method.isAnnotationPresent(Config.class)) continue;
            this.validateSetter(method);
            this.problems.addError("@LegacyConfig method [%s] is not associated with any valid @Config attribute.", method.toGenericString());
        }
        Collection<Method> collection = ConfigurationMetadata.findSensitiveConfigMethods(configClass);
        for (Method method : collection) {
            if (method.isAnnotationPresent(Config.class)) continue;
            this.problems.addError("@ConfigSecuritySensitive method [%s] is not annotated with @Config.", method.toGenericString());
        }
        return attributes;
    }

    private AttributeMetadata buildAttributeMetadata(Class<T> configClass, Method configMethod) {
        Method getter;
        Preconditions.checkArgument((boolean)configMethod.isAnnotationPresent(Config.class));
        if (!this.validateAnnotations(configMethod)) {
            return null;
        }
        String propertyName = configMethod.getAnnotation(Config.class).value();
        boolean securitySensitive = configMethod.isAnnotationPresent(ConfigSecuritySensitive.class);
        if (!this.validateSetter(configMethod)) {
            return null;
        }
        MapClasses mapClasses = ConfigurationMetadata.createMapClasses(configMethod);
        String attributeName = configMethod.getName().substring(3);
        AttributeMetaDataBuilder builder = new AttributeMetaDataBuilder(configClass, attributeName, securitySensitive, mapClasses);
        if (configMethod.isAnnotationPresent(ConfigDescription.class)) {
            builder.setDescription(configMethod.getAnnotation(ConfigDescription.class).value());
        }
        if ((getter = this.findGetter(configClass, configMethod, attributeName)) != null) {
            getter.setAccessible(true);
            builder.setGetter(getter);
            if (configMethod.isAnnotationPresent(Deprecated.class) != getter.isAnnotationPresent(Deprecated.class)) {
                this.problems.addError("Methods [%s] and [%s] must be @Deprecated together", configMethod, getter);
            }
        }
        if (this.defunctConfig.contains(propertyName)) {
            this.problems.addError("@Config property '%s' on method [%s] is defunct on class [%s]", propertyName, configMethod, configClass);
        }
        builder.addInjectionPoint(InjectionPointMetaData.newCurrent(configClass, propertyName, configMethod, mapClasses));
        for (InjectionPointMetaData injectionPoint : this.findLegacySetters(configClass, propertyName, attributeName)) {
            if (!injectionPoint.getSetter().isAnnotationPresent(Config.class) && !injectionPoint.getSetter().isAnnotationPresent(Deprecated.class)) {
                this.problems.addWarning("Replaced @LegacyConfig method [%s] should be @Deprecated", injectionPoint.getSetter().toGenericString());
            }
            builder.addInjectionPoint(injectionPoint);
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationMetadata that = (ConfigurationMetadata)o;
        return this.configClass.equals(that.configClass);
    }

    public int hashCode() {
        return this.configClass.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("configClass", this.configClass).toString();
    }

    @Nullable
    private static MapClasses createMapClasses(Method setter) {
        MapClasses mapClasses = null;
        if (setter.getParameterTypes()[0] == Map.class) {
            Type[] mapTypes = TypeParameterUtils.getTypeParameters(Map.class, setter.getGenericParameterTypes()[0]);
            mapClasses = new MapClasses((Class)mapTypes[0], (Class)mapTypes[1]);
        }
        return mapClasses;
    }

    private static Collection<Method> findConfigMethods(Class<?> configClass) {
        return ConfigurationMetadata.findAnnotatedMethods(configClass, Config.class);
    }

    private static Collection<Method> findLegacyConfigMethods(Class<?> configClass) {
        return ConfigurationMetadata.findAnnotatedMethods(configClass, LegacyConfig.class);
    }

    private static Collection<Method> findSensitiveConfigMethods(Class<?> configClass) {
        return ConfigurationMetadata.findAnnotatedMethods(configClass, ConfigSecuritySensitive.class);
    }

    private static Collection<Method> findAnnotatedMethods(Class<?> configClass, Class<? extends Annotation> annotation) {
        HashBasedTable methodTable = HashBasedTable.create();
        for (Class<?> aClass = configClass; aClass != Object.class; aClass = aClass.getSuperclass()) {
            for (Method method : aClass.getDeclaredMethods()) {
                Method managedMethod;
                if (methodTable.contains((Object)method.getName(), method.getParameterTypes()) || method.isSynthetic() || method.isBridge() || Modifier.isStatic(method.getModifiers()) || (managedMethod = ConfigurationMetadata.findAnnotatedMethod(configClass, annotation, method.getName(), method.getParameterTypes())) == null) continue;
                methodTable.put((Object)method.getName(), method.getParameterTypes(), (Object)managedMethod);
            }
        }
        return methodTable.values();
    }

    public static Method findAnnotatedMethod(Class<?> configClass, Class<? extends Annotation> annotation, String methodName, Class<?> ... paramTypes) {
        Method managedMethod;
        try {
            Method method = configClass.getDeclaredMethod(methodName, paramTypes);
            if (method != null && method.isAnnotationPresent(annotation)) {
                return method;
            }
        }
        catch (NoSuchMethodException method) {
            // empty catch block
        }
        if (configClass.getSuperclass() != null && (managedMethod = ConfigurationMetadata.findAnnotatedMethod(configClass.getSuperclass(), annotation, methodName, paramTypes)) != null) {
            return managedMethod;
        }
        for (Class<?> iface : configClass.getInterfaces()) {
            Method managedMethod2 = ConfigurationMetadata.findAnnotatedMethod(iface, annotation, methodName, paramTypes);
            if (managedMethod2 == null) continue;
            return managedMethod2;
        }
        return null;
    }

    private Set<InjectionPointMetaData> findLegacySetters(Class<?> configClass, String propertyName, String attributeName) {
        HashSet setters = Sets.newHashSet();
        String setterName = "set" + attributeName;
        for (Class<?> clazz = configClass; clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            for (Method method : clazz.getDeclaredMethods()) {
                method.setAccessible(true);
                if (!ConfigurationMetadata.isUsableMethod(method)) continue;
                if (method.getName().equals(setterName) && method.isAnnotationPresent(LegacyConfig.class)) {
                    if (!this.validateSetter(method)) continue;
                    for (String property : method.getAnnotation(LegacyConfig.class).value()) {
                        if (this.defunctConfig.contains(property)) {
                            this.problems.addError("@LegacyConfig property '%s' on method [%s] is defunct on class [%s]", property, method, configClass);
                        }
                        if (!property.equals(propertyName)) {
                            setters.add(InjectionPointMetaData.newLegacy(configClass, property, method));
                            continue;
                        }
                        this.problems.addError("@LegacyConfig property '%s' on method [%s] is replaced by @Config property of same name on method [%s]", property, method.toGenericString(), setterName);
                    }
                    continue;
                }
                if (!method.isAnnotationPresent(LegacyConfig.class) || !method.getAnnotation(LegacyConfig.class).replacedBy().equals(propertyName) || !this.validateSetter(method)) continue;
                for (String property : method.getAnnotation(LegacyConfig.class).value()) {
                    if (this.defunctConfig.contains(property)) {
                        this.problems.addError("@LegacyConfig property '%s' on method [%s] is defunct on class [%s]", property, method, configClass);
                    }
                    if (!property.equals(propertyName)) {
                        setters.add(InjectionPointMetaData.newLegacy(configClass, property, method));
                        continue;
                    }
                    this.problems.addError("@LegacyConfig property '%s' on method [%s] is replaced by @Config property of same name on method [%s]", property, method.toGenericString(), setterName);
                }
            }
        }
        return setters;
    }

    private Method findGetter(Class<?> configClass, Method configMethod, String attributeName) {
        String getterName = "get" + attributeName;
        String isName = "is" + attributeName;
        ArrayList<Method> getters = new ArrayList<Method>();
        ArrayList<Method> unusableGetters = new ArrayList<Method>();
        for (Class<?> clazz = configClass; clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(getterName) && !method.getName().equals(isName)) continue;
                if (ConfigurationMetadata.isUsableMethod(method) && !method.getReturnType().equals(Void.TYPE) && method.getParameterTypes().length == 0) {
                    getters.add(method);
                    continue;
                }
                unusableGetters.add(method);
            }
        }
        if (getters.isEmpty()) {
            String unusable = "";
            if (!unusableGetters.isEmpty()) {
                StringBuilder builder = new StringBuilder(" The following methods are unusable: ");
                for (Method method : unusableGetters) {
                    builder.append('[').append(method.toGenericString()).append(']');
                }
                unusable = builder.toString();
            }
            this.problems.addError("No getter for @Config method [%s].%s", configMethod.toGenericString(), unusable);
            return null;
        }
        if (getters.size() > 1) {
            this.problems.addError("Multiple getters found for @Config setter [%s]", configMethod.toGenericString());
            return null;
        }
        return (Method)getters.get(0);
    }

    private static boolean isUsableMethod(Method method) {
        return !method.isSynthetic() && !method.isBridge() && !Modifier.isStatic(method.getModifiers());
    }

    private static class AttributeMetaDataBuilder {
        private final Class<?> configClass;
        private final String name;
        private String description = null;
        private Method getter = null;
        private InjectionPointMetaData injectionPoint = null;
        private final Set<InjectionPointMetaData> legacyInjectionPoints = Sets.newHashSet();
        private final boolean securitySensitive;
        private final MapClasses mapClasses;

        AttributeMetaDataBuilder(Class<?> configClass, String name, boolean securitySensitive, @Nullable MapClasses mapClasses) {
            Preconditions.checkNotNull(configClass);
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
            this.configClass = configClass;
            this.name = name;
            this.securitySensitive = securitySensitive;
            this.mapClasses = mapClasses;
        }

        public void setDescription(String description) {
            Preconditions.checkNotNull((Object)description);
            this.description = description;
        }

        public void setGetter(Method getter) {
            Preconditions.checkNotNull((Object)getter);
            this.getter = getter;
        }

        public void addInjectionPoint(InjectionPointMetaData injectionPointMetaData) {
            Preconditions.checkNotNull((Object)injectionPointMetaData);
            if (injectionPointMetaData.isLegacy()) {
                this.legacyInjectionPoints.add(injectionPointMetaData);
                return;
            }
            if (this.injectionPoint != null) {
                throw Problems.exceptionFor("Trying to set current property twice: '%s' on method [%s] and '%s' on method [%s]", this.injectionPoint.getProperty(), this.injectionPoint.getSetter().toGenericString(), injectionPointMetaData.getProperty(), injectionPointMetaData.getSetter().toGenericString());
            }
            this.injectionPoint = injectionPointMetaData;
        }

        public AttributeMetadata build() {
            if (this.getter == null) {
                return null;
            }
            return new AttributeMetadata(this.configClass, this.name, this.description, this.securitySensitive, this.mapClasses, this.getter, this.injectionPoint, this.legacyInjectionPoints);
        }
    }

    public static class AttributeMetadata {
        private final Class<?> configClass;
        private final String name;
        private final String description;
        private final boolean securitySensitive;
        private final Method getter;
        private final InjectionPointMetaData injectionPoint;
        private final Set<InjectionPointMetaData> legacyInjectionPoints;
        private final MapClasses mapClasses;

        private AttributeMetadata(Class<?> configClass, String name, String description, boolean securitySensitive, @Nullable MapClasses mapClasses, Method getter, InjectionPointMetaData injectionPoint, Set<InjectionPointMetaData> legacyInjectionPoints) {
            Preconditions.checkNotNull(configClass);
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)getter);
            Preconditions.checkNotNull((Object)injectionPoint);
            Preconditions.checkNotNull(legacyInjectionPoints);
            this.configClass = configClass;
            this.name = name;
            this.description = description;
            this.securitySensitive = securitySensitive;
            this.mapClasses = mapClasses;
            this.getter = getter;
            this.injectionPoint = injectionPoint;
            this.legacyInjectionPoints = ImmutableSet.copyOf(legacyInjectionPoints);
        }

        public Class<?> getConfigClass() {
            return this.configClass;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isSecuritySensitive() {
            return this.securitySensitive;
        }

        public MapClasses getMapClasses() {
            return this.mapClasses;
        }

        public Method getGetter() {
            return this.getter;
        }

        public InjectionPointMetaData getInjectionPoint() {
            return this.injectionPoint;
        }

        public Set<InjectionPointMetaData> getLegacyInjectionPoints() {
            return this.legacyInjectionPoints;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributeMetadata that = (AttributeMetadata)o;
            if (!this.configClass.equals(that.configClass)) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.configClass.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
        }
    }

    public static class InjectionPointMetaData {
        private final Class<?> configClass;
        private final String property;
        private final Method setter;
        private final boolean current;
        private final MapClasses mapClasses;

        private static InjectionPointMetaData newCurrent(Class<?> configClass, String property, Method setter, @Nullable MapClasses mapClasses) {
            return new InjectionPointMetaData(configClass, property, setter, mapClasses, true);
        }

        private static InjectionPointMetaData newLegacy(Class<?> configClass, String property, Method setter) {
            return new InjectionPointMetaData(configClass, property, setter, ConfigurationMetadata.createMapClasses(setter), false);
        }

        private InjectionPointMetaData(Class<?> configClass, String property, Method setter, @Nullable MapClasses mapClasses, boolean current) {
            Preconditions.checkNotNull(configClass);
            Preconditions.checkNotNull((Object)property);
            Preconditions.checkNotNull((Object)setter);
            Preconditions.checkArgument((!property.isEmpty() ? 1 : 0) != 0);
            this.configClass = configClass;
            this.property = property;
            this.setter = setter;
            this.mapClasses = mapClasses;
            this.current = current;
        }

        public Class<?> getConfigClass() {
            return this.configClass;
        }

        public String getProperty() {
            return this.property;
        }

        public Method getSetter() {
            return this.setter;
        }

        public MapClasses getMapClasses() {
            return this.mapClasses;
        }

        public boolean isConfigMap() {
            return this.mapClasses != null;
        }

        public boolean isLegacy() {
            return !this.current;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InjectionPointMetaData that = (InjectionPointMetaData)o;
            if (!this.configClass.equals(that.configClass)) {
                return false;
            }
            return this.property.equals(that.property);
        }

        public int hashCode() {
            int result = this.configClass.hashCode();
            result = 31 * result + this.property.hashCode();
            return result;
        }
    }
}

